/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.lib.explorer;

import org.eclipse.birt.core.preference.IPreferenceChangeListener;
import org.eclipse.birt.core.preference.IPreferences;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.lib.explorer.LibraryExplorerTreeViewPage;
import org.eclipse.birt.report.designer.ui.preferences.PreferenceFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.IContributedContentsView;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.MessagePage;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.PageBookView;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class LibraryExplorerView
extends PageBookView {
    public static final String ID = "org.eclipse.birt.report.designer.ui.lib.explorer.view";
    private String defaultText = Messages.getString((String)"LibraryExplorerView.defaultText.notAvailable");
    private LibraryExplorerTreeViewPage treeViewPage;
    private String resourceFolder;
    private IPreferences prefs;

    protected IPage createDefaultPage(PageBook book) {
        MessagePage page = new MessagePage();
        this.initPage((IPageBookViewPage)page);
        page.createControl((Composite)book);
        page.setMessage(this.defaultText);
        return page;
    }

    protected PageBookView.PageRec getPageRec(IWorkbenchPart part) {
        PageBookView.PageRec rec = super.getPageRec(part);
        if (this.treeViewPage != null && !this.treeViewPage.isDisposed()) {
            if (this.prefs != null) {
                this.prefs.removePreferenceChangeListener((IPreferenceChangeListener)this.treeViewPage);
            }
            this.prefs = PreferenceFactory.getInstance().getPreferences((AbstractUIPlugin)ReportPlugin.getDefault(), UIUtil.getCurrentProject());
            this.prefs.addPreferenceChangeListener((IPreferenceChangeListener)this.treeViewPage);
            String currentResourceFolder = ReportPlugin.getDefault().getResourceFolder();
            if (currentResourceFolder != null && !currentResourceFolder.equals(this.resourceFolder)) {
                this.treeViewPage.refreshRoot();
                this.resourceFolder = currentResourceFolder;
            }
        }
        return rec;
    }

    protected PageBookView.PageRec doCreatePage(IWorkbenchPart part) {
        if (this.treeViewPage == null || this.treeViewPage.isDisposed()) {
            this.treeViewPage = new LibraryExplorerTreeViewPage();
            this.initPage((IPageBookViewPage)this.treeViewPage);
            this.treeViewPage.createControl((Composite)this.getPageBook());
        }
        return new PageBookView.PageRec(part, (IPage)this.treeViewPage);
    }

    protected void doDestroyPage(IWorkbenchPart part, PageBookView.PageRec pageRecord) {
        if (this.treeViewPage != null && this.prefs != null) {
            this.prefs.removePreferenceChangeListener((IPreferenceChangeListener)this.treeViewPage);
        }
        this.resourceFolder = null;
        IPage page = pageRecord.page;
        page.dispose();
        pageRecord.dispose();
    }

    protected IWorkbenchPart getBootstrapPart() {
        IWorkbenchPage page = this.getSite().getPage();
        if (page != null) {
            return page.getActiveEditor();
        }
        return null;
    }

    protected boolean isImportant(IWorkbenchPart part) {
        return part instanceof IEditorPart;
    }

    public Object getAdapter(Class key) {
        if (key == IContributedContentsView.class) {
            return new IContributedContentsView(){

                public IWorkbenchPart getContributingPart() {
                    return LibraryExplorerView.this.getCurrentContributingPart();
                }
            };
        }
        return super.getAdapter(key);
    }

    public void partBroughtToTop(IWorkbenchPart part) {
        super.partBroughtToTop(part);
        this.partActivated(part);
    }
}

