/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.lib.explorer.action;

import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.lib.explorer.resource.ReportResourceEntry;
import org.eclipse.birt.report.designer.util.DNDUtil;
import org.eclipse.birt.report.model.api.CascadingParameterGroupHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.EmbeddedImageHandle;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ParameterGroupHandle;
import org.eclipse.birt.report.model.api.ParameterHandle;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.views.contentoutline.ContentOutline;

public class AddElementtoReport
extends Action {
    private StructuredViewer viewer;
    private Object element;
    private int canContain;
    private Object target;
    private static final String ACTION_TEXT = Messages.getString((String)"AddElementtoAction.Text");

    public void setSelectedElement(Object element) {
        this.element = element instanceof ReportResourceEntry ? ((ReportResourceEntry)element).getReportElement() : element;
    }

    public AddElementtoReport(StructuredViewer viewer) {
        super(ACTION_TEXT);
        this.viewer = viewer;
        this.canContain = 0;
    }

    public boolean isEnabled() {
        Object target;
        this.target = target = this.getTarget();
        return this.canContain(target, this.element);
    }

    public Object getTarget() {
        StructuredSelection strSelection;
        IViewPart viewPart = UIUtil.getView((String)"org.eclipse.ui.views.ContentOutline");
        if (!(viewPart instanceof ContentOutline)) {
            return null;
        }
        ContentOutline outlineView = (ContentOutline)viewPart;
        ISelection selection = outlineView.getSelection();
        if (selection instanceof StructuredSelection && (strSelection = (StructuredSelection)selection).size() == 1) {
            return strSelection.getFirstElement();
        }
        return null;
    }

    public void run() {
        SessionHandleAdapter.getInstance().getCommandStack().startTrans(ACTION_TEXT);
        try {
            this.copyData(this.target, this.element);
            SessionHandleAdapter.getInstance().getCommandStack().commit();
        }
        catch (Exception exception) {
            SessionHandleAdapter.getInstance().getCommandStack().rollback();
        }
    }

    protected boolean canContain(Object target, Object transfer) {
        if (transfer instanceof DataSetHandle || transfer instanceof DataSourceHandle || transfer instanceof ParameterHandle || transfer instanceof ParameterGroupHandle || transfer instanceof CascadingParameterGroupHandle || transfer instanceof CubeHandle) {
            return true;
        }
        if (DNDUtil.handleValidateTargetCanContainMore((Object)target, (int)DNDUtil.getObjectLength((Object)transfer))) {
            this.canContain = DNDUtil.handleValidateTargetCanContain((Object)target, (Object)transfer, (boolean)true);
            return this.canContain == 1;
        }
        return false;
    }

    private int getPosition(Object target) {
        int position = DNDUtil.calculateNextPosition((Object)target, (int)this.canContain);
        if (position > -1) {
            this.target = DNDUtil.getDesignElementHandle((Object)target).getContainerSlotHandle();
        }
        return position;
    }

    protected boolean copyData(Object target, Object transfer) {
        boolean result;
        block17: {
            ModuleHandle moduleHandle = SessionHandleAdapter.getInstance().getReportDesignHandle();
            if (transfer instanceof DataSetHandle) {
                target = moduleHandle.getDataSets();
            } else if (transfer instanceof DataSourceHandle) {
                target = moduleHandle.getDataSources();
            } else if (transfer instanceof ParameterHandle || transfer instanceof ParameterGroupHandle || transfer instanceof CascadingParameterGroupHandle) {
                target = moduleHandle.getParameters();
            } else if (transfer instanceof CubeHandle) {
                target = moduleHandle.getCubes();
            }
            int position = this.getPosition(target);
            result = false;
            if (transfer != null && transfer instanceof DesignElementHandle) {
                DesignElementHandle sourceHandle = (DesignElementHandle)transfer;
                if (sourceHandle.getRoot() instanceof LibraryHandle) {
                    LibraryHandle library = (LibraryHandle)sourceHandle.getRoot();
                    try {
                        if (moduleHandle != library) {
                            if (UIUtil.includeLibrary((ModuleHandle)moduleHandle, (LibraryHandle)library)) {
                                DNDUtil.addElementHandle((Object)target, (DesignElementHandle)moduleHandle.getElementFactory().newElementFrom(sourceHandle, sourceHandle.getName()));
                                result = true;
                            }
                            break block17;
                        }
                        result = DNDUtil.copyHandles((Object)transfer, (Object)target, (int)position);
                    }
                    catch (Exception e) {
                        ExceptionHandler.handle((Throwable)e);
                    }
                } else {
                    result = DNDUtil.copyHandles((Object)transfer, (Object)target, (int)position);
                }
            } else if (transfer != null && transfer instanceof EmbeddedImageHandle) {
                result = DNDUtil.copyHandles((Object)transfer, (Object)target, (int)position);
            }
        }
        if (result) {
            this.viewer.reveal(target);
        }
        return result;
    }
}

