/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.lib.explorer.action;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.lib.explorer.LibraryExplorerTreeViewPage;
import org.eclipse.birt.report.designer.ui.lib.explorer.action.ResourceAction;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

public class CopyResourceAction
extends ResourceAction {
    private Clipboard clipboard;

    public CopyResourceAction(LibraryExplorerTreeViewPage page, Clipboard clipboard) {
        super(Messages.getString((String)"CopyLibraryAction.Text"), page);
        this.clipboard = clipboard;
        this.setId(ActionFactory.COPY.getId());
        this.setAccelerator(262211);
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY"));
        this.setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
    }

    public boolean isEnabled() {
        try {
            return !this.getSelectedFiles().isEmpty();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public void run() {
        Collection<File> files = null;
        try {
            files = this.getSelectedFiles();
        }
        catch (IOException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        if (files == null || files.isEmpty()) {
            return;
        }
        int length = files.size();
        int actualLength = 0;
        String[] fileNames = new String[length];
        for (File file : files) {
            Path location = new Path(file.getAbsolutePath());
            if (location == null) continue;
            fileNames[actualLength++] = location.toOSString();
        }
        if (actualLength < length) {
            String[] tempFileNames = fileNames;
            fileNames = new String[actualLength];
            int i = 0;
            while (i < actualLength) {
                fileNames[i] = tempFileNames[i];
                ++i;
            }
        }
        this.setClipboard(fileNames);
    }

    private void setClipboard(String[] fileNames) {
        if (fileNames.length > 0) {
            this.clipboard.setContents(new Object[]{fileNames}, new Transfer[]{FileTransfer.getInstance()});
        }
    }
}

