/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.viewer.utilities;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class MarkerUtil {
    public static final String PROBLEMS_MARKER_ID = "org.eclipse.birt.report.viewer.ViewerProblemMarker";
    public static final String ELEMENT_ID = "ElementId";
    private static IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();

    public static void addMarker(String systemId, String message, long elementId, int lineNumber, int severity, int priority) throws CoreException {
        IResource resource = MarkerUtil.createResourceFromSystemID(systemId);
        MarkerUtil.addMarker(resource, message, elementId, lineNumber, severity, priority);
    }

    public static void addMarker(IResource resource, String message, long elementId, int lineNumber, int severity, int priority) throws CoreException {
        if (resource != null) {
            IMarker marker = resource.createMarker(PROBLEMS_MARKER_ID);
            if (message != null) {
                marker.setAttribute("message", (Object)message);
            }
            if (lineNumber >= 0) {
                marker.setAttribute("lineNumber", lineNumber);
            }
            if (elementId > 0L) {
                marker.setAttribute(ELEMENT_ID, (Object)new Integer((int)elementId));
            }
            marker.setAttribute("severity", severity);
            marker.setAttribute("priority", priority);
        }
    }

    public static void clear(String systemId) throws CoreException {
        IResource resource = MarkerUtil.createResourceFromSystemID(systemId);
        MarkerUtil.clear(resource);
    }

    public static void clear(IResource resource) throws CoreException {
        if (resource != null) {
            resource.deleteMarkers(PROBLEMS_MARKER_ID, true, 2);
        }
    }

    public static void error(String systemId, String message, long elementId, int lineNumber) throws CoreException {
        MarkerUtil.addMarker(systemId, message, elementId, lineNumber, 2, 1);
    }

    public static void fatal(String systemId, String message, long elementId, int lineNumber) throws CoreException {
        MarkerUtil.addMarker(systemId, message, elementId, lineNumber, 2, 2);
    }

    public static void warning(String systemId, String message, long elementId, int lineNumber) throws CoreException {
        MarkerUtil.addMarker(systemId, message, elementId, lineNumber, 1, 0);
    }

    public static void info(String systemId, String message, long elementId, int lineNumber) throws CoreException {
        MarkerUtil.addMarker(systemId, message, elementId, lineNumber, 0, 1);
    }

    public static IResource createResourceFromSystemID(String systemID) {
        Path path = new Path(systemID);
        IFile resource = workspaceRoot.getFileForLocation((IPath)path);
        if (resource == null) {
            resource = workspaceRoot.getContainerForLocation((IPath)path);
        }
        return resource;
    }
}

