/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.device.swt;

import java.util.ArrayList;
import org.eclipse.birt.chart.computation.IConstants;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.device.TextAdapter;
import org.eclipse.birt.chart.device.swt.SwtDisplayServer;
import org.eclipse.birt.chart.model.attribute.Insets;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.TextLayout;

public final class SwtTextMetrics
extends TextAdapter {
    private int iLineCount = 0;
    private double cachedWidth;
    private String[] oText = null;
    private GC gc = null;
    private Label la = null;
    private final IDisplayServer ids;
    private Font font;
    private Insets ins;

    public SwtTextMetrics(IDisplayServer _ids, Label _la, GC gc) {
        this.gc = gc;
        this.ids = _ids;
        this.la = _la;
        this.reuse(this.la);
    }

    public final void reuse(Label la, double forceWrappingSize) {
        this.cachedWidth = Double.NaN;
        String s = la.getCaption().getValue();
        s = s == null ? IConstants.NULL_STRING : s.trim();
        String[] sa = this.splitOnBreaks(s, forceWrappingSize);
        if (sa == null) {
            this.iLineCount = 1;
            this.oText = new String[]{s};
        } else {
            this.iLineCount = sa.length;
            this.oText = sa;
        }
        this.ins = la.getInsets().scaledInstance((double)this.ids.getDpiResolution() / 72.0);
        if (forceWrappingSize > 0.0) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < this.oText.length) {
                sb.append(this.oText[i]).append("\n");
                ++i;
            }
            if (sb.length() > 0) {
                sb.deleteCharAt(sb.length() - 1);
            }
            la.getCaption().setValue(sb.toString());
        }
    }

    public final void dispose() {
        this.disposeFont();
    }

    public void disposeFont() {
        if (this.font != null) {
            this.font.dispose();
            this.font = null;
        }
    }

    public final boolean isDisposed() {
        return this.gc.isDisposed();
    }

    protected Font getFont() {
        if (this.font == null) {
            this.font = (Font)this.ids.createFont(this.la.getCaption().getFont());
        }
        return this.font;
    }

    public final double getHeight() {
        this.gc.setFont(this.getFont());
        int iHeight = this.gc.getFontMetrics().getHeight();
        return iHeight;
    }

    public final double getDescent() {
        this.gc.setFont(this.getFont());
        int iDescent = this.gc.getFontMetrics().getDescent();
        return iDescent;
    }

    private final double stringWidth() {
        if (!Double.isNaN(this.cachedWidth)) {
            return this.cachedWidth;
        }
        this.cachedWidth = 0.0;
        this.gc.setFont(this.getFont());
        if (this.iLineCount > 1) {
            String[] sa = this.oText;
            int i = 0;
            while (i < this.iLineCount) {
                double dWidth = this.gc.textExtent((String)sa[i]).x;
                if (dWidth > this.cachedWidth) {
                    this.cachedWidth = dWidth;
                }
                ++i;
            }
        } else {
            this.cachedWidth = this.gc.textExtent((String)this.oText[0]).x;
        }
        return this.cachedWidth;
    }

    public final double getFullHeight() {
        return this.getHeight() * (double)this.getLineCount() + this.ins.getTop() + this.ins.getBottom();
    }

    public final double getFullHeight(double fontHeight) {
        return fontHeight * (double)this.getLineCount() + this.ins.getTop() + this.ins.getBottom();
    }

    public final double getFullWidth() {
        return this.stringWidth() + this.ins.getLeft() + this.ins.getRight();
    }

    public final int getLineCount() {
        return this.iLineCount;
    }

    public final String getLine(int iIndex) {
        return this.iLineCount > 1 ? this.oText[iIndex] : this.oText[0];
    }

    private String[] splitOnBreaks(String s, double maxSize) {
        int n;
        int j;
        ArrayList<String> al = new ArrayList<String>();
        int i = 0;
        do {
            String ss;
            if ((j = s.indexOf(10, i)) == -1) {
                j = s.length();
            }
            if ((ss = s.substring(i, j)) != null && ss.length() > 0) {
                al.add(ss);
            }
            i = j + 1;
        } while (j != -1 && j < s.length());
        if (maxSize > 0.0) {
            TextLayout tl = new TextLayout(((SwtDisplayServer)this.ids).getDevice());
            tl.setFont(this.getFont());
            tl.setWidth((int)maxSize);
            ArrayList<String> nal = new ArrayList<String>();
            for (String ns : al) {
                tl.setText(ns);
                int[] offsets = tl.getLineOffsets();
                i = 1;
                while (i < offsets.length) {
                    String ss = ns.substring(offsets[i - 1], offsets[i]);
                    nal.add(ss);
                    ++i;
                }
            }
            tl.dispose();
            al = nal;
        }
        if ((n = al.size()) == 1 || n == 0) {
            return null;
        }
        String[] sa = new String[n];
        i = 0;
        while (i < al.size()) {
            sa[i] = (String)al.get(i);
            ++i;
        }
        return sa;
    }
}

