/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.internal.ui.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.birt.report.item.crosstab.core.de.AggregationCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.MeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.core.util.CrosstabUtil;
import org.eclipse.birt.report.item.crosstab.internal.ui.AggregationCellProviderWrapper;
import org.eclipse.birt.report.item.crosstab.internal.ui.dialogs.AggregationDialog;
import org.eclipse.birt.report.item.crosstab.internal.ui.dialogs.TotalProvider;
import org.eclipse.birt.report.item.crosstab.ui.extension.IAggregationCellViewProvider;
import org.eclipse.birt.report.item.crosstab.ui.extension.SwitchCellInfo;
import org.eclipse.birt.report.item.crosstab.ui.i18n.Messages;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;

public class GrandTotalProvider
extends TotalProvider
implements ITableLabelProvider,
IStructuredContentProvider,
ICellModifier {
    private int axis;
    private CellEditor[] cellEditor;
    TableViewer viewer;
    private String[] comboItems = null;
    private String[] viewNames;
    private CrosstabReportItemHandle crosstab;
    private AggregationCellProviderWrapper cellProviderWrapper;
    private String[] columnNames = new String[]{"", Messages.getString("GrandTotalProvider.Column.AggregateOn"), Messages.getString("GrandTotalProvider.Column.View")};

    private void initializeItems(AggregationDialog.GrandTotalInfo grandTotalInfo) {
        Messages.getString("GrandTotalProvider.ViewStatus");
        ArrayList<String> viewNameList = new ArrayList<String>();
        ArrayList<String> itemList = new ArrayList<String>();
        AggregationCellHandle cell = this.getAggregationCell(grandTotalInfo);
        if (cell != null && this.cellProviderWrapper.getMatchProvider(cell) == null) {
            itemList.add("");
            viewNameList.add("");
        }
        IAggregationCellViewProvider[] providers = this.cellProviderWrapper.getAllProviders();
        int i = 0;
        while (i < providers.length) {
            IAggregationCellViewProvider tmp = providers[i];
            if (tmp != null) {
                SwitchCellInfo info = new SwitchCellInfo(this.crosstab, 1);
                info.setGrandTotalInfo(grandTotalInfo, this.axis);
                if (providers[i].canSwitch(info)) {
                    String displayName = tmp.getViewDisplayName();
                    viewNameList.add(tmp.getViewName());
                    itemList.add(Messages.getString("GrandTotalProvider.ShowAs", new String[]{displayName}));
                }
            }
            ++i;
        }
        this.comboItems = itemList.toArray(new String[itemList.size()]);
        this.viewNames = viewNameList.toArray(new String[viewNameList.size()]);
    }

    public GrandTotalProvider(TableViewer viewer, CrosstabReportItemHandle crosstab, int axis) {
        this.viewer = viewer;
        this.crosstab = crosstab;
        this.axis = axis;
        this.cellProviderWrapper = new AggregationCellProviderWrapper(crosstab);
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public CellEditor[] getCellEditors() {
        if (this.cellEditor != null) {
            return this.cellEditor;
        }
        ComboBoxCellEditor comboCell = new ComboBoxCellEditor((Composite)this.viewer.getTable(), new String[0], 8);
        CellEditor[] cellEditorArray = new CellEditor[3];
        cellEditorArray[2] = comboCell;
        this.cellEditor = cellEditorArray;
        return this.cellEditor;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        AggregationDialog.GrandTotalInfo info = (AggregationDialog.GrandTotalInfo)element;
        switch (columnIndex) {
            case 0: {
                return "";
            }
            case 1: {
                return info.getMeasureDisplayName() == null ? "" : info.getMeasureDisplayName();
            }
            case 2: {
                int index;
                this.initializeItems(info);
                ((ComboBoxCellEditor)this.cellEditor[2]).setItems(this.comboItems);
                String expectedView = info.getExpectedView();
                if (expectedView == null) {
                    expectedView = "";
                }
                if ((index = Arrays.asList(this.viewNames).indexOf(expectedView)) <= 0) {
                    index = 0;
                    info.setExpectedView(this.viewNames[index]);
                }
                return this.comboItems[index];
            }
        }
        return "";
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof List) {
            return ((List)inputElement).toArray();
        }
        return new Object[0];
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public int[] columnWidths() {
        return new int[]{20, 210, 120};
    }

    public boolean canModify(Object element, String property) {
        if (Arrays.asList(this.columnNames).indexOf(property) == 2) {
            if (this.viewer instanceof CheckboxTableViewer) {
                return ((CheckboxTableViewer)this.viewer).getChecked(element);
            }
            return true;
        }
        return false;
    }

    public Object getValue(Object element, String property) {
        if (element instanceof Item) {
            element = ((Item)element).getData();
        }
        Integer value = null;
        int index = Arrays.asList(this.columnNames).indexOf(property);
        switch (index) {
            case 1: {
                break;
            }
            case 2: {
                this.initializeItems((AggregationDialog.GrandTotalInfo)element);
                ((ComboBoxCellEditor)this.cellEditor[2]).setItems(this.comboItems);
                String expectedView = ((AggregationDialog.GrandTotalInfo)element).getExpectedView();
                if (expectedView == null || expectedView.length() == 0) {
                    return new Integer(0);
                }
                int sel = Arrays.asList(this.viewNames).indexOf(expectedView);
                value = sel <= 0 ? new Integer(0) : new Integer(sel);
            }
        }
        return value;
    }

    public void modify(Object element, String property, Object value) {
        if (element instanceof Item) {
            element = ((Item)element).getData();
        }
        int index = Arrays.asList(this.columnNames).indexOf(property);
        switch (index) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                int sel = (Integer)value;
                if (sel == 0) {
                    ((AggregationDialog.GrandTotalInfo)element).setExpectedView("");
                    break;
                }
                ((AggregationDialog.GrandTotalInfo)element).setExpectedView(this.viewNames[sel]);
            }
        }
        this.viewer.refresh();
    }

    private AggregationCellHandle getAggregationCell(AggregationDialog.GrandTotalInfo grandTotalInfo) {
        AggregationCellHandle cell = null;
        MeasureViewHandle measureView = this.crosstab.getMeasure(grandTotalInfo.getMeasureQualifiedName());
        if (measureView == null) {
            return cell;
        }
        int counterAxisType = CrosstabUtil.getOppositeAxisType((int)this.axis);
        DimensionViewHandle counterDimension = this.crosstab.getDimension(counterAxisType, this.crosstab.getDimensionCount(counterAxisType) - 1);
        String counterDimensionName = null;
        String counterLevelName = null;
        if (counterDimension != null) {
            counterDimensionName = counterDimension.getCubeDimensionName();
            counterLevelName = counterDimension.getLevel(counterDimension.getLevelCount() - 1).getCubeLevelName();
        }
        String rowDimension = null;
        String rowLevel = null;
        String colDimension = null;
        String colLevel = null;
        if (this.axis == 0) {
            colDimension = counterDimensionName;
            colLevel = counterLevelName;
        } else if (this.axis == 1) {
            rowDimension = counterDimensionName;
            rowLevel = counterLevelName;
        }
        cell = measureView.getAggregationCell(rowDimension, rowLevel, colDimension, colLevel);
        return cell;
    }
}

