/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.internal.ui.editors.action;

import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.ui.newelement.DesignElementFactory;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.item.crosstab.core.de.AggregationCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.ComputedMeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.MeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.internal.ui.dialogs.AddComputedSummaryDialog;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.action.AbstractCrosstabAction;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.CrosstabAdaptUtil;
import org.eclipse.birt.report.item.crosstab.internal.ui.util.CrosstabUIHelper;
import org.eclipse.birt.report.item.crosstab.ui.i18n.Messages;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class AddComputedMeasureAction
extends AbstractCrosstabAction {
    private MeasureViewHandle measureViewHandle;
    public static final String ID = "org.eclipse.birt.report.item.crosstab.internal.ui.editors.action.AddComputedMeasureAction";
    private static final String NAME = Messages.getString("AddComputedMesureHandleAction.DisplayName");
    private static final String ACTION_MSG_MERGE = Messages.getString("AddComputedMesureHandleAction.TransName");

    public AddComputedMeasureAction(DesignElementHandle handle) {
        super(handle);
        this.setId(ID);
        this.setText(NAME);
        ExtendedItemHandle extendedHandle = CrosstabAdaptUtil.getExtendedItemHandle(handle);
        this.setHandle((DesignElementHandle)extendedHandle);
        this.measureViewHandle = CrosstabAdaptUtil.getMeasureViewHandle(extendedHandle);
        Image image = CrosstabUIHelper.getImage(CrosstabUIHelper.ADD_DERIVED_MEASURE);
        this.setImageDescriptor(ImageDescriptor.createFromImage((Image)image));
    }

    public boolean isEnabled() {
        return !DEUtil.isReferenceElement((DesignElementHandle)this.measureViewHandle.getCrosstabHandle());
    }

    public void run() {
        this.transStar(NAME);
        CrosstabReportItemHandle reportHandle = this.measureViewHandle.getCrosstab();
        AddComputedSummaryDialog computedSummaryDialog = new AddComputedSummaryDialog(UIUtil.getDefaultShell(), reportHandle);
        if (computedSummaryDialog.open() == 0) {
            String measureName = computedSummaryDialog.getName();
            String expression = computedSummaryDialog.getExpression();
            String dataType = computedSummaryDialog.getDataType();
            int index = reportHandle.getAllMeasures().indexOf(this.measureViewHandle) + 1;
            try {
                ComputedMeasureViewHandle computedMeasure = reportHandle.insertComputedMeasure(measureName, index);
                computedMeasure.addHeader();
                LabelHandle labelHandle = DesignElementFactory.getInstance().newLabel(null);
                labelHandle.setText(measureName);
                computedMeasure.getHeader().addContent((DesignElementHandle)labelHandle);
                ExtendedItemHandle crosstabModelHandle = (ExtendedItemHandle)reportHandle.getModelHandle();
                ComputedColumn bindingColumn = StructureFactory.newComputedColumn((DesignElementHandle)crosstabModelHandle, (String)measureName);
                ComputedColumnHandle bindingHandle = crosstabModelHandle.addColumnBinding(bindingColumn, false);
                bindingHandle.setExpression(expression);
                bindingHandle.setDataType(dataType);
                DataItemHandle dataHandle = DesignElementFactory.getInstance().newDataItem(measureName);
                dataHandle.setResultSetColumn(bindingHandle.getName());
                AggregationCellHandle cell = computedMeasure.getCell();
                cell.addContent((DesignElementHandle)dataHandle);
            }
            catch (SemanticException e) {
                e.printStackTrace();
                this.rollBack();
            }
        }
        this.transEnd();
    }
}

