/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.internal.ui.editors.commands;

import java.util.Map;
import org.eclipse.birt.report.designer.core.DesignerConstants;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabCellHandle;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.CrosstabCellAdapter;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.gef.commands.Command;

public class CrosstabCellCreateCommand
extends Command {
    private Object parent;
    private Object after;
    private Map extendsData;

    public CrosstabCellCreateCommand(Map extendsData) {
        this.extendsData = extendsData;
    }

    public void execute() {
        try {
            if (this.parent instanceof CrosstabCellAdapter) {
                CrosstabCellAdapter cellAdapter = (CrosstabCellAdapter)this.parent;
                CrosstabCellHandle handle = cellAdapter.getCrosstabCellHandle();
                int pos = this.findInsertPosition(handle, this.after);
                handle.addContent(this.getNewObject(), pos);
            }
        }
        catch (SemanticException e) {
            if (DesignerConstants.TRACING_COMMANDS) {
                System.out.println("CreateCommand >> Failed");
            }
            ExceptionHandler.handle((Throwable)e);
        }
    }

    private int findInsertPosition(CrosstabCellHandle handle, Object after) {
        if (after == null) {
            return handle.getContents().size();
        }
        return handle.getContents().indexOf(after);
    }

    public Object getParent() {
        return this.parent;
    }

    public void setParent(Object parent) {
        this.parent = parent;
    }

    public void setAfter(Object model) {
        this.after = model;
    }

    public DesignElementHandle getNewObject() {
        return (DesignElementHandle)this.extendsData.get("newObject");
    }
}

