/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.internal.ui.editors.editpolicies;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editpolicies.ReportFlowLayoutEditPolicy;
import org.eclipse.birt.report.designer.util.DNDUtil;
import org.eclipse.birt.report.item.crosstab.core.de.AbstractCrosstabItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.commands.AddDimensionViewHandleCommand;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.commands.AddMeasureViewHandleCommand;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.commands.AddMultipleMeasureCommand;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.commands.ChangeAreaCommand;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.commands.ChangeMeasureOrderCommand;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.commands.CrosstabCellCreateCommand;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.commands.CrosstabFlowMoveChildCommand;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.commands.CrosstabPasterCommand;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.editparts.CrosstabCellEditPart;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.CrosstabAdaptUtil;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.CrosstabCellAdapter;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.olap.DimensionHandle;
import org.eclipse.birt.report.model.api.olap.LevelHandle;
import org.eclipse.birt.report.model.api.olap.MeasureGroupHandle;
import org.eclipse.birt.report.model.api.olap.MeasureHandle;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Transposer;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.dnd.TemplateTransfer;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;

public class CrosstabCellFlowLayoutEditPolicy
extends ReportFlowLayoutEditPolicy {
    protected Command getCreateCommand(CreateRequest request) {
        EditPart after = this.getInsertionReference((Request)request);
        Object model = this.getHost().getModel();
        Object newObject = request.getExtendedData().get("newObject");
        if (model instanceof CrosstabCellAdapter) {
            int type = this.getAreaType((CrosstabCellAdapter)model);
            String position = ((CrosstabCellAdapter)model).getPositionType();
            if ((newObject instanceof DimensionHandle || newObject instanceof LevelHandle) && (type == 1 || type == 0)) {
                Object afterObj;
                Object object = afterObj = after == null ? null : after.getModel();
                if (newObject instanceof LevelHandle) {
                    DimensionHandle dimensionHandle = CrosstabAdaptUtil.getDimensionHandle((LevelHandle)newObject);
                    AddDimensionViewHandleCommand command = new AddDimensionViewHandleCommand((CrosstabCellAdapter)model, type, dimensionHandle, afterObj);
                    command.setLevelHandles(new LevelHandle[]{(LevelHandle)newObject});
                    return command;
                }
                return new AddDimensionViewHandleCommand((CrosstabCellAdapter)model, type, (DimensionHandle)newObject, afterObj);
            }
            if (newObject instanceof MeasureHandle && position.equals("cell_measure")) {
                Object afterObj = null;
                if (after != null) {
                    afterObj = after.getModel();
                }
                return new AddMeasureViewHandleCommand((CrosstabCellAdapter)model, (MeasureHandle)newObject, afterObj);
            }
            if (newObject instanceof MeasureGroupHandle && position.equals("cell_measure")) {
                ArrayList list = new ArrayList();
                list.add(newObject);
                Object afterObj = null;
                if (after != null) {
                    afterObj = after.getModel();
                }
                return new AddMultipleMeasureCommand((CrosstabCellAdapter)model, list, afterObj);
            }
            if (newObject instanceof Object[] && CrosstabAdaptUtil.canCreateMultipleCommand((Object[])newObject) && position.equals("cell_measure")) {
                ArrayList<Object> list = new ArrayList<Object>();
                Object[] objs = (Object[])newObject;
                int i = 0;
                while (i < objs.length) {
                    list.add(objs[i]);
                    ++i;
                }
                Object afterObj = null;
                if (after != null) {
                    afterObj = after.getModel();
                }
                return new AddMultipleMeasureCommand((CrosstabCellAdapter)model, list, afterObj);
            }
            if (this.isLevelHandles(newObject)) {
                Object[] items = (Object[])newObject;
                LevelHandle[] levelHandles = new LevelHandle[items.length];
                System.arraycopy(items, 0, levelHandles, 0, levelHandles.length);
                Object afterObj = after == null ? null : after.getModel();
                DimensionHandle dimensionHandle = CrosstabAdaptUtil.getDimensionHandle(levelHandles[0]);
                AddDimensionViewHandleCommand command = new AddDimensionViewHandleCommand((CrosstabCellAdapter)model, type, dimensionHandle, afterObj);
                command.setLevelHandles(levelHandles);
                return command;
            }
            CrosstabCellCreateCommand command = new CrosstabCellCreateCommand(request.getExtendedData());
            command.setParent(this.getHost().getModel());
            command.setAfter(after == null ? null : after.getModel());
            return command;
        }
        return super.getCreateCommand(request);
    }

    private boolean isLevelHandles(Object newObject) {
        if (newObject instanceof Object[]) {
            DesignElementHandle container = null;
            Object[] items = (Object[])newObject;
            int i = 0;
            while (i < items.length) {
                if (!(items[i] instanceof LevelHandle)) {
                    return false;
                }
                if (container == null) {
                    container = ((LevelHandle)items[i]).getContainer();
                } else if (container != ((LevelHandle)items[i]).getContainer()) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private int getAreaType(CrosstabCellAdapter cellAdapter) {
        AbstractCrosstabItemHandle handle = cellAdapter.getCrosstabItemHandle().getContainer();
        while (handle != null) {
            if (handle instanceof DimensionViewHandle) {
                return ((DimensionViewHandle)handle).getAxisType();
            }
            handle = handle.getContainer();
        }
        return -1;
    }

    protected Command createAddCommand(EditPart parent, EditPart child, EditPart after) {
        Object parentObj = parent.getModel();
        Object source = child.getModel();
        Object afterObj = after == null ? null : after.getModel();
        Object childParent = child.getModel();
        if (parentObj instanceof CrosstabCellAdapter && childParent instanceof CrosstabCellAdapter) {
            CrosstabCellAdapter childAdapter = (CrosstabCellAdapter)childParent;
            CrosstabCellAdapter parentAdapter = (CrosstabCellAdapter)parentObj;
            if ("first_level_handle".equals(childAdapter.getPositionType()) && ("first_level_handle".equals(parentAdapter.getPositionType()) || "level_handle".equals(parentAdapter.getPositionType()))) {
                if (afterObj != parentAdapter.getFirstElement()) {
                    afterObj = null;
                }
                if (childAdapter.getCrosstabCellHandle().getCrosstab() == parentAdapter.getCrosstabCellHandle().getCrosstab()) {
                    return new ChangeAreaCommand(parentAdapter.getDesignElementHandle(), childAdapter.getDesignElementHandle(), DNDUtil.unwrapToModel((Object)afterObj));
                }
                return UnexecutableCommand.INSTANCE;
            }
            if ("cell_measure".equals(childAdapter.getPositionType()) && "cell_measure".equals(parentAdapter.getPositionType())) {
                if (afterObj != parentAdapter.getFirstElement()) {
                    afterObj = null;
                }
                if (childAdapter.getCrosstabCellHandle().getCrosstab() == parentAdapter.getCrosstabCellHandle().getCrosstab()) {
                    return new ChangeMeasureOrderCommand(parentAdapter.getDesignElementHandle(), childAdapter.getDesignElementHandle(), DNDUtil.unwrapToModel((Object)afterObj));
                }
                return UnexecutableCommand.INSTANCE;
            }
            return UnexecutableCommand.INSTANCE;
        }
        return new CrosstabPasterCommand((DesignElementHandle)DNDUtil.unwrapToModel((Object)source), (DesignElementHandle)DNDUtil.unwrapToModel((Object)parentObj), (DesignElementHandle)DNDUtil.unwrapToModel((Object)afterObj));
    }

    private boolean isFirstDataItem(CrosstabCellAdapter adapter, Object model, String type) {
        if (adapter.getPositionType().equals(type)) {
            return adapter.getFirstDataItem() == model;
        }
        return false;
    }

    protected Command createMoveChildCommand(EditPart child, EditPart after) {
        Object afterModel = null;
        if (after != null) {
            afterModel = after.getModel();
        }
        CrosstabFlowMoveChildCommand command = new CrosstabFlowMoveChildCommand(child.getModel(), afterModel, child.getParent().getModel());
        return command;
    }

    private EditPart getOperator(EditPart child) {
        if (child instanceof CrosstabCellEditPart) {
            return child;
        }
        return child.getParent();
    }

    protected void showLayoutTargetFeedback(Request request) {
        Object dragObject;
        Object template;
        List editParts;
        boolean isCrossTabElement = false;
        if (request instanceof ChangeBoundsRequest && (editParts = ((ChangeBoundsRequest)request).getEditParts()).size() > 0) {
            isCrossTabElement = editParts.get(0) instanceof CrosstabCellEditPart;
        }
        if (!isCrossTabElement && (template = TemplateTransfer.getInstance().getTemplate()) instanceof Object[] && ((Object[])template).length > 0 && ((dragObject = ((Object[])template)[0]) instanceof DimensionHandle || dragObject instanceof MeasureHandle || dragObject instanceof LevelHandle)) {
            isCrossTabElement = true;
        }
        if (isCrossTabElement) {
            Transposer transposer = new Transposer();
            transposer.setEnabled(!this.isHorizontal());
            Rectangle r = transposer.t(this.getAbsoluteClientBounds((GraphicalEditPart)this.getHost()));
            Point p = transposer.t(this.getLocationFromRequest(request));
            boolean before = p.x <= r.x + r.width / 2;
            Point p1 = new Point(before ? r.x : r.x + r.width, r.y - 2);
            p1 = transposer.t(p1);
            Point p2 = new Point(before ? r.x : r.x + r.width, r.y + r.height + 7);
            p2 = transposer.t(p2);
            this.setTargetFeedbackPoints(p1, p2);
        } else {
            super.showLayoutTargetFeedback(request);
        }
    }
}

