/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.internal.ui.editors.tools;

import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.AbstractTableEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.TableUtil;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools.TableDragGuideTracker;
import org.eclipse.birt.report.designer.util.MetricUtility;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.editparts.CrosstabTableEditPart;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.editparts.CrosstabTableUtil;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.CrosstabHandleAdapter;
import org.eclipse.birt.report.item.crosstab.ui.i18n.Messages;
import org.eclipse.birt.report.model.api.util.DimensionUtil;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;

public class CrosstabColumnDragTracker
extends TableDragGuideTracker {
    private static final String RESIZE_COLUMN_TRANS_LABEL = Messages.getString("CrosstabColumnDragTracker.ResizeColumn");
    private static final String PREFIX_LABEL = Messages.getString("CrosstabColumnDragTracker.Show.Label");

    public CrosstabColumnDragTracker(EditPart sourceEditPart, int start, int end) {
        super(sourceEditPart, start, end);
        this.setDisabledCursor(Cursors.SIZEWE);
    }

    protected Dimension getDragWidth(int start, int end) {
        return new Dimension(TableUtil.getMinWidth((AbstractTableEditPart)this.getCrosstabTableEditPart(), (int)this.getStart()) - CrosstabTableUtil.caleVisualWidth(this.getCrosstabTableEditPart(), this.getStart()), Integer.MAX_VALUE);
    }

    protected Rectangle getMarqueeSelectionRectangle() {
        IFigure figure = this.getCrosstabTableEditPart().getFigure();
        Insets insets = figure.getInsets();
        int value = this.getLocation().x - this.getStartLocation().x;
        value = this.getTrueValue(value);
        Point p = this.getStartLocation().getCopy();
        figure.translateToAbsolute((Translatable)p);
        figure.translateToRelative((Translatable)p);
        Rectangle bounds = figure.getBounds().getCopy();
        figure.translateToAbsolute((Translatable)bounds);
        return new Rectangle(value + p.x, bounds.y + insets.top, 2, bounds.height - (insets.top + insets.bottom));
    }

    protected void resize() {
        CrosstabTableEditPart part = (CrosstabTableEditPart)this.getSourceEditPart().getParent();
        int value = this.getLocation().x - this.getStartLocation().x;
        if (this.getStart() != this.getEnd()) {
            value = this.getTrueValue(value);
            this.resizeColumn(this.getStart(), this.getEnd(), value);
        } else {
            Dimension dimension = this.getDragWidth();
            if (value < dimension.width) {
                value = dimension.width;
            }
            int with = this.calculateWidth() + value;
            int startWidth = 0;
            startWidth = CrosstabTableUtil.caleVisualWidth(part, this.getStart());
            part.getCrosstabHandleAdapter().getCrosstabItemHandle().getModuleHandle().getCommandStack().startTrans(RESIZE_COLUMN_TRANS_LABEL);
            part.getCrosstabHandleAdapter().setWidth(with);
            part.getCrosstabHandleAdapter().setColumnWidth(this.getStart(), startWidth + value);
            part.getCrosstabHandleAdapter().getCrosstabItemHandle().getModuleHandle().getCommandStack().commit();
        }
    }

    private int calculateWidth() {
        CrosstabTableEditPart part = (CrosstabTableEditPart)this.getSourceEditPart().getParent();
        int columnCount = part.getColumnCount();
        int samColumnWidth = 0;
        int i = 0;
        while (i < columnCount) {
            samColumnWidth += CrosstabTableUtil.caleVisualWidth(part, i + 1);
            ++i;
        }
        return samColumnWidth;
    }

    public void resizeColumn(int start, int end, int value) {
        CrosstabTableEditPart part = (CrosstabTableEditPart)this.getSourceEditPart().getParent();
        CrosstabHandleAdapter crosstabAdapter = part.getCrosstabHandleAdapter();
        int startWidth = 0;
        startWidth = CrosstabTableUtil.caleVisualWidth(part, start);
        CrosstabTableUtil.caleVisualWidth(part, end);
        part.getCrosstabHandleAdapter().getCrosstabItemHandle().getModuleHandle().getCommandStack().startTrans(RESIZE_COLUMN_TRANS_LABEL);
        crosstabAdapter.setColumnWidth(start, startWidth + value);
        part.getCrosstabHandleAdapter().getCrosstabItemHandle().getModuleHandle().getCommandStack().commit();
    }

    private CrosstabTableEditPart getCrosstabTableEditPart() {
        return (CrosstabTableEditPart)this.getSourceEditPart().getParent();
    }

    protected String getInfomation() {
        CrosstabTableEditPart part = (CrosstabTableEditPart)this.getSourceEditPart().getParent();
        return this.getShowLabel(CrosstabTableUtil.caleVisualWidth(part, this.getStart()));
    }

    private String getShowLabel(int pix) {
        CrosstabTableEditPart part = (CrosstabTableEditPart)this.getSourceEditPart().getParent();
        CrosstabHandleAdapter crosstabAdapter = part.getCrosstabHandleAdapter();
        String unit = crosstabAdapter.getDesignElementHandle().getModuleHandle().getDefaultUnits();
        double doubleValue = MetricUtility.pixelToPixelInch((int)pix);
        double showValue = DimensionUtil.convertTo((double)doubleValue, (String)"in", (String)unit).getMeasure();
        return String.valueOf(PREFIX_LABEL) + " " + this.getShowValue(showValue) + " " + this.getUnitDisplayName(unit) + " (" + pix + " " + PIXELS_LABEL + ")";
    }

    private String getShowValue(double value) {
        return FORMAT.format(value);
    }

    protected boolean handleDragInProgress() {
        CrosstabTableEditPart part = (CrosstabTableEditPart)this.getSourceEditPart().getParent();
        boolean bool = super.handleDragInProgress();
        int value = this.getTrueValue(this.getLocation().x - this.getStartLocation().x);
        int adjustWidth = CrosstabTableUtil.caleVisualWidth(part, this.getStart()) + value;
        this.updateInfomation(this.getShowLabel(adjustWidth));
        return bool;
    }
}

