/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.ui.extension;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.data.adapter.api.DataSessionContext;
import org.eclipse.birt.report.designer.internal.ui.extension.IUseCubeQueryList;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.ui.preferences.PreferenceFactory;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.internal.ui.util.CrosstabUIHelper;
import org.eclipse.birt.report.item.crosstab.plugin.CrosstabPlugin;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.api.extension.IReportItem;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.birt.report.model.api.olap.TabularCubeHandle;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class CrosstabUseCubeQueryList
implements IUseCubeQueryList {
    public List getQueryList(String expression, ExtendedItemHandle extendedItem) {
        CrosstabReportItemHandle crosstab = null;
        CubeHandle cube = null;
        try {
            IReportItem obj = extendedItem.getReportItem();
            ExtendedItemHandle tmp = extendedItem;
            while (obj != null && !(obj instanceof ReportDesignHandle)) {
                if (obj instanceof CrosstabReportItemHandle) {
                    crosstab = (CrosstabReportItemHandle)obj;
                    cube = crosstab.getCube();
                    break;
                }
                if (!(tmp instanceof ExtendedItemHandle) || !((tmp = tmp.getContainer()) instanceof ExtendedItemHandle)) continue;
                obj = tmp.getReportItem();
            }
        }
        catch (ExtendedElementException extendedElementException) {}
        if (cube == null || !(cube instanceof TabularCubeHandle) || expression.length() == 0) {
            return new ArrayList();
        }
        Iterator iter = null;
        ICubeQueryDefinition cubeQueryDefn = null;
        DataRequestSession session = null;
        try {
            session = DataRequestSession.newSession((DataSessionContext)new DataSessionContext(3));
            cubeQueryDefn = CrosstabUIHelper.createBindingQuery(crosstab);
            iter = session.getCubeQueryUtil().getMemberValueIterator((TabularCubeHandle)cube, expression, cubeQueryDefn);
        }
        catch (Exception exception) {}
        ArrayList valueList = new ArrayList();
        int count = 0;
        int MAX_COUNT = PreferenceFactory.getInstance().getPreferences((AbstractUIPlugin)CrosstabPlugin.getDefault(), UIUtil.getCurrentProject()).getInt("Filter.Limit");
        while (iter != null && iter.hasNext()) {
            Object obj = iter.next();
            if (obj == null || valueList.indexOf(obj) >= 0) continue;
            valueList.add(obj);
            if (++count >= MAX_COUNT) break;
        }
        return valueList;
    }
}

