/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.ui.preference;

import org.eclipse.birt.report.designer.internal.ui.util.PixelConverter;
import org.eclipse.birt.report.designer.ui.preferences.IStatusChangeListener;
import org.eclipse.birt.report.designer.ui.preferences.OptionsConfigurationBlock;
import org.eclipse.birt.report.designer.ui.preferences.StatusInfo;
import org.eclipse.birt.report.item.crosstab.plugin.CrosstabPlugin;
import org.eclipse.birt.report.item.crosstab.ui.i18n.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class CrosstabConfigurationBlock
extends OptionsConfigurationBlock {
    private final OptionsConfigurationBlock.Key PREF_FILTER_LIMIT = this.getKey("org.eclipse.birt.report.item.crosstab.ui", "Filter.Limit");
    private final OptionsConfigurationBlock.Key PREF_CUBE_BUILDER_WARNING = this.getKey("org.eclipse.birt.report.item.crosstab.ui", "org.eclipse.birt.report.designer.ui.cubebuilder.warning");
    private final OptionsConfigurationBlock.Key PREF_AUTO_DEL_BINDINGS = this.getKey("org.eclipse.birt.report.item.crosstab.ui", "Auto.Del.Bindings");
    private static final String ENABLED = "prompt";
    private static final String DISABLED = "never";
    private static final int MAX_FILTER_LIMIT = 10000;
    private PixelConverter fPixelConverter;

    public CrosstabConfigurationBlock(IStatusChangeListener context, IProject project) {
        super(context, (AbstractUIPlugin)CrosstabPlugin.getDefault(), project);
        this.setKeys(this.getKeys());
    }

    private OptionsConfigurationBlock.Key[] getKeys() {
        OptionsConfigurationBlock.Key[] keys = null;
        keys = this.fProject == null ? new OptionsConfigurationBlock.Key[]{this.PREF_FILTER_LIMIT, this.PREF_AUTO_DEL_BINDINGS, this.PREF_CUBE_BUILDER_WARNING} : new OptionsConfigurationBlock.Key[]{this.PREF_FILTER_LIMIT};
        return keys;
    }

    protected Control createContents(Composite parent) {
        this.fPixelConverter = new PixelConverter((Control)parent);
        this.setShell(parent.getShell());
        Composite mainComp = new Composite(parent, 0);
        mainComp.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        mainComp.setLayout((Layout)layout);
        Composite othersComposite = this.createBuildPathTabContent(mainComp);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = this.fPixelConverter.convertHeightInCharsToPixels(20);
        othersComposite.setLayoutData((Object)gridData);
        this.validateSettings(null, null, null);
        return mainComp;
    }

    private Composite createBuildPathTabContent(Composite parent) {
        Composite pageContent = new Composite(parent, 0);
        GridData data = new GridData(1810);
        data.grabExcessHorizontalSpace = true;
        pageContent.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 3;
        pageContent.setLayout((Layout)layout);
        Group group = new Group(pageContent, 0);
        group.setText(Messages.getString("CrosstabPreferencePage.filterLimit"));
        group.setLayout((Layout)new GridLayout(3, false));
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        group.setLayoutData((Object)gd);
        this.addTextField((Composite)group, Messages.getString("CrosstabPreferencePage.filterLimit.prompt"), this.PREF_FILTER_LIMIT, 0, 0);
        if (this.fProject == null) {
            Group promptGroup = new Group(pageContent, 0);
            promptGroup.setText(Messages.getString("CrosstabPreferencePage.promptGroup"));
            promptGroup.setLayout((Layout)new GridLayout(3, false));
            gd = new GridData(768);
            gd.horizontalSpan = 3;
            promptGroup.setLayoutData((Object)gd);
            String[] enableDisableValues = new String[]{ENABLED, DISABLED};
            String[] RadioValues = new String[]{"always", DISABLED, ENABLED};
            String[] labels = new String[]{Messages.getString("CrosstabPreferencePage.autoDelBindings.Text"), Messages.getString("CrosstabPreferencePage.autoDelBindings.Text.Always"), Messages.getString("CrosstabPreferencePage.autoDelBindings.Text.Never"), Messages.getString("CrosstabPreferencePage.autoDelBindings.Text.Prompt")};
            this.addCheckBox((Composite)promptGroup, Messages.getString("CrosstabPreferencePage.cubePopup.Text"), this.PREF_CUBE_BUILDER_WARNING, enableDisableValues, 0);
            this.addRadioButton(pageContent, labels, this.PREF_AUTO_DEL_BINDINGS, RadioValues, 0);
        }
        return pageContent;
    }

    protected void validateSettings(OptionsConfigurationBlock.Key changedKey, String oldValue, String newValue) {
        this.fContext.statusChanged(this.validatePositiveNumber(this.getValue(this.PREF_FILTER_LIMIT)));
    }

    protected IStatus validatePositiveNumber(String number) {
        StatusInfo status = new StatusInfo();
        String errorMessage = Messages.getString("CrosstabPreferencePage.Error.MaxRowInvalid", new Object[]{new Integer(10000)});
        if (number.length() == 0) {
            status.setError(errorMessage);
        } else {
            try {
                int value = Integer.parseInt(number);
                if (value < 1 || value > 10000) {
                    status.setError(errorMessage);
                }
            }
            catch (NumberFormatException numberFormatException) {
                status.setError(errorMessage);
            }
        }
        return status;
    }
}

