/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.ui.views.attributes.widget;

import java.util.Arrays;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.IDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.FormWidgetFactory;
import org.eclipse.birt.report.designer.ui.views.attributes.IPropertyDescriptor;
import org.eclipse.birt.report.item.crosstab.ui.views.attributes.provider.EmptyRowColumnProvider;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.olap.LevelHandle;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class EmptyRowColumnDescriptor
implements IPropertyDescriptor {
    private boolean formStyle;
    private org.eclipse.swt.widgets.List list;
    private Button button;
    EmptyRowColumnProvider provider;
    private Composite composite;

    public boolean isFormStyle() {
        return this.formStyle;
    }

    public void setFormStyle(boolean formStyle) {
        this.formStyle = formStyle;
    }

    public EmptyRowColumnDescriptor(boolean formStyle) {
        this.setFormStyle(formStyle);
    }

    public Control createControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 2;
        layout.marginWidth = 2;
        layout.horizontalSpacing = 10;
        layout.numColumns = 2;
        this.composite.setLayout((Layout)layout);
        this.button = FormWidgetFactory.getInstance().createButton(this.composite, 32, this.isFormStyle());
        int buttonWidth = this.button.computeSize((int)-1, (int)-1).x;
        this.button.setText(this.provider.getDisplayName());
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (EmptyRowColumnDescriptor.this.button.getSelection()) {
                    EmptyRowColumnDescriptor.this.initList();
                    if (EmptyRowColumnDescriptor.this.list.getItemCount() > 0) {
                        EmptyRowColumnDescriptor.this.button.setEnabled(true);
                        EmptyRowColumnDescriptor.this.list.setEnabled(true);
                        if (EmptyRowColumnDescriptor.this.list.getSelectionCount() == 0) {
                            EmptyRowColumnDescriptor.this.list.setSelection(0);
                        }
                        EmptyRowColumnDescriptor.this.handleListSelectEvent();
                    } else {
                        EmptyRowColumnDescriptor.this.button.setEnabled(false);
                        EmptyRowColumnDescriptor.this.button.setSelection(false);
                        EmptyRowColumnDescriptor.this.list.setEnabled(false);
                    }
                } else {
                    EmptyRowColumnDescriptor.this.list.setEnabled(false);
                    try {
                        EmptyRowColumnDescriptor.this.save(null);
                    }
                    catch (SemanticException e1) {
                        ExceptionHandler.handle((Throwable)e1);
                    }
                }
            }
        });
        this.list = this.isFormStyle() ? FormWidgetFactory.getInstance().createList(this.composite, 772) : new org.eclipse.swt.widgets.List(parent, 2820);
        this.list.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EmptyRowColumnDescriptor.this.handleListSelectEvent();
            }
        });
        GridData gd = new GridData();
        gd.verticalAlignment = 16;
        int width = this.provider.getMaxLengthOfDisplayName((Control)this.button);
        gd.widthHint = width + buttonWidth;
        this.button.setLayoutData((Object)gd);
        gd = new GridData();
        gd.heightHint = 80;
        gd.widthHint = 180;
        this.list.setLayoutData((Object)gd);
        return this.composite;
    }

    protected void handleListSelectEvent() {
        try {
            this.save(this.list.getSelection()[0]);
        }
        catch (SemanticException e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public Control getControl() {
        return this.composite;
    }

    public void load() {
        this.initList();
        if (this.list.getItemCount() == 0) {
            this.button.setEnabled(false);
            this.button.setSelection(false);
            this.list.setEnabled(false);
            return;
        }
        this.button.setEnabled(true);
        Object value = this.provider.load();
        if (value == null) {
            this.button.setSelection(false);
            this.list.setEnabled(false);
        } else {
            this.button.setSelection(true);
            this.list.setEnabled(true);
            if (this.list.getSelectionCount() > 0 && this.list.getSelection()[0].equals(((LevelHandle)value).getName())) {
                return;
            }
            this.list.setSelection(new String[]{((LevelHandle)value).getName()});
        }
    }

    private void initList() {
        Object[] names = new String[this.provider.getViewLevels().size()];
        List levels = this.provider.getViewLevels();
        int i = 0;
        while (i < levels.size()) {
            LevelHandle level = (LevelHandle)levels.get(i);
            names[i] = level.getName();
            ++i;
        }
        if (!Arrays.equals(names, this.list.getItems())) {
            this.list.removeAll();
            this.list.setItems((String[])names);
        }
    }

    public void save(Object obj) throws SemanticException {
        this.provider.save(obj);
    }

    public void setInput(Object input) {
        this.provider.setInput(input);
    }

    public void setDescriptorProvider(EmptyRowColumnProvider provider) {
        this.provider = provider;
    }

    public IDescriptorProvider getDescriptorProvider() {
        return this.provider;
    }
}

