/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.ui.views.dialogs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.data.adapter.api.DataSessionContext;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.MultiValueCombo;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.ValueCombo;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.dialogs.provider.HighlightHandleProvider;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionBuilder;
import org.eclipse.birt.report.designer.ui.dialogs.HighlightRuleBuilder;
import org.eclipse.birt.report.designer.ui.dialogs.IExpressionProvider;
import org.eclipse.birt.report.designer.ui.dialogs.SelectValueDialog;
import org.eclipse.birt.report.designer.ui.preferences.PreferenceFactory;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.internal.ui.dialogs.CrosstabBindingExpressionProvider;
import org.eclipse.birt.report.item.crosstab.internal.ui.util.CrosstabUIHelper;
import org.eclipse.birt.report.item.crosstab.plugin.CrosstabPlugin;
import org.eclipse.birt.report.item.crosstab.ui.i18n.Messages;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.api.extension.IReportItem;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.birt.report.model.api.olap.TabularCubeHandle;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class CrosstabHighlightRuleBuilder
extends HighlightRuleBuilder {
    public CrosstabHighlightRuleBuilder(Shell parentShell, String title, HighlightHandleProvider provider) {
        super(parentShell, title, provider);
        this.initializeListener();
    }

    protected void inilializeColumnList(DesignElementHandle handle) {
        super.inilializeColumnList(handle);
        this.expSelListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CrosstabHighlightRuleBuilder.this.expression.getText().equals(CrosstabHighlightRuleBuilder.access$1()) && CrosstabHighlightRuleBuilder.this.designHandle instanceof DataItemHandle) {
                    CrosstabHighlightRuleBuilder.this.expression.setText(DEUtil.getDataExpression((String)((DataItemHandle)CrosstabHighlightRuleBuilder.this.designHandle).getResultSetColumn()));
                } else {
                    String newValue = CrosstabHighlightRuleBuilder.this.expression.getText();
                    Object computedColumn = CrosstabHighlightRuleBuilder.this.getResultSetColumn(newValue);
                    if (computedColumn != null) {
                        String value = DEUtil.getDataExpression((String)((ComputedColumnHandle)computedColumn).getName());
                        if (value != null) {
                            newValue = value;
                        }
                        CrosstabHighlightRuleBuilder.this.expression.setText(newValue);
                    }
                }
                CrosstabHighlightRuleBuilder.this.updateButtons();
            }
        };
    }

    private List getSelectedValueList() {
        CubeHandle cube = null;
        CrosstabReportItemHandle crosstab = null;
        if (this.designHandle instanceof ExtendedItemHandle) {
            try {
                IReportItem obj = ((ExtendedItemHandle)this.designHandle).getReportItem();
                DesignElementHandle tmp = this.designHandle;
                while (obj != null && !(obj instanceof ReportDesignHandle)) {
                    if (obj instanceof CrosstabReportItemHandle) {
                        crosstab = (CrosstabReportItemHandle)obj;
                        cube = crosstab.getCube();
                        break;
                    }
                    if (!(tmp instanceof ExtendedItemHandle) || !((tmp = tmp.getContainer()) instanceof ExtendedItemHandle)) continue;
                    obj = ((ExtendedItemHandle)tmp).getReportItem();
                }
            }
            catch (ExtendedElementException e) {
                this.logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if (cube == null || !(cube instanceof TabularCubeHandle) || this.expression.getText().length() == 0) {
            return new ArrayList();
        }
        Iterator iter = null;
        ICubeQueryDefinition cubeQueryDefn = null;
        DataRequestSession session = null;
        try {
            session = DataRequestSession.newSession((DataSessionContext)new DataSessionContext(3));
            cubeQueryDefn = CrosstabUIHelper.createBindingQuery(crosstab);
            iter = session.getCubeQueryUtil().getMemberValueIterator((TabularCubeHandle)cube, this.expression.getText(), cubeQueryDefn);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
        }
        ArrayList valueList = new ArrayList();
        int count = 0;
        int MAX_COUNT = PreferenceFactory.getInstance().getPreferences((AbstractUIPlugin)CrosstabPlugin.getDefault(), UIUtil.getCurrentProject()).getInt("Filter.Limit");
        while (iter != null && iter.hasNext()) {
            Object obj = iter.next();
            if (obj == null || valueList.indexOf(obj) >= 0) continue;
            valueList.add(obj);
            if (++count >= MAX_COUNT) break;
        }
        return valueList;
    }

    private void initializeListener() {
        this.expValueAction = new ValueCombo.ISelection(){

            public String doSelection(String input) {
                String retValue = null;
                ExpressionBuilder dialog = new ExpressionBuilder(PlatformUI.getWorkbench().getDisplay().getActiveShell(), input);
                if (CrosstabHighlightRuleBuilder.this.expressionProvider == null || !(CrosstabHighlightRuleBuilder.this.expressionProvider instanceof CrosstabBindingExpressionProvider)) {
                    CrosstabHighlightRuleBuilder.this.expressionProvider = (IExpressionProvider)new CrosstabBindingExpressionProvider(CrosstabHighlightRuleBuilder.this.designHandle, null);
                }
                dialog.setExpressionProvier(CrosstabHighlightRuleBuilder.this.expressionProvider);
                if (dialog.open() == 0) {
                    retValue = dialog.getResult();
                }
                return retValue;
            }
        };
        this.selectValueAction = new ValueCombo.ISelection(){

            public String doSelection(String input) {
                String retValue = null;
                List selectValueList = CrosstabHighlightRuleBuilder.this.getSelectedValueList();
                if (selectValueList == null || selectValueList.size() == 0) {
                    MessageDialog.openInformation(null, (String)Messages.getString("SelectValueDialog.selectValue"), (String)Messages.getString("SelectValueDialog.messages.info.selectVauleUnavailable"));
                } else {
                    SelectValueDialog dialog = new SelectValueDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), Messages.getString("ExpressionValueCellEditor.title"));
                    dialog.setSelectedValueList((Collection)selectValueList);
                    if (dialog.open() == 0) {
                        retValue = dialog.getSelectedExprValue();
                    }
                }
                return retValue;
            }
        };
        this.mAddSelValueAction = new MultiValueCombo.ISelection(){

            public void doAfterSelection(MultiValueCombo combo) {
                CrosstabHighlightRuleBuilder.this.addBtn.setEnabled(false);
                if (CrosstabHighlightRuleBuilder.this.addExpressionValue.getSelStrings().length == 1) {
                    CrosstabHighlightRuleBuilder.this.addExpressionValue.setText(DEUtil.resolveNull((String)CrosstabHighlightRuleBuilder.this.addExpressionValue.getSelStrings()[0]));
                } else if (CrosstabHighlightRuleBuilder.this.addExpressionValue.getSelStrings().length > 1) {
                    CrosstabHighlightRuleBuilder.this.addExpressionValue.setText("");
                }
                boolean change = false;
                int i = 0;
                while (i < CrosstabHighlightRuleBuilder.this.addExpressionValue.getSelStrings().length) {
                    if (CrosstabHighlightRuleBuilder.this.valueList.indexOf(DEUtil.resolveNull((String)CrosstabHighlightRuleBuilder.this.addExpressionValue.getSelStrings()[i])) < 0) {
                        CrosstabHighlightRuleBuilder.this.valueList.add(DEUtil.resolveNull((String)CrosstabHighlightRuleBuilder.this.addExpressionValue.getSelStrings()[i]));
                        change = true;
                    }
                    ++i;
                }
                if (change) {
                    CrosstabHighlightRuleBuilder.this.tableViewer.refresh();
                    CrosstabHighlightRuleBuilder.this.updateButtons();
                    CrosstabHighlightRuleBuilder.this.addExpressionValue.setFocus();
                }
            }

            public String[] doSelection(String input) {
                String[] retValue = null;
                List selectValueList = CrosstabHighlightRuleBuilder.this.getSelectedValueList();
                if (selectValueList == null || selectValueList.size() == 0) {
                    MessageDialog.openInformation(null, (String)Messages.getString("SelectValueDialog.selectValue"), (String)Messages.getString("SelectValueDialog.messages.info.selectVauleUnavailable"));
                } else {
                    SelectValueDialog dialog = new SelectValueDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), Messages.getString("ExpressionValueCellEditor.title"));
                    dialog.setSelectedValueList((Collection)selectValueList);
                    dialog.setMultipleSelection(true);
                    if (dialog.open() == 0) {
                        retValue = dialog.getSelectedExprValues();
                    }
                }
                return retValue;
            }
        };
        this.mAddExpValueAction = new MultiValueCombo.ISelection(){

            public void doAfterSelection(MultiValueCombo combo) {
                CrosstabHighlightRuleBuilder.this.mAddSelValueAction.doAfterSelection(combo);
            }

            public String[] doSelection(String input) {
                String[] retValue = null;
                ExpressionBuilder dialog = new ExpressionBuilder(PlatformUI.getWorkbench().getDisplay().getActiveShell(), input);
                if (CrosstabHighlightRuleBuilder.this.expressionProvider == null || !(CrosstabHighlightRuleBuilder.this.expressionProvider instanceof CrosstabBindingExpressionProvider)) {
                    CrosstabHighlightRuleBuilder.this.expressionProvider = (IExpressionProvider)new CrosstabBindingExpressionProvider(CrosstabHighlightRuleBuilder.this.designHandle, null);
                }
                dialog.setExpressionProvier(CrosstabHighlightRuleBuilder.this.expressionProvider);
                if (dialog.open() == 0 && dialog.getResult().length() != 0) {
                    retValue = new String[]{dialog.getResult()};
                }
                return retValue;
            }
        };
    }

    static /* synthetic */ String access$1() {
        return HighlightRuleBuilder.VALUE_OF_THIS_DATA_ITEM;
    }
}

