/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.ui.views.dialogs;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.dialogs.BaseDialog;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.designer.util.FontManager;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.item.crosstab.ui.i18n.Messages;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class CrosstabPageBreakDialog
extends BaseDialog {
    protected LevelViewHandle levelHandle;
    protected CrosstabReportItemHandle reportItemHandle;
    public static final String TITLE = Messages.getString("CrosstabPageBreakDialog.Title");
    protected Combo levelCombo;
    protected Combo pageBreakBeforeCombo;
    protected Combo pageBreakAfterCombo;
    private static final IChoice[] pagebreakBeforeChoicesAll = DEUtil.getMetaDataDictionary().getChoiceSet("pageBreakBefore").getChoices();
    private static final IChoice[] pagebreakAfterChoicesAll = DEUtil.getMetaDataDictionary().getChoiceSet("pageBreakAfter").getChoices();
    private static final int PAGE_BREAK_BEFORE = 0;
    private static final int PAGE_BREAK_AFTER = 1;
    private int axis;
    protected Listener updateButtonListener = new Listener(){

        public void handleEvent(Event event) {
            CrosstabPageBreakDialog.this.updateButtons();
        }
    };

    public void setAxis(int axis) {
        this.axis = axis;
    }

    protected CrosstabPageBreakDialog(String title) {
        this(UIUtil.getDefaultShell(), title);
    }

    protected CrosstabPageBreakDialog(Shell parentShell, String title) {
        super(parentShell, title);
    }

    public void setLevelViewHandle(LevelViewHandle levelHandle) {
        this.levelHandle = levelHandle;
    }

    public CrosstabPageBreakDialog(CrosstabReportItemHandle reportItem) {
        this(TITLE);
        this.reportItemHandle = reportItem;
    }

    protected Control createContents(Composite parent) {
        UIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.cshelp.AddEditPageBreakDialog_ID");
        Composite contents = new Composite(parent, 0);
        contents.setLayout((Layout)new GridLayout());
        contents.setLayoutData((Object)new GridData(1808));
        this.createTitleArea(contents);
        Composite composite = new Composite(contents, 0);
        GridLayout glayout = new GridLayout();
        glayout.marginHeight = 0;
        glayout.marginWidth = 0;
        glayout.verticalSpacing = 0;
        composite.setLayout((Layout)glayout);
        composite.setLayoutData((Object)new GridData(1808));
        CrosstabPageBreakDialog.applyDialogFont((Control)composite);
        this.initializeDialogUnits((Control)composite);
        Composite innerParent = (Composite)this.createDialogArea(composite);
        this.createButtonBar(composite);
        this.createPageBreakContent(innerParent);
        Composite space = new Composite(innerParent, 0);
        GridData gdata = new GridData(768);
        gdata.minimumWidth = 200;
        gdata.heightHint = 10;
        space.setLayoutData((Object)gdata);
        Label lb = new Label(innerParent, 258);
        lb.setLayoutData((Object)new GridData(768));
        this.iniValue();
        return composite;
    }

    protected void iniValue() {
        if (this.levelHandle != null) {
            this.levelCombo.add(this.levelHandle.getCubeLevelName());
            this.levelCombo.setEnabled(false);
            this.levelCombo.select(0);
            if (this.levelHandle.getPageBreakBefore() != null) {
                this.pageBreakBeforeCombo.select(this.getPageBreakIndex(this.levelHandle.getPageBreakBefore(), 0));
            }
            if (this.levelHandle.getPageBreakAfter() != null) {
                this.pageBreakAfterCombo.select(this.getPageBreakIndex(this.levelHandle.getPageBreakAfter(), 1));
            }
        } else {
            this.levelCombo.setItems(this.getLevelNames(this.reportItemHandle, this.axis));
            this.levelCombo.setEnabled(true);
            this.levelCombo.select(0);
            this.pageBreakBeforeCombo.select(0);
            this.pageBreakAfterCombo.select(0);
        }
        this.updateButtons();
    }

    private CommandStack getActionStack() {
        return SessionHandleAdapter.getInstance().getCommandStack();
    }

    protected void okPressed() {
        CommandStack stack = this.getActionStack();
        stack.startTrans(Messages.getString("FormPage.Menu.ModifyProperty"));
        LevelViewHandle level = this.getLevelFromName(this.reportItemHandle, this.levelCombo.getText(), this.axis);
        try {
            level.setPageBreakBefore(this.getPageBreak(this.pageBreakBeforeCombo.getSelectionIndex(), 0));
            level.setPageBreakAfter(this.getPageBreak(this.pageBreakAfterCombo.getSelectionIndex(), 1));
            stack.commit();
        }
        catch (SemanticException e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            stack.rollback();
            super.okPressed();
            return;
        }
        super.okPressed();
    }

    protected void createPageBreakContent(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayoutData((Object)new GridData(768));
        GridLayout glayout = new GridLayout(2, false);
        container.setLayout((Layout)glayout);
        Label lb = new Label(container, 0);
        lb.setText(Messages.getString("CrosstabPageBreakDialog.Text.GroupLevel"));
        this.levelCombo = new Combo(container, 2056);
        GridData gdata = new GridData(768);
        gdata.minimumWidth = 140;
        this.levelCombo.setLayoutData((Object)gdata);
        this.levelCombo.addListener(13, this.updateButtonListener);
        lb = new Label(container, 0);
        lb.setText(Messages.getString("CrosstabPageBreakDialog.Text.PageBreakBefore"));
        this.pageBreakBeforeCombo = new Combo(container, 2056);
        this.pageBreakBeforeCombo.setLayoutData((Object)gdata);
        this.pageBreakBeforeCombo.setItems(this.getPageBreakDisplayNames(0));
        this.pageBreakBeforeCombo.addListener(13, this.updateButtonListener);
        lb = new Label(container, 0);
        lb.setText(Messages.getString("CrosstabPageBreakDialog.Text.PageBreakAfter"));
        this.pageBreakAfterCombo = new Combo(container, 2056);
        this.pageBreakAfterCombo.setLayoutData((Object)gdata);
        this.pageBreakAfterCombo.setItems(this.getPageBreakDisplayNames(1));
        this.pageBreakAfterCombo.addListener(13, this.updateButtonListener);
    }

    private Composite createTitleArea(Composite parent) {
        int heightMargins = 3;
        int widthMargins = 8;
        final Composite titleArea = new Composite(parent, 0);
        FormLayout layout = new FormLayout();
        layout.marginHeight = heightMargins;
        layout.marginWidth = widthMargins;
        titleArea.setLayout((Layout)layout);
        Display display = parent.getDisplay();
        Color background = JFaceColors.getBannerBackground((Display)display);
        GridData layoutData = new GridData(768);
        layoutData.heightHint = 20 + heightMargins * 2;
        titleArea.setLayoutData((Object)layoutData);
        titleArea.setBackground(background);
        titleArea.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.setForeground(titleArea.getDisplay().getSystemColor(18));
                Rectangle bounds = titleArea.getClientArea();
                bounds.height -= 2;
                --bounds.width;
                e.gc.drawRectangle(bounds);
            }
        });
        Label label = new Label(titleArea, 0);
        label.setBackground(background);
        label.setFont(FontManager.getFont((String)label.getFont().toString(), (int)10, (int)1));
        label.setText(this.getTitle());
        return titleArea;
    }

    private String[] getPageBreakDisplayNames(int type) {
        IChoice[][] pageBreakChoices = new IChoice[][]{pagebreakBeforeChoicesAll, pagebreakAfterChoicesAll};
        if (type > 2 || type < 0) {
            type = 0;
        }
        String[] retArray = new String[pageBreakChoices[type].length];
        int i = 0;
        while (i < pageBreakChoices[type].length) {
            retArray[i] = pageBreakChoices[type][i].getDisplayName();
            ++i;
        }
        return retArray;
    }

    private String getPageBreakDisplayName(String name, int type) {
        IChoice[][] pageBreakChoices = new IChoice[][]{pagebreakBeforeChoicesAll, pagebreakAfterChoicesAll};
        if (type > 2 || type < 0) {
            type = 0;
        }
        String[] cfr_ignored_0 = new String[pageBreakChoices[type].length];
        int i = 0;
        while (i < pageBreakChoices[type].length) {
            if (pageBreakChoices[type][i].getName().equals(name)) {
                return pageBreakChoices[type][i].getDisplayName();
            }
            ++i;
        }
        return "";
    }

    private String getPageBreak(int index, int type) {
        IChoice[][] pageBreakChoices = new IChoice[][]{pagebreakBeforeChoicesAll, pagebreakAfterChoicesAll};
        if (type > 2 || type < 0) {
            type = 0;
        }
        if (index < 0 || index >= pageBreakChoices[type].length) {
            return null;
        }
        return pageBreakChoices[type][index].getName();
    }

    private int getPageBreakIndex(String name, int type) {
        IChoice[][] pageBreakChoices = new IChoice[][]{pagebreakBeforeChoicesAll, pagebreakAfterChoicesAll};
        if (type > 2 || type < 0) {
            type = 0;
        }
        String[] cfr_ignored_0 = new String[pageBreakChoices[type].length];
        int i = 0;
        while (i < pageBreakChoices[type].length) {
            if (pageBreakChoices[type][i].getName().equals(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private String[] getLevelNames(CrosstabReportItemHandle crosstabHandle, int axis) {
        ArrayList<String> list = new ArrayList<String>();
        if (crosstabHandle.getCrosstabView(axis) == null) {
            return new String[0];
        }
        CrosstabViewHandle crosstabView = crosstabHandle.getCrosstabView(axis);
        if (crosstabView == null) {
            return new String[0];
        }
        int dimensionCount = crosstabView.getDimensionCount();
        int i = 0;
        while (i < dimensionCount) {
            DimensionViewHandle dimension = crosstabView.getDimension(i);
            int levelCount = dimension.getLevelCount();
            int j = 0;
            while (j < levelCount) {
                if (!this.isInLevelList(dimension.getLevel(j))) {
                    list.add(dimension.getLevel(j).getCubeLevelName());
                }
                ++j;
            }
            ++i;
        }
        return list.toArray(new String[list.size()]);
    }

    private LevelViewHandle getLevelFromName(CrosstabReportItemHandle crosstabHandle, String name, int axis) {
        new ArrayList();
        if (crosstabHandle.getCrosstabView(axis) == null) {
            return null;
        }
        CrosstabViewHandle crosstabView = crosstabHandle.getCrosstabView(axis);
        if (crosstabView == null) {
            return null;
        }
        int dimensionCount = crosstabView.getDimensionCount();
        int i = 0;
        while (i < dimensionCount) {
            DimensionViewHandle dimension = crosstabView.getDimension(i);
            int levelCount = dimension.getLevelCount();
            int j = 0;
            while (j < levelCount) {
                if (dimension.getLevel(j).getCubeLevelName().equals(name)) {
                    return dimension.getLevel(j);
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    private boolean isConditionOK() {
        if (this.levelCombo.getSelectionIndex() == -1) {
            return false;
        }
        return this.pageBreakBeforeCombo.getSelectionIndex() != -1 || this.pageBreakAfterCombo.getSelectionIndex() != -1;
    }

    private boolean isInLevelList(LevelViewHandle level) {
        List list = new ArrayList();
        if (this.reportItemHandle.getCrosstabView(this.axis) != null) {
            CrosstabViewHandle crosstabView = this.reportItemHandle.getCrosstabView(this.axis);
            list = this.getLevel(crosstabView);
        }
        return list.indexOf(level) != -1;
    }

    private List getLevel(CrosstabViewHandle crosstabViewHandle) {
        ArrayList<LevelViewHandle> list = new ArrayList<LevelViewHandle>();
        if (crosstabViewHandle == null) {
            return list;
        }
        int dimensionCount = crosstabViewHandle.getDimensionCount();
        int i = 0;
        while (i < dimensionCount) {
            DimensionViewHandle dimension = crosstabViewHandle.getDimension(i);
            int levelCount = dimension.getLevelCount();
            int j = 0;
            while (j < levelCount) {
                LevelViewHandle levelHandle = dimension.getLevel(j);
                ExtendedItemHandle ext = (ExtendedItemHandle)levelHandle.getModelHandle();
                PropertyHandle before = ext.getPropertyHandle("pageBreakBefore");
                PropertyHandle after = ext.getPropertyHandle("pageBreakAfter");
                if (before != null && before.isLocal() || after != null && after.isLocal()) {
                    list.add(levelHandle);
                }
                ++j;
            }
            ++i;
        }
        return list;
    }

    protected void updateButtons() {
        this.getOkButton().setEnabled(this.isConditionOK());
    }
}

