/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.net.proxy.unix;

import java.io.IOException;
import java.net.URI;
import java.util.Locale;
import java.util.Properties;
import org.eclipse.core.internal.net.AbstractProxyProvider;
import org.eclipse.core.internal.net.Activator;
import org.eclipse.core.internal.net.Policy;
import org.eclipse.core.internal.net.ProxyData;
import org.eclipse.core.net.proxy.IProxyData;

public class UnixProxyProvider
extends AbstractProxyProvider {
    private static final String LIBRARY_GCONF2 = "gconf-2";
    private static final String LIBRARY_NAME = "gnomeproxy-1.0.0";
    private static boolean isGnomeLibLoaded = false;

    static {
        UnixProxyProvider.loadGnomeLib();
    }

    public IProxyData[] getProxyData(URI uri) {
        IProxyData[] iProxyDataArray;
        ProxyData pd = this.getSystemProxyInfo(uri.getScheme());
        if (pd != null) {
            IProxyData[] iProxyDataArray2 = new IProxyData[1];
            iProxyDataArray = iProxyDataArray2;
            iProxyDataArray2[0] = pd;
        } else {
            iProxyDataArray = new IProxyData[]{};
        }
        return iProxyDataArray;
    }

    public String[] getNonProxiedHosts() {
        String npEnv;
        if (Policy.DEBUG_SYSTEM_PROVIDERS) {
            Policy.debug("Getting no_proxy");
        }
        if ((npEnv = this.getEnv("no_proxy")) != null) {
            String[] npHosts = npEnv.split(",");
            int i = 0;
            while (i < npHosts.length) {
                npHosts[i] = npHosts[i].trim();
                ++i;
            }
            if (Policy.DEBUG_SYSTEM_PROVIDERS) {
                Policy.debug("Got Env no_proxy: " + npEnv);
                this.debugPrint(npHosts);
            }
            return npHosts;
        }
        if (isGnomeLibLoaded) {
            try {
                String[] npHosts = UnixProxyProvider.getGConfNonProxyHosts();
                if (npHosts != null && npHosts.length > 0) {
                    if (Policy.DEBUG_SYSTEM_PROVIDERS) {
                        Policy.debug("Got Gnome no_proxy");
                        this.debugPrint(npHosts);
                    }
                    return npHosts;
                }
            }
            catch (UnsatisfiedLinkError e) {
                Activator.logError("Problem during accessing Gnome library", e);
            }
        }
        return new String[0];
    }

    protected ProxyData getSystemProxyInfo(String protocol) {
        ProxyData pd = null;
        String envName = null;
        if (Policy.DEBUG_SYSTEM_PROVIDERS) {
            Policy.debug("Getting proxies for: " + protocol);
        }
        try {
            protocol = protocol.toLowerCase(Locale.ENGLISH);
            envName = String.valueOf(protocol) + "_proxy";
            String proxyEnv = this.getEnv(envName);
            if (Policy.DEBUG_SYSTEM_PROVIDERS) {
                Policy.debug("Got proxyEnv: " + proxyEnv);
            }
            if (proxyEnv != null) {
                URI uri = new URI(proxyEnv);
                pd = new ProxyData(protocol);
                pd.setHost(uri.getHost());
                pd.setPort(uri.getPort());
                String userInfo = uri.getUserInfo();
                if (userInfo != null) {
                    String user = null;
                    String password = null;
                    int pwInd = userInfo.indexOf(58);
                    if (pwInd >= 0) {
                        user = userInfo.substring(0, pwInd);
                        password = userInfo.substring(pwInd + 1);
                    } else {
                        user = userInfo;
                    }
                    pd.setUserid(user);
                    pd.setPassword(password);
                }
                if (Policy.DEBUG_SYSTEM_PROVIDERS) {
                    Policy.debug("Got Env proxy: " + pd);
                }
                return pd;
            }
        }
        catch (Exception e) {
            Activator.logError("Problem during accessing system variable: " + envName, e);
        }
        if (isGnomeLibLoaded) {
            try {
                pd = UnixProxyProvider.getGConfProxyInfo(protocol);
                if (Policy.DEBUG_SYSTEM_PROVIDERS) {
                    Policy.debug("Got Gnome proxy: " + pd);
                }
                return pd;
            }
            catch (UnsatisfiedLinkError e) {
                Activator.logError("Problem during accessing Gnome library", e);
            }
        }
        return null;
    }

    private String getEnv(String env) {
        Properties props = new Properties();
        try {
            props.load(Runtime.getRuntime().exec("env").getInputStream());
        }
        catch (IOException e) {
            Activator.logError("Problem during accessing system variable: " + env, e);
        }
        return props.getProperty(env);
    }

    private static void loadGnomeLib() {
        block6: {
            try {
                System.loadLibrary(LIBRARY_GCONF2);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                if (Policy.DEBUG_SYSTEM_PROVIDERS) {
                    Policy.debug("Could not load library: " + System.mapLibraryName(LIBRARY_GCONF2));
                }
                return;
            }
            try {
                System.loadLibrary(LIBRARY_NAME);
                UnixProxyProvider.gconfInit();
                isGnomeLibLoaded = true;
                if (Policy.DEBUG_SYSTEM_PROVIDERS) {
                    Policy.debug("Loaded " + System.mapLibraryName(LIBRARY_NAME) + " library");
                }
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                if (!Policy.DEBUG_SYSTEM_PROVIDERS) break block6;
                Policy.debug("Could not load library: " + System.mapLibraryName(LIBRARY_NAME));
            }
        }
    }

    private void debugPrint(String[] strs) {
        int i = 0;
        while (i < strs.length) {
            System.out.println(String.valueOf(i) + ": " + strs[i]);
            ++i;
        }
    }

    protected static native void gconfInit();

    protected static native ProxyData getGConfProxyInfo(String var0);

    protected static native String[] getGConfNonProxyHosts();
}

