/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.eclipse.birt.report.designer.internal.ui.editors.IStorageEditorInput;
import org.eclipse.birt.report.designer.internal.ui.editors.ReportEditorInputFactory;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IPersistableElement;

public class ReportEditorInput
implements IStorageEditorInput,
IPathEditorInput,
IPersistableElement {
    private File file = null;

    public ReportEditorInput(IPathEditorInput input) {
        this(input.getPath().toFile());
    }

    public ReportEditorInput(File file) {
        this.file = file;
    }

    public IStorage getStorage() throws CoreException {
        return new ReportStorage();
    }

    public boolean exists() {
        return this.file.exists();
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        return this.file.getName();
    }

    public IPersistableElement getPersistable() {
        return this;
    }

    public String getToolTipText() {
        return this.file.getAbsolutePath();
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public IPath getPath() {
        return new Path(this.file.getAbsolutePath());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof IPathEditorInput) {
            obj = new ReportEditorInput((IPathEditorInput)obj);
        }
        if (!(obj instanceof ReportEditorInput)) {
            return false;
        }
        return this.file.equals(((ReportEditorInput)obj).file);
    }

    public File getFile() {
        return this.file;
    }

    public String getFactoryId() {
        return "org.eclipse.birt.report.designer.ui.ReportEditorInputFactory";
    }

    public void saveState(IMemento memento) {
        ReportEditorInputFactory.saveState(memento, this);
    }

    private class ReportStorage
    implements IStorage {
        private ReportStorage() {
        }

        public InputStream getContents() throws CoreException {
            try {
                return new FileInputStream(ReportEditorInput.this.file);
            }
            catch (FileNotFoundException e) {
                ExceptionHandler.handle((Throwable)e);
                return null;
            }
        }

        public IPath getFullPath() {
            return ReportEditorInput.this.getPath();
        }

        public String getName() {
            return ReportEditorInput.this.getName();
        }

        public boolean isReadOnly() {
            return !ReportEditorInput.this.file.canWrite();
        }

        public Object getAdapter(Class adapter) {
            return ReportEditorInput.this.getAdapter(adapter);
        }
    }
}

