/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.taglib;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import org.eclipse.birt.report.resource.BirtResources;
import org.eclipse.birt.report.taglib.AbstractBaseTag;
import org.eclipse.birt.report.taglib.component.ParameterField;
import org.eclipse.birt.report.taglib.util.BirtTagUtil;
import org.eclipse.birt.report.utility.DataUtil;
import org.eclipse.birt.report.utility.ParameterAccessor;

public abstract class AbstractViewerTag
extends AbstractBaseTag {
    private static final long serialVersionUID = -7188886543126605745L;
    protected Locale locale;
    protected TimeZone timeZone;
    protected Map parameters;

    public void __init() {
        super.__init();
        this.parameters = new HashMap();
    }

    public boolean __validate() throws Exception {
        String hasHostPage = (String)this.pageContext.getAttribute("hasHostPage");
        if (hasHostPage != null && "true".equalsIgnoreCase(hasHostPage)) {
            return false;
        }
        this.locale = BirtTagUtil.getLocale((HttpServletRequest)this.pageContext.getRequest(), this.viewer.getLocale());
        this.timeZone = BirtTagUtil.getTimeZone((HttpServletRequest)this.pageContext.getRequest(), this.viewer.getTimeZone());
        BirtResources.setLocale(this.locale);
        if (this.viewer.getId() == null || this.viewer.getId().length() <= 0) {
            throw new JspTagException(BirtResources.getMessage("birt.viewer.taglib.NO_ATTR_ID"));
        }
        if (!this.__validateViewerId()) {
            throw new JspTagException(BirtResources.getMessage("birt.viewer.taglib.INVALID_ATTR_ID"));
        }
        if (this.pageContext.findAttribute(this.viewer.getId()) != null) {
            throw new JspTagException(BirtResources.getMessage("birt.viewer.taglib.ATTR_ID_DUPLICATE"));
        }
        if (this.viewer.getReportDesign() == null && this.viewer.getReportDocument() == null) {
            throw new JspTagException(BirtResources.getMessage("birt.viewer.taglib.NO_REPORT_SOURCE"));
        }
        if (this.viewer.getReportletId() != null && this.viewer.getReportDocument() == null) {
            throw new JspTagException(BirtResources.getMessage("birt.viewer.taglib.NO_REPORT_DOCUMENT"));
        }
        return true;
    }

    protected boolean __validateViewerId() {
        Pattern p = Pattern.compile("^\\w+$");
        Matcher m = p.matcher(this.viewer.getId());
        return m.find();
    }

    protected void __beforeEndTag() {
        super.__beforeEndTag();
        this.viewer.setParameters(this.parameters);
        this.pageContext.setAttribute(this.viewer.getId(), (Object)this.viewer.getId());
        if (this.viewer.isHostPage()) {
            this.pageContext.setAttribute("hasHostPage", (Object)"true");
        }
    }

    protected void __handleIFrame(String src, String target) throws Exception {
        JspWriter writer = this.pageContext.getOut();
        String paramContainerId = "params_" + this.viewer.getId();
        writer.write("<div id=\"" + paramContainerId + "\" style='display:none'>\n");
        for (ParameterField param : this.viewer.getParameters().values()) {
            String encParamName = ParameterAccessor.htmlEncode(param.getName());
            Object valueObj = param.getValue();
            Object[] values = valueObj != null && valueObj instanceof Object[] ? (Object[])valueObj : new Object[]{valueObj};
            for (int i = 0; i < values.length; ++i) {
                String paramValue = DataUtil.getDisplayValue(values[i], this.timeZone);
                if (paramValue == null) {
                    writer.write("<input type = 'hidden' name=\"__isnull\" \n");
                    writer.write(" value=\"" + encParamName + "\">\n");
                    continue;
                }
                writer.write("<input type = 'hidden' name=\"" + encParamName + "\" \n");
                writer.write(" value=\"" + paramValue + "\">\n");
            }
            if (valueObj != null && param.isLocale() && (valueObj instanceof String || valueObj instanceof String[])) {
                writer.write("<input type = 'hidden' name=\"__islocale\" \n");
                writer.write(" value=\"" + encParamName + "\">\n");
            }
            if (param.getPattern() != null) {
                writer.write("<input type = 'hidden' name=\"" + encParamName + "_format\" \n");
                writer.write(" value=\"" + param.getPattern() + "\">\n");
            }
            if (param.getDisplayText() == null) continue;
            writer.write("<input type = 'hidden' name=\"__isdisplay__" + encParamName + "\" \n");
            writer.write(" value=\"" + param.getDisplayText() + "\">\n");
        }
        writer.write("</div>\n");
        String formId = "form_" + this.viewer.getId();
        writer.write("<form id=\"" + formId + "\" method=\"post\"></form>\n");
        writer.write("<script type=\"text/javascript\">\n");
        writer.write("function loadViewer" + this.viewer.getId() + "(){\n");
        writer.write("var formObj = document.getElementById( \"" + formId + "\" );\n");
        writer.write("var paramContainer = document.getElementById(\"" + paramContainerId + "\");\n");
        writer.write("var oParams = paramContainer.getElementsByTagName('input');\n");
        writer.write("if( oParams )\n");
        writer.write("{\n");
        writer.write("  for( var i=0;i<oParams.length;i++ )  \n");
        writer.write("  {\n");
        writer.write("    var param = document.createElement( \"INPUT\" );\n");
        writer.write("    param.type = \"HIDDEN\";\n");
        writer.write("    param.name= oParams[i].name;\n");
        writer.write("    param.value= oParams[i].value;\n");
        writer.write("    formObj.appendChild( param );\n");
        writer.write("  }\n");
        writer.write("}\n");
        writer.write("formObj.action = \"" + src + "\";\n");
        if (target != null) {
            writer.write("formObj.target = \"" + target + "\";\n");
        }
        writer.write("formObj.submit( );\n");
        writer.write("}\n");
        writer.write("</script>\n");
        writer.write(this.__handleIFrameDefinition());
        writer.write("<script type=\"text/javascript\">");
        writer.write("loadViewer" + this.viewer.getId() + "();");
        writer.write("</script>\n");
    }

    protected String __handleIFrameDefinition() {
        String iframe = "<iframe name=\"" + this.viewer.getId() + "\" frameborder=\"" + this.viewer.getFrameborder() + "\" ";
        if (this.viewer.getScrolling() != null) {
            iframe = iframe + " scrolling = \"" + this.viewer.getScrolling() + "\" ";
        }
        iframe = iframe + this.__handleAppearance() + "></iframe>\r\n";
        return iframe;
    }

    protected String __handleAppearance() {
        String style = " style='";
        if (this.viewer.getPosition() != null) {
            style = style + "position:" + this.viewer.getPosition() + ";";
        }
        if (this.viewer.getHeight() >= 0) {
            style = style + "height:" + this.viewer.getHeight() + "px;";
        }
        if (this.viewer.getWidth() >= 0) {
            style = style + "width:" + this.viewer.getWidth() + "px;";
        }
        if (this.viewer.getTop() != null) {
            style = style + "top:" + this.viewer.getTop() + "px;";
        }
        if (this.viewer.getLeft() != null) {
            style = style + "left:" + this.viewer.getLeft() + "px;";
        }
        if (this.viewer.getStyle() != null) {
            style = style + this.viewer.getStyle() + ";";
        }
        style = style + "' ";
        return style;
    }

    public void addParameter(ParameterField field) {
        if (field != null) {
            this.parameters.put(field.getName(), field);
        }
    }

    public void setId(String id) {
        this.viewer.setId(id);
    }

    public void setBaseURL(String baseURL) {
        this.viewer.setBaseURL(baseURL);
    }

    public void setIsHostPage(String isHostPage) {
        this.viewer.setHostPage(Boolean.valueOf(isHostPage));
    }

    public void setScrolling(String scrolling) {
        this.viewer.setScrolling(scrolling);
    }

    public void setPosition(String position) {
        this.viewer.setPosition(position);
    }

    public void setStyle(String style) {
        this.viewer.setStyle(style);
    }

    public void setHeight(String height) {
        this.viewer.setHeight(Integer.parseInt(height));
    }

    public void setWidth(String width) {
        this.viewer.setWidth(Integer.parseInt(width));
    }

    public void setLeft(String left) {
        this.viewer.setLeft("" + Integer.parseInt(left));
    }

    public void setTop(String top) {
        this.viewer.setTop("" + Integer.parseInt(top));
    }

    public void setFrameborder(String frameborder) {
        this.viewer.setFrameborder(frameborder);
    }

    public void setReportDesign(String reportDesign) {
        this.viewer.setReportDesign(reportDesign);
    }

    public void setReportDocument(String reportDocument) {
        this.viewer.setReportDocument(reportDocument);
    }

    public void setBookmark(String bookmark) {
        this.viewer.setBookmark(bookmark);
    }

    public void setReportletId(String reportletId) {
        this.viewer.setReportletId(reportletId);
    }

    public void setLocale(String locale) {
        this.viewer.setLocale(locale);
    }

    public void setTimeZone(String timeZone) {
        this.viewer.setTimeZone(timeZone);
    }

    public void setFormat(String format) {
        this.viewer.setFormat(format);
    }

    public void setEmitterId(String emitterId) {
        this.viewer.setEmitterId(emitterId);
    }

    public void setPageOverflow(String pageOverflow) {
        this.viewer.setPageOverflow(pageOverflow);
    }

    public void setSvg(String svg) {
        this.viewer.setSvg(BirtTagUtil.convertBooleanValue(svg));
    }

    public void setRtl(String rtl) {
        this.viewer.setRtl(BirtTagUtil.convertBooleanValue(rtl));
    }

    public void setPageNum(String pageNum) {
        this.viewer.setPageNum(Long.parseLong(pageNum));
    }

    public void setPageRange(String pageRange) {
        this.viewer.setPageRange(pageRange);
    }

    public void setShowParameterPage(String showParameterPage) {
        this.viewer.setShowParameterPage(showParameterPage);
    }

    public void setResourceFolder(String resourceFolder) {
        this.viewer.setResourceFolder(resourceFolder);
    }

    public void setIsReportlet(String isReportlet) {
        this.viewer.setIsReportlet(BirtTagUtil.convertBooleanValue(isReportlet));
    }
}

