/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.core.re.executor;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IConditionalExpression;
import org.eclipse.birt.data.engine.api.querydefn.ConditionalExpression;
import org.eclipse.birt.report.data.adapter.api.DataAdapterUtil;
import org.eclipse.birt.report.engine.adapter.ExpressionUtil;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.extension.IBaseResultSet;
import org.eclipse.birt.report.engine.extension.IExecutorContext;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.item.crosstab.core.de.AbstractCrosstabItemHandle;
import org.eclipse.birt.report.model.api.DimensionHandle;
import org.eclipse.birt.report.model.api.HideRuleHandle;
import org.eclipse.birt.report.model.api.HighlightRuleHandle;
import org.eclipse.birt.report.model.api.MemberHandle;
import org.eclipse.birt.report.model.api.ModuleUtil;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.StyleRuleHandle;
import org.eclipse.birt.report.model.api.TOCHandle;

class ContentUtil {
    private ContentUtil() {
    }

    static void processStyle(IExecutorContext context, IContent content, AbstractCrosstabItemHandle handle, IBaseResultSet evaluator, Map styleCache) throws BirtException {
        IStyle style = ContentUtil.processStyle(context.getReportContent(), handle, evaluator, styleCache);
        if (style != null && !style.isEmpty()) {
            content.setInlineStyle(style);
        }
    }

    static IStyle processStyle(IReportContent reportContent, AbstractCrosstabItemHandle handle, IBaseResultSet evaluator, Map styleCache) throws BirtException {
        ReportElementHandle modelHandle = ContentUtil.getReportElementHandle(handle);
        if (modelHandle == null || modelHandle.getPrivateStyle() == null || reportContent == null) {
            return null;
        }
        IStyle style = null;
        if (evaluator != null) {
            style = reportContent.createStyle();
            IStyle highlightStyle = reportContent.createStyle();
            ContentUtil.setupHighlightStyle(modelHandle, highlightStyle, evaluator);
            if (!highlightStyle.isEmpty()) {
                IStyle newStyle = reportContent.createStyle();
                newStyle.setProperties(style);
                newStyle.setProperties(highlightStyle);
                return newStyle;
            }
        }
        return style;
    }

    private static void setupHighlightStyle(ReportElementHandle handle, IStyle style, IBaseResultSet evaluator) throws BirtException {
        Iterator itr = handle.getPrivateStyle().highlightRulesIterator();
        while (itr != null && itr.hasNext()) {
            HighlightRuleHandle rule = (HighlightRuleHandle)itr.next();
            ConditionalExpression condExpr = null;
            condExpr = ModuleUtil.isListStyleRuleValue((StyleRuleHandle)rule) ? new ConditionalExpression(rule.getTestExpression(), DataAdapterUtil.adaptModelFilterOperator((String)rule.getOperator()), rule.getValue1List()) : new ConditionalExpression(rule.getTestExpression(), DataAdapterUtil.adaptModelFilterOperator((String)rule.getOperator()), rule.getValue1(), rule.getValue2());
            IConditionalExpression expression = ExpressionUtil.transformConditionalExpression((IConditionalExpression)condExpr);
            Object value = evaluator.evaluate((IBaseExpression)expression);
            if (!(value instanceof Boolean) || !((Boolean)value).booleanValue()) continue;
            ContentUtil.setupRuleStyle((StructureHandle)rule, style);
        }
    }

    static void processVisibility(IExecutorContext context, IContent content, AbstractCrosstabItemHandle handle, IBaseResultSet evaluator) throws BirtException {
        String visibleFormat = ContentUtil.processVisibility(handle, evaluator);
        if (visibleFormat != null) {
            content.getStyle().setVisibleFormat(visibleFormat);
        }
    }

    static String processVisibility(AbstractCrosstabItemHandle handle, IBaseResultSet evaluator) throws BirtException {
        ReportItemHandle modelHandle = ContentUtil.getReportItemHandle(handle);
        if (modelHandle == null || evaluator == null) {
            return null;
        }
        Iterator visItr = modelHandle.visibilityRulesIterator();
        if (visItr != null && visItr.hasNext()) {
            StringBuffer buffer = new StringBuffer();
            while (visItr.hasNext()) {
                boolean isHidden;
                HideRuleHandle rule = (HideRuleHandle)visItr.next();
                String expr = ContentUtil.validExpression(rule.getExpression());
                Object result = null;
                if (expr != null) {
                    result = evaluator.evaluate(expr);
                }
                if (result == null || !(result instanceof Boolean) || !(isHidden = ((Boolean)result).booleanValue())) continue;
                buffer.append(rule.getFormat()).append(", ");
            }
            int len = buffer.length();
            if (len > 2) {
                buffer.delete(len - 2, len);
            }
            return buffer.toString();
        }
        return null;
    }

    static void processBookmark(IExecutorContext context, IContent content, AbstractCrosstabItemHandle handle, IBaseResultSet evaluator) throws BirtException {
        Object tmp;
        TOCHandle toc;
        Object tmp2;
        ReportItemHandle modelHandle = ContentUtil.getReportItemHandle(handle);
        if (modelHandle == null || evaluator == null) {
            return;
        }
        String bookmark = modelHandle.getBookmark();
        if (bookmark != null && (tmp2 = evaluator.evaluate(ContentUtil.validExpression(bookmark))) != null && !tmp2.equals("")) {
            content.setBookmark(tmp2.toString());
        }
        if ((toc = modelHandle.getTOC()) != null && (tmp = evaluator.evaluate(ContentUtil.validExpression(toc.getExpression()))) != null) {
            content.setTOC(tmp);
        }
    }

    static void processAction(IExecutorContext context, IContent content, AbstractCrosstabItemHandle handle) {
    }

    private static String validExpression(String expr) {
        if (expr != null && expr.trim().length() > 0) {
            return expr;
        }
        return null;
    }

    private static ReportItemHandle getReportItemHandle(AbstractCrosstabItemHandle handle) {
        if (handle != null && handle.getModelHandle() instanceof ReportItemHandle) {
            return (ReportItemHandle)handle.getModelHandle();
        }
        return null;
    }

    private static ReportElementHandle getReportElementHandle(AbstractCrosstabItemHandle handle) {
        if (handle != null && handle.getModelHandle() instanceof ReportElementHandle) {
            return (ReportElementHandle)handle.getModelHandle();
        }
        return null;
    }

    private static IStyle setupRuleStyle(StructureHandle highlight, IStyle style) {
        String value = ContentUtil.getMemberProperty(highlight, "backgroundColor");
        if (value != null) {
            style.setBackgroundColor(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "textAlign")) != null) {
            style.setTextAlign(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "textIndent")) != null) {
            style.setTextIndent(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "textUnderline")) != null) {
            style.setTextUnderline(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "textLineThrough")) != null) {
            style.setTextLineThrough(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "textOverline")) != null) {
            style.setTextOverline(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "textTransform")) != null) {
            style.setTextTransform(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "fontFamily")) != null) {
            style.setFontFamily(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "color")) != null) {
            style.setColor(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "fontSize")) != null) {
            style.setFontSize(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "fontStyle")) != null) {
            style.setFontStyle(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "fontWeight")) != null) {
            style.setFontWeight(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "fontVariant")) != null) {
            style.setFontVariant(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "borderBottomColor")) != null) {
            style.setBorderBottomColor(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "borderBottomStyle")) != null) {
            style.setBorderBottomStyle(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "borderBottomWidth")) != null) {
            style.setBorderBottomWidth(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "borderLeftColor")) != null) {
            style.setBorderLeftColor(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "borderLeftStyle")) != null) {
            style.setBorderLeftStyle(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "borderLeftWidth")) != null) {
            style.setBorderLeftWidth(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "borderRightColor")) != null) {
            style.setBorderRightColor(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "borderRightStyle")) != null) {
            style.setBorderRightStyle(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "borderRightWidth")) != null) {
            style.setBorderRightWidth(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "borderTopColor")) != null) {
            style.setBorderTopColor(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "borderTopStyle")) != null) {
            style.setBorderTopStyle(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "borderTopWidth")) != null) {
            style.setBorderTopWidth(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "numberAlign")) != null) {
            style.setNumberAlign(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "dateTimeFormat")) != null) {
            style.setDateFormat(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "numberFormat")) != null) {
            style.setNumberFormat(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "stringFormat")) != null) {
            style.setStringFormat(value);
        }
        if ((value = ContentUtil.getMemberProperty(highlight, "bidiTextDirection")) != null) {
            style.setDirection(value);
        }
        return style;
    }

    private static String getMemberProperty(StructureHandle handle, String name) {
        MemberHandle prop = handle.getMember(name);
        if (prop != null) {
            return prop.getStringValue();
        }
        return null;
    }

    static DimensionType createDimension(DimensionHandle handle) {
        if (handle == null || !handle.isSet()) {
            return null;
        }
        if (handle.isKeyword()) {
            return new DimensionType(handle.getStringValue());
        }
        double measure = handle.getMeasure();
        String unit = handle.getUnits();
        return new DimensionType(measure, unit);
    }
}

