/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.birt.chart.computation.DataPointHints;
import org.eclipse.birt.chart.event.StructureSource;
import org.eclipse.birt.chart.event.StructureType;
import org.eclipse.birt.chart.factory.IDataRowExpressionEvaluator;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.attribute.ActionType;
import org.eclipse.birt.chart.model.attribute.ScriptValue;
import org.eclipse.birt.chart.model.attribute.TooltipValue;
import org.eclipse.birt.chart.model.attribute.URLValue;
import org.eclipse.birt.chart.model.data.Action;
import org.eclipse.birt.chart.render.ActionRendererAdapter;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.report.engine.api.IAction;
import org.eclipse.birt.report.engine.api.IHTMLActionHandler;
import org.eclipse.birt.report.engine.api.script.IReportContext;
import org.eclipse.birt.report.model.api.ActionHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.MemberHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ModuleUtil;
import org.eclipse.birt.report.model.api.ParamBindingHandle;
import org.eclipse.birt.report.model.api.SearchKeyHandle;

public class BIRTActionRenderer
extends ActionRendererAdapter {
    private IHTMLActionHandler handler;
    private DesignElementHandle eih;
    private IReportContext context;
    private IDataRowExpressionEvaluator evaluator;
    private Map<String, String> cacheScriptEvaluator;
    private static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.reportitem/trace");

    public BIRTActionRenderer(DesignElementHandle eih, IHTMLActionHandler handler, IDataRowExpressionEvaluator evaluator, IReportContext context) {
        this.eih = eih;
        this.handler = handler;
        this.evaluator = evaluator;
        this.context = context;
    }

    public void processAction(Action action, StructureSource source) {
        if (ActionType.URL_REDIRECT_LITERAL.equals(action.getType())) {
            URLValue uv = (URLValue)action.getValue();
            String sa = uv.getBaseUrl();
            String target = null;
            if (StructureType.SERIES_DATA_POINT.equals(source.getType())) {
                final DataPointHints dph = (DataPointHints)source.getSource();
                try {
                    final ActionHandle handle = ModuleUtil.deserializeAction((String)sa);
                    this.setTooltip(uv, handle);
                    target = handle.getTargetWindow();
                    sa = this.handler.getURL(new IAction(){

                        public int getType() {
                            if ("hyperlink".equals(handle.getLinkType())) {
                                return 1;
                            }
                            if ("bookmark-link".equals(handle.getLinkType())) {
                                return 2;
                            }
                            if ("drill-through".equals(handle.getLinkType())) {
                                return 3;
                            }
                            return 0;
                        }

                        public String getBookmark() {
                            return ChartUtil.stringValue((Object)dph.getUserValue(handle.getTargetBookmark()));
                        }

                        public String getActionString() {
                            if ("hyperlink".equals(handle.getLinkType())) {
                                return ChartUtil.stringValue((Object)dph.getUserValue(handle.getURI()));
                            }
                            if ("bookmark-link".equals(handle.getLinkType())) {
                                return ChartUtil.stringValue((Object)dph.getUserValue(handle.getTargetBookmark()));
                            }
                            return null;
                        }

                        public String getReportName() {
                            return handle.getReportName();
                        }

                        public Map getParameterBindings() {
                            HashMap<String, Object> map = new HashMap<String, Object>();
                            MemberHandle params = handle.getParamBindings();
                            if (params != null) {
                                for (ParamBindingHandle pbh : params) {
                                    map.put(pbh.getParamName(), dph.getUserValue(pbh.getExpression()));
                                }
                            }
                            return map;
                        }

                        public Map getSearchCriteria() {
                            HashMap<String, Object> map = new HashMap<String, Object>();
                            MemberHandle searches = handle.getSearch();
                            if (searches != null) {
                                for (SearchKeyHandle skh : searches) {
                                    map.put(skh.getExpression(), dph.getUserValue(skh.getExpression()));
                                }
                            }
                            return map;
                        }

                        public String getTargetWindow() {
                            return handle.getTargetWindow();
                        }

                        public String getFormat() {
                            return handle.getFormatType();
                        }

                        public boolean isBookmark() {
                            return "bookmark".equals(handle.getTargetBookmarkType());
                        }

                        public String getSystemId() {
                            ModuleHandle mod = BIRTActionRenderer.this.eih.getRoot();
                            if (mod != null) {
                                return mod.getFileName();
                            }
                            return null;
                        }

                        public String getTargetFileType() {
                            return handle.getTargetFileType();
                        }

                        public String getTooltip() {
                            return handle.getToolTip();
                        }
                    }, this.context);
                }
                catch (Exception e) {
                    sa = "";
                    logger.log(e);
                }
            } else {
                try {
                    final ActionHandle handle = ModuleUtil.deserializeAction((String)sa);
                    this.setTooltip(uv, handle);
                    target = handle.getTargetWindow();
                    sa = this.handler.getURL(new IAction(){

                        public int getType() {
                            if ("hyperlink".equals(handle.getLinkType())) {
                                return 1;
                            }
                            if ("bookmark-link".equals(handle.getLinkType())) {
                                return 2;
                            }
                            if ("drill-through".equals(handle.getLinkType())) {
                                return 3;
                            }
                            return 0;
                        }

                        public String getBookmark() {
                            return ChartUtil.stringValue((Object)BIRTActionRenderer.this.evaluator.evaluate(handle.getTargetBookmark()));
                        }

                        public String getActionString() {
                            if ("hyperlink".equals(handle.getLinkType())) {
                                return ChartUtil.stringValue((Object)BIRTActionRenderer.this.evaluator.evaluate(handle.getURI()));
                            }
                            if ("bookmark-link".equals(handle.getLinkType())) {
                                return ChartUtil.stringValue((Object)BIRTActionRenderer.this.evaluator.evaluate(handle.getTargetBookmark()));
                            }
                            return null;
                        }

                        public String getReportName() {
                            return handle.getReportName();
                        }

                        public Map getParameterBindings() {
                            HashMap<String, Object> map = new HashMap<String, Object>();
                            MemberHandle params = handle.getParamBindings();
                            if (params != null) {
                                for (ParamBindingHandle pbh : params) {
                                    map.put(pbh.getParamName(), BIRTActionRenderer.this.evaluator.evaluate(pbh.getExpression()));
                                }
                            }
                            return map;
                        }

                        public Map getSearchCriteria() {
                            HashMap<String, Object> map = new HashMap<String, Object>();
                            MemberHandle searches = handle.getSearch();
                            if (searches != null) {
                                for (SearchKeyHandle skh : searches) {
                                    map.put(skh.getExpression(), BIRTActionRenderer.this.evaluator.evaluate(skh.getExpression()));
                                }
                            }
                            return map;
                        }

                        public String getTargetWindow() {
                            return handle.getTargetWindow();
                        }

                        public String getFormat() {
                            return handle.getFormatType();
                        }

                        public boolean isBookmark() {
                            return "bookmark".equals(handle.getTargetBookmarkType());
                        }

                        public String getSystemId() {
                            ModuleHandle mod = BIRTActionRenderer.this.eih.getRoot();
                            if (mod != null) {
                                return mod.getFileName();
                            }
                            return null;
                        }

                        public String getTargetFileType() {
                            return handle.getTargetFileType();
                        }

                        public String getTooltip() {
                            return handle.getToolTip();
                        }
                    }, this.context);
                }
                catch (Exception e) {
                    sa = "";
                    logger.log(e);
                }
            }
            uv.setBaseUrl(sa);
            uv.setTarget(target);
        } else if (ActionType.SHOW_TOOLTIP_LITERAL.equals(action.getType())) {
            TooltipValue tv = (TooltipValue)action.getValue();
            if (StructureType.SERIES_DATA_POINT.equals(source.getType())) {
                DataPointHints dph = (DataPointHints)source.getSource();
                if (!dph.isVirtual()) {
                    tv.setText(ChartUtil.stringValue((Object)dph.getUserValue(tv.getText())));
                } else {
                    tv.setText(null);
                }
            }
        } else if (ActionType.INVOKE_SCRIPT_LITERAL.equals(action.getType())) {
            String evaluatResult;
            ScriptValue sv = (ScriptValue)action.getValue();
            if (this.cacheScriptEvaluator == null) {
                this.cacheScriptEvaluator = new HashMap<String, String>();
            }
            if ((evaluatResult = this.cacheScriptEvaluator.get(sv.getScript())) == null) {
                evaluatResult = this.evaluateExpression(sv.getScript());
                this.cacheScriptEvaluator.put(sv.getScript(), evaluatResult);
            }
            sv.setScript(evaluatResult);
        }
    }

    private void setTooltip(URLValue uv, ActionHandle handle) {
        if (handle.getToolTip() != null && handle.getToolTip().trim().length() > 0) {
            uv.setTooltip(handle.getToolTip());
        }
    }

    private String evaluateExpression(String script) {
        if (script == null || script.trim().length() == 0) {
            return "";
        }
        String expression = BIRTActionRenderer.findParameterExp(script, 0);
        while (expression != null) {
            Object evaluateResult = this.evaluator.evaluate(expression);
            if (evaluateResult instanceof String) {
                evaluateResult = "\"" + evaluateResult + "\"";
            }
            script = Pattern.compile(expression, 16).matcher(script).replaceAll(evaluateResult.toString());
            expression = BIRTActionRenderer.findParameterExp(script, 0);
        }
        return script;
    }

    private static String findParameterExp(String script, int fromIndex) {
        int iStart = script.indexOf("params[", fromIndex);
        if (iStart < fromIndex) {
            return null;
        }
        int iEnd = script.indexOf(93, iStart);
        if (iEnd < iStart + "params".length()) {
            return null;
        }
        return script.substring(iStart, iEnd + 1 + ExpressionUtil.EXPRESSION_VALUE_SUFFIX.length());
    }
}

