/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.olap.OLAPException;
import javax.olap.cursor.EdgeCursor;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.DataRowExpressionEvaluatorAdapter;
import org.eclipse.birt.chart.factory.IGroupedDataRowExpressionEvaluator;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.reportitem.ChartXTabUtil;
import org.eclipse.birt.chart.reportitem.i18n.Messages;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.olap.api.ICubeCursor;
import org.eclipse.birt.data.engine.olap.api.ICubeQueryResults;
import org.eclipse.birt.report.engine.extension.ICubeResultSet;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class BIRTCubeResultSetEvaluator
extends DataRowExpressionEvaluatorAdapter
implements IGroupedDataRowExpressionEvaluator {
    protected static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.reportitem/trace");
    protected final ICubeResultSet rs;
    protected final ICubeQueryResults qr;
    protected ICubeCursor cubeCursor;
    protected EdgeCursor mainEdgeCursor;
    protected EdgeCursor subEdgeCursor;
    protected List<Integer> lstBreaks = new ArrayList<Integer>();
    protected int iIndex = 0;
    protected boolean bWithoutSub = false;
    private Context cx;
    private ImporterTopLevel global;
    private ScriptableObject dataObject;

    public BIRTCubeResultSetEvaluator(ICubeResultSet rs) {
        this.rs = rs;
        this.qr = null;
    }

    public BIRTCubeResultSetEvaluator(ICubeQueryResults qr) {
        this.rs = null;
        this.qr = qr;
        this.cx = Context.enter();
        this.global = new ImporterTopLevel();
        this.dataObject = new ScriptableObject(){
            private static final long serialVersionUID = 7514367894454591834L;
            private Map<String, Object> dataValues = new HashMap<String, Object>();

            public String getClassName() {
                return "data";
            }

            public boolean has(String name, Scriptable start) {
                return this.dataValues.containsKey(name);
            }

            public void put(String name, Scriptable start, Object value) {
                this.dataValues.put(name, value);
            }

            public Object get(String name, Scriptable start) {
                return this.dataValues.get(name);
            }
        };
        this.global.put("data", (Scriptable)this.global, (Object)this.dataObject);
    }

    public int[] getGroupBreaks(int groupLevel) {
        if (this.lstBreaks.size() <= 1) {
            if (this.bWithoutSub && this.iIndex > 0) {
                int[] breaks = new int[this.iIndex - 1];
                int i = 0;
                while (i < breaks.length) {
                    breaks[i] = i + 1;
                    ++i;
                }
                return breaks;
            }
            return new int[0];
        }
        int[] breaks = new int[this.lstBreaks.size() - 1];
        int i = 0;
        while (i < breaks.length) {
            breaks[i] = this.lstBreaks.get(i);
            ++i;
        }
        return breaks;
    }

    public Object evaluate(String expression) {
        Object result = null;
        try {
            if (this.rs != null) {
                result = this.rs.evaluate(expression);
            } else {
                List<String> bindingNames = ChartXTabUtil.getBindingNameList(expression);
                for (String bindingName : bindingNames) {
                    this.dataObject.put(bindingName, (Scriptable)this.global, this.cubeCursor.getObject(bindingName));
                }
                result = this.cx.evaluateString((Scriptable)this.global, expression, "<inline>", 1, null);
            }
        }
        catch (OLAPException e) {
            logger.log((Exception)((Object)e));
        }
        catch (BirtException e) {
            logger.log((Exception)((Object)e));
        }
        return result;
    }

    public Object evaluateGlobal(String expression) {
        return this.evaluate(expression);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean next() {
        block3: {
            ++this.iIndex;
            try {
                if (this.subEdgeCursor == null) return this.mainEdgeCursor.next();
                if (!this.subEdgeCursor.next()) break block3;
                return true;
            }
            catch (OLAPException e) {
                logger.log((Exception)((Object)e));
                return false;
            }
        }
        this.lstBreaks.add(new Integer(this.iIndex));
        this.subEdgeCursor.first();
        return this.mainEdgeCursor.next();
    }

    public void close() {
        if (this.rs != null) {
            this.rs.close();
        }
        if (this.qr != null) {
            try {
                try {
                    this.qr.close();
                }
                catch (BirtException e) {
                    logger.log((Exception)((Object)e));
                    Context.exit();
                }
            }
            finally {
                Context.exit();
            }
        }
    }

    public boolean first() {
        try {
            this.initCubeCursor();
            this.mainEdgeCursor.first();
            if (this.subEdgeCursor != null) {
                this.subEdgeCursor.first();
            } else {
                this.bWithoutSub = true;
            }
            return true;
        }
        catch (OLAPException e) {
            logger.log((Exception)((Object)e));
        }
        catch (BirtException e) {
            logger.log((Exception)((Object)e));
        }
        return false;
    }

    protected void initCubeCursor() throws OLAPException, BirtException {
        if (this.cubeCursor == null) {
            this.cubeCursor = this.rs != null ? (ICubeCursor)this.rs.getCubeCursor() : this.qr.getCubeCursor();
            List edges = this.cubeCursor.getOrdinateEdge();
            if (edges.size() == 0) {
                throw new ChartException("org.eclipse.birt.chart.reportitem", 19, Messages.getString("exception.no.cube.edge"));
            }
            if (edges.size() == 1) {
                this.mainEdgeCursor = (EdgeCursor)edges.get(0);
                this.subEdgeCursor = null;
            } else {
                this.mainEdgeCursor = (EdgeCursor)edges.get(0);
                this.subEdgeCursor = (EdgeCursor)edges.get(1);
            }
        }
    }

    public boolean needCategoryGrouping() {
        return false;
    }

    public boolean needOptionalGrouping() {
        return false;
    }
}

