/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem;

import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.reportitem.ChartBaseQueryHelper;
import org.eclipse.birt.chart.reportitem.ChartCubeQueryHelper;
import org.eclipse.birt.chart.reportitem.ChartReportItemImpl;
import org.eclipse.birt.chart.reportitem.ChartReportItemUtil;
import org.eclipse.birt.chart.reportitem.ChartSharingQueryHelper;
import org.eclipse.birt.chart.reportitem.i18n.Messages;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IDataQueryDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.report.engine.extension.ReportItemQueryBase;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.re.CrosstabQueryUtil;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.MultiViewsHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.api.extension.IReportItem;

public final class ChartReportItemQueryImpl
extends ReportItemQueryBase {
    private Chart cm = null;
    private ExtendedItemHandle eih = null;
    private static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.reportitem/trace");

    public void setModelObject(ExtendedItemHandle eih) {
        IReportItem item;
        block5: {
            try {
                item = eih.getReportItem();
                if (item != null) break block5;
                try {
                    eih.loadExtendedElement();
                }
                catch (ExtendedElementException eeex) {
                    logger.log((Exception)((Object)eeex));
                }
                item = eih.getReportItem();
                if (item == null) {
                    logger.log(4, Messages.getString("ChartReportItemQueryImpl.log.UnableToLocate"));
                    return;
                }
            }
            catch (ExtendedElementException extendedElementException) {
                logger.log(4, Messages.getString("ChartReportItemQueryImpl.log.UnableToLocate"));
                return;
            }
        }
        this.cm = (Chart)((ChartReportItemImpl)item).getProperty("chart.instance");
        this.eih = eih;
    }

    public IDataQueryDefinition[] createReportQueries(IDataQueryDefinition parent) throws BirtException {
        logger.log(1, Messages.getString("ChartReportItemQueryImpl.log.getReportQueries.start"));
        IDataQueryDefinition idqd = this.createQuery(this.eih, parent);
        logger.log(1, Messages.getString("ChartReportItemQueryImpl.log.getReportQueries.end"));
        return new IDataQueryDefinition[]{idqd};
    }

    IDataQueryDefinition createQuery(ExtendedItemHandle handle, IDataQueryDefinition parent) throws BirtException {
        if (handle.getDataSet() != null || handle.getCube() == null && parent instanceof IBaseQueryDefinition) {
            ReportItemHandle itemHandle = ChartReportItemUtil.getReportItemReference((ReportItemHandle)handle);
            if (itemHandle != null) {
                return new ChartSharingQueryHelper(itemHandle, this.cm).createQuery(parent);
            }
            return new ChartBaseQueryHelper((ReportItemHandle)handle, this.cm).createBaseQuery(parent);
        }
        if (handle.getCube() != null || parent instanceof ICubeQueryDefinition) {
            if (handle.getContainer() instanceof MultiViewsHandle) {
                ExtendedItemHandle bindingHandle = (ExtendedItemHandle)ChartReportItemUtil.getReportItemReference((ReportItemHandle)handle);
                ICubeQueryDefinition cubeQuery = CrosstabQueryUtil.createCubeQuery((CrosstabReportItemHandle)((CrosstabReportItemHandle)bindingHandle.getReportItem()), (IDataQueryDefinition)parent, (boolean)true, (boolean)true, (boolean)true, (boolean)true, (boolean)true, (boolean)true);
                return cubeQuery;
            }
            return new ChartCubeQueryHelper(handle, this.cm).createCubeQuery(parent);
        }
        return null;
    }
}

