/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.computation;

import org.eclipse.birt.chart.computation.SimpleTester;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.component.Label;

public class EllipsisHelper {
    public static final String ELLIPSIS_STRING = "...";
    private int iMinCharToView = 0;
    private String sText;
    private final ILabelVisibilityTester tester;

    public EllipsisHelper(ILabelVisibilityTester tester_, int iMinCharToView) {
        this.tester = tester_;
        this.iMinCharToView = iMinCharToView;
    }

    public void setIMinCharToView(int iMinCharToView) {
        this.iMinCharToView = iMinCharToView;
    }

    private boolean testNthChar(int iChar, Object oPara) throws ChartException {
        String newText = String.valueOf(this.sText.substring(0, iChar)) + ELLIPSIS_STRING;
        return this.tester.testLabelVisible(newText, oPara);
    }

    public boolean checkLabelEllipsis(String sText_, Object oPara) throws ChartException {
        int iEnd;
        this.sText = sText_;
        boolean bCanViewFullText = this.tester.testLabelVisible(this.sText, oPara);
        if (bCanViewFullText) {
            return true;
        }
        if (this.iMinCharToView <= 0) {
            return bCanViewFullText;
        }
        int len = this.sText.length() - 1;
        if (len < this.iMinCharToView) {
            return false;
        }
        if (!this.testNthChar(this.iMinCharToView, oPara)) {
            return false;
        }
        if (len < 8) {
            int iChar = len;
            while (iChar >= this.iMinCharToView) {
                if (this.testNthChar(iChar, oPara)) {
                    return true;
                }
                --iChar;
            }
            return false;
        }
        int iStart = this.iMinCharToView;
        int iChar = iEnd = len;
        int iLimit = 19;
        while (iLimit > 0 && iEnd > iStart + 1) {
            iChar = (iStart + iEnd) / 2;
            if (this.testNthChar(iChar, oPara)) {
                iStart = iChar;
            } else {
                iEnd = iChar;
            }
            --iLimit;
        }
        if (iChar != iStart) {
            return this.testNthChar(iStart, oPara);
        }
        return true;
    }

    public static ILabelVisibilityTester createSimpleTester(IDisplayServer xs, Label la, double maxWidth, double maxHeight, double maxWrappingSize) {
        return new SimpleTester(xs, la, maxWidth, maxHeight, maxWrappingSize);
    }

    public static interface ILabelVisibilityTester {
        public boolean testLabelVisible(String var1, Object var2) throws ChartException;
    }
}

