/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.swt.custom;

import org.eclipse.birt.report.designer.internal.ui.swt.custom.Tab;
import org.eclipse.birt.report.designer.internal.ui.util.SortMap;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.util.ColorManager;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class TabbedPropertyList
extends Composite {
    private static final ListElement[] ELEMENTS_EMPTY = new ListElement[0];
    protected static final int NONE = -1;
    protected static final int INDENT = 7;
    private boolean focus = false;
    private ListElement[] elements;
    private int selectedElementIndex = -1;
    private int topVisibleIndex = -1;
    private int bottomVisibleIndex = -1;
    private TopNavigationElement topNavigationElement;
    private BottomNavigationElement bottomNavigationElement;
    private int widestLabelIndex = -1;
    private int tabsThatFitInComposite = -1;
    private Color hoverBackground;
    private Color defaultBackground;
    private Color defaultForeground;
    private Color activeBackground;
    private Color border;
    private Color darkShadow;
    private Color textColor;
    private GC textGc;
    private SortMap elementMap = null;

    public TabbedPropertyList(Composite parent) {
        super(parent, 524288);
        this.removeAll();
        this.setLayout((Layout)new FormLayout());
        this.initColours();
        this.initAccessible();
        this.topNavigationElement = new TopNavigationElement(this);
        this.bottomNavigationElement = new BottomNavigationElement(this);
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                TabbedPropertyList.this.focus = true;
                int i = TabbedPropertyList.this.getSelectionIndex();
                if (i >= 0) {
                    TabbedPropertyList.this.elements[i].redraw();
                }
            }

            public void focusLost(FocusEvent e) {
                TabbedPropertyList.this.focus = false;
                int i = TabbedPropertyList.this.getSelectionIndex();
                if (i >= 0) {
                    TabbedPropertyList.this.elements[i].redraw();
                }
            }
        });
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                TabbedPropertyList.this.topNavigationElement.redraw();
                TabbedPropertyList.this.bottomNavigationElement.redraw();
                TabbedPropertyList.this.computeTopAndBottomTab();
            }
        });
        this.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 32 || e.detail == 64) {
                    int nMax = TabbedPropertyList.this.elements.length - 1;
                    int nCurrent = TabbedPropertyList.this.getSelectionIndex();
                    if (e.detail == 32) {
                        --nCurrent;
                        nCurrent = Math.max(0, nCurrent);
                    } else if (e.detail == 64) {
                        ++nCurrent;
                        nCurrent = Math.min(nCurrent, nMax);
                    }
                    TabbedPropertyList.this.select(nCurrent, true);
                    TabbedPropertyList.this.redraw();
                } else {
                    e.doit = true;
                }
            }
        });
    }

    protected void computeTabsThatFitInComposite() {
        this.tabsThatFitInComposite = Math.round((this.getSize().y - 22) / this.getTabHeight());
        if (this.tabsThatFitInComposite <= 0) {
            this.tabsThatFitInComposite = 1;
        }
    }

    public Object getElementAt(int index) {
        if (index >= 0 && index < this.elements.length) {
            return this.elements[index];
        }
        return null;
    }

    public int getSelectionIndex() {
        return this.selectedElementIndex;
    }

    public String getSelectionKey() {
        return this.elementMap.getKeyList().get(this.selectedElementIndex).toString();
    }

    public void removeAll() {
        if (this.elements != null) {
            int i = 0;
            while (i < this.elements.length) {
                this.elements[i].dispose();
                ++i;
            }
        }
        this.elements = ELEMENTS_EMPTY;
        this.selectedElementIndex = -1;
        this.widestLabelIndex = -1;
        this.topVisibleIndex = -1;
        this.bottomVisibleIndex = -1;
    }

    public void setElements(SortMap children) {
        this.elementMap = children;
        if (this.elements != ELEMENTS_EMPTY) {
            this.removeAll();
        }
        this.elements = new ListElement[children.size()];
        if (children.size() == 0) {
            this.widestLabelIndex = -1;
        } else {
            this.widestLabelIndex = 0;
            int i = 0;
            while (i < children.size()) {
                this.elements[i] = new ListElement(this, (Tab)children.getValue(i), i);
                this.elements[i].setVisible(false);
                this.elements[i].setLayoutData(null);
                if (i != this.widestLabelIndex) {
                    String label = ((Tab)children.getValue(i)).getText();
                    if (this.getTextDimension((String)label).x > this.getTextDimension((String)((Tab)children.getValue((int)this.widestLabelIndex)).getText()).x) {
                        this.widestLabelIndex = i;
                    }
                }
                ++i;
            }
        }
        this.computeTopAndBottomTab();
    }

    public void select(int index, boolean reveal) {
        if (this.getSelectionIndex() == index) {
            return;
        }
        if (index >= 0 && index < this.elements.length) {
            int lastSelected = this.getSelectionIndex();
            this.elements[index].setSelected(true);
            this.selectedElementIndex = index;
            if (lastSelected != -1) {
                this.elements[lastSelected].setSelected(false);
                if (this.getSelectionIndex() != this.elements.length - 1) {
                    this.elements[this.getSelectionIndex() + 1].setSelected(false);
                }
            }
            this.topNavigationElement.redraw();
            this.bottomNavigationElement.redraw();
            if (this.selectedElementIndex < this.topVisibleIndex || this.selectedElementIndex > this.bottomVisibleIndex) {
                this.computeTopAndBottomTab();
            }
        }
        this.notifyListeners(13, new Event());
    }

    public void setSelection(String key, int index) {
        if (this.elementMap.containKey(key)) {
            index = this.elementMap.getIndexOf(key);
        }
        if (this.getSelectionIndex() == index) {
            return;
        }
        if (index >= 0 && index < this.elements.length) {
            int lastSelected = this.getSelectionIndex();
            this.elements[index].setSelected(true);
            this.selectedElementIndex = index;
            if (lastSelected != -1) {
                this.elements[lastSelected].setSelected(false);
                if (this.getSelectionIndex() != this.elements.length - 1) {
                    this.elements[this.getSelectionIndex() + 1].setSelected(false);
                }
            }
            this.topNavigationElement.redraw();
            this.bottomNavigationElement.redraw();
            if (this.selectedElementIndex < this.topVisibleIndex || this.selectedElementIndex > this.bottomVisibleIndex) {
                this.computeTopAndBottomTab();
            }
        }
    }

    public void deselectAll() {
        if (this.getSelectionIndex() != -1) {
            this.elements[this.getSelectionIndex()].setSelected(false);
            this.selectedElementIndex = -1;
        }
    }

    private int getIndex(ListElement element) {
        return element.index;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point result = super.computeSize(hHint, wHint, changed);
        if (this.widestLabelIndex == -1) {
            String properties_not_available = Messages.getString((String)"TabbedPropertyList.properties.not.available");
            result.x = this.getTextDimension((String)properties_not_available).x + 7;
        } else {
            int width = this.getTextDimension((String)this.elements[this.widestLabelIndex].getText()).x;
            result.x = width + 32;
            result.x = result.x >= 125 ? result.x : 125;
        }
        return result;
    }

    private Point getTextDimension(String text) {
        if (this.textGc == null || this.textGc.isDisposed()) {
            this.textGc = new GC((Drawable)this);
        }
        this.textGc.setFont(this.getFont());
        Point point = this.textGc.textExtent(text);
        ++point.x;
        return point;
    }

    private void initColours() {
        this.defaultBackground = Display.getCurrent().getSystemColor(22);
        RGB rgb = this.defaultBackground.getRGB();
        rgb.blue = Math.min(255, Math.round((float)rgb.blue * 1.05f));
        rgb.red = Math.min(255, Math.round((float)rgb.red * 1.05f));
        rgb.green = Math.min(255, Math.round((float)rgb.green * 1.05f));
        this.hoverBackground = ColorManager.getColor((RGB)rgb);
        this.defaultForeground = Display.getCurrent().getSystemColor(21);
        this.activeBackground = Display.getCurrent().getSystemColor(25);
        this.border = Display.getCurrent().getSystemColor(18);
        this.darkShadow = Display.getCurrent().getSystemColor(17);
        this.textColor = Display.getCurrent().getSystemColor(21);
    }

    public void dispose() {
        if (this.textGc != null && !this.textGc.isDisposed()) {
            this.textGc.dispose();
            this.textGc = null;
        }
        super.dispose();
    }

    private int getTabHeight() {
        int tabHeight = this.getTextDimension((String)"").y + 7;
        if (this.tabsThatFitInComposite == 1) {
            int ret = this.getBounds().height - 20;
            return ret > tabHeight ? tabHeight : (ret < 5 ? 5 : ret);
        }
        return tabHeight;
    }

    private boolean isDownScrollRequired() {
        return this.elements.length > this.tabsThatFitInComposite && this.bottomVisibleIndex != this.elements.length - 1;
    }

    private boolean isUpScrollRequired() {
        return this.elements.length > this.tabsThatFitInComposite && this.topVisibleIndex != 0;
    }

    private void computeTopAndBottomTab() {
        this.computeTabsThatFitInComposite();
        if (this.elements.length == 0) {
            this.topVisibleIndex = 0;
            this.bottomVisibleIndex = 0;
        } else if (this.tabsThatFitInComposite >= this.elements.length) {
            this.topVisibleIndex = 0;
            this.bottomVisibleIndex = this.elements.length - 1;
        } else if (this.getSelectionIndex() == -1) {
            this.topVisibleIndex = 0;
            this.bottomVisibleIndex = this.tabsThatFitInComposite - 1;
        } else if (this.getSelectionIndex() + this.tabsThatFitInComposite > this.elements.length) {
            this.bottomVisibleIndex = this.elements.length - 1;
            this.topVisibleIndex = this.bottomVisibleIndex - this.tabsThatFitInComposite + 1;
        } else {
            this.topVisibleIndex = this.selectedElementIndex;
            this.bottomVisibleIndex = this.selectedElementIndex + this.tabsThatFitInComposite - 1;
        }
        this.layoutTabs();
    }

    private void layoutTabs() {
        FormData formData;
        if (this.tabsThatFitInComposite == -1 || this.elements.length == 0) {
            formData = new FormData();
            formData.left = new FormAttachment(0, 0);
            formData.right = new FormAttachment(100, 0);
            formData.top = new FormAttachment(0, 0);
            formData.height = this.getTabHeight();
            this.topNavigationElement.setLayoutData(formData);
            formData = new FormData();
            formData.left = new FormAttachment(0, 0);
            formData.right = new FormAttachment(100, 0);
            formData.top = new FormAttachment((Control)this.topNavigationElement, 0);
            formData.bottom = new FormAttachment(100, 0);
            this.bottomNavigationElement.setLayoutData(formData);
        } else {
            formData = new FormData();
            formData.left = new FormAttachment(0, 0);
            formData.right = new FormAttachment(100, 0);
            formData.top = new FormAttachment(0, 0);
            formData.height = 10;
            this.topNavigationElement.setLayoutData(formData);
            Canvas nextElement = this.topNavigationElement;
            int i = 0;
            while (i < this.elements.length) {
                if (i < this.topVisibleIndex || i > this.bottomVisibleIndex) {
                    this.elements[i].setLayoutData(null);
                    this.elements[i].setVisible(false);
                } else {
                    formData = new FormData();
                    formData.height = this.getTabHeight();
                    formData.left = new FormAttachment(0, 0);
                    formData.right = new FormAttachment(100, 0);
                    formData.top = new FormAttachment((Control)nextElement, 0);
                    nextElement = this.elements[i];
                    this.elements[i].setLayoutData(formData);
                    this.elements[i].setVisible(true);
                }
                ++i;
            }
            formData = new FormData();
            formData.left = new FormAttachment(0, 0);
            formData.right = new FormAttachment(100, 0);
            formData.top = new FormAttachment((Control)nextElement, 0);
            formData.bottom = new FormAttachment(100, 0);
            formData.height = 10;
            this.bottomNavigationElement.setLayoutData(formData);
        }
        Composite grandparent = this.getParent().getParent();
        grandparent.layout(true);
        this.layout(true);
    }

    private void initAccessible() {
        final Accessible accessible = this.getAccessible();
        accessible.addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (TabbedPropertyList.this.getSelectionIndex() != -1) {
                    e.result = TabbedPropertyList.this.elements[TabbedPropertyList.this.getSelectionIndex()].getText();
                }
            }

            public void getHelp(AccessibleEvent e) {
                if (TabbedPropertyList.this.getSelectionIndex() != -1) {
                    e.result = TabbedPropertyList.this.elements[TabbedPropertyList.this.getSelectionIndex()].getText();
                }
            }
        });
        accessible.addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent e) {
                Point pt = TabbedPropertyList.this.toControl(new Point(e.x, e.y));
                e.childID = TabbedPropertyList.this.getBounds().contains(pt) ? -1 : -2;
            }

            public void getLocation(AccessibleControlEvent e) {
                if (TabbedPropertyList.this.getSelectionIndex() != -1) {
                    Rectangle location = TabbedPropertyList.this.elements[TabbedPropertyList.this.getSelectionIndex()].getBounds();
                    Point pt = TabbedPropertyList.this.toDisplay(new Point(location.x, location.y));
                    e.x = pt.x;
                    e.y = pt.y;
                    e.width = location.width;
                    e.height = location.height;
                }
            }

            public void getChildCount(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = 37;
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = 0x300006;
            }
        });
        this.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (TabbedPropertyList.this.isFocusControl()) {
                    accessible.setFocus(-1);
                }
            }
        });
        this.addListener(15, new Listener(){

            public void handleEvent(Event event) {
                accessible.setFocus(-1);
            }
        });
    }

    public class BottomNavigationElement
    extends Canvas {
        public BottomNavigationElement(Composite parent) {
            super(parent, 524288);
            this.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    BottomNavigationElement.this.paint(e);
                }
            });
            this.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    if (TabbedPropertyList.this.isDownScrollRequired()) {
                        TabbedPropertyList tabbedPropertyList = TabbedPropertyList.this;
                        tabbedPropertyList.topVisibleIndex = tabbedPropertyList.topVisibleIndex + 1;
                        if (TabbedPropertyList.this.bottomVisibleIndex != TabbedPropertyList.this.elements.length - 1) {
                            TabbedPropertyList tabbedPropertyList2 = TabbedPropertyList.this;
                            tabbedPropertyList2.bottomVisibleIndex = tabbedPropertyList2.bottomVisibleIndex + 1;
                        }
                        TabbedPropertyList.this.layoutTabs();
                        TabbedPropertyList.this.topNavigationElement.redraw();
                        TabbedPropertyList.this.bottomNavigationElement.redraw();
                    }
                }
            });
        }

        private void paint(PaintEvent e) {
            e.gc.setBackground(TabbedPropertyList.this.defaultBackground);
            e.gc.setForeground(TabbedPropertyList.this.defaultForeground);
            Rectangle bounds = this.getBounds();
            if (TabbedPropertyList.this.elements.length != 0) {
                e.gc.fillRectangle(0, 0, bounds.width, bounds.height);
                e.gc.setForeground(TabbedPropertyList.this.border);
                e.gc.drawLine(bounds.width - 1, 0, bounds.width - 1, bounds.height - 1);
                if (TabbedPropertyList.this.getSelectionIndex() != -1 && TabbedPropertyList.this.elements.length != 0 && TabbedPropertyList.this.getSelectionIndex() == TabbedPropertyList.this.elements.length - 1) {
                    e.gc.drawLine(4, 0, bounds.width - 1, 0);
                } else {
                    e.gc.drawLine(2, 0, bounds.width - 1, 0);
                }
            } else {
                e.gc.setBackground(TabbedPropertyList.this.activeBackground);
                e.gc.fillRectangle(0, 0, bounds.width, bounds.height);
            }
            if (TabbedPropertyList.this.isDownScrollRequired()) {
                e.gc.setForeground(TabbedPropertyList.this.darkShadow);
                int middle = bounds.width / 2;
                int bottom = bounds.height - 2;
                e.gc.drawLine(middle + 1, bottom, middle + 5, bottom - 4);
                e.gc.drawLine(middle, bottom, middle - 4, bottom - 4);
                e.gc.drawLine(middle - 4, bottom - 5, middle + 5, bottom - 5);
                e.gc.setForeground(TabbedPropertyList.this.activeBackground);
                e.gc.drawLine(middle, bottom - 1, middle + 1, bottom - 1);
                e.gc.drawLine(middle - 1, bottom - 2, middle + 2, bottom - 2);
                e.gc.drawLine(middle - 2, bottom - 3, middle + 3, bottom - 3);
                e.gc.drawLine(middle - 3, bottom - 4, middle + 4, bottom - 4);
            }
        }
    }

    public class ListElement
    extends Canvas {
        private Tab tab;
        private int index;
        private boolean selected;
        private boolean hover;

        public ListElement(Composite parent, Tab tab, int index) {
            super(parent, 524288);
            this.tab = tab;
            this.hover = false;
            this.selected = false;
            this.index = index;
            this.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    ListElement.this.paint(e);
                }
            });
            this.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    if (!ListElement.this.selected) {
                        TabbedPropertyList.this.select(TabbedPropertyList.this.getIndex(ListElement.this), true);
                        Composite tabbedPropertyComposite = ListElement.this.getParent();
                        tabbedPropertyComposite.setFocus();
                    }
                }
            });
            this.addMouseMoveListener(new MouseMoveListener(){

                public void mouseMove(MouseEvent e) {
                    if (!ListElement.this.hover) {
                        ListElement.this.hover = true;
                        ListElement.this.redraw();
                    }
                }
            });
            this.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

                public void mouseExit(MouseEvent e) {
                    ListElement.this.hover = false;
                    ListElement.this.redraw();
                }
            });
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
            this.redraw();
        }

        private void paint(PaintEvent e) {
            e.gc.setBackground(TabbedPropertyList.this.defaultBackground);
            e.gc.setForeground(TabbedPropertyList.this.defaultForeground);
            Rectangle bounds = this.getBounds();
            e.gc.fillRectangle(0, 0, bounds.width, bounds.height);
            if (this.selected) {
                e.gc.setBackground(TabbedPropertyList.this.activeBackground);
            } else if (this.hover) {
                e.gc.setBackground(TabbedPropertyList.this.hoverBackground);
            } else {
                e.gc.setBackground(TabbedPropertyList.this.defaultBackground);
            }
            if (this.selected) {
                e.gc.fillRectangle(4, 0, bounds.width, bounds.height);
                e.gc.fillRectangle(3, 1, 3, bounds.height);
            } else if (this.hover) {
                e.gc.fillRectangle(2, 0, bounds.width - 4, bounds.height);
            }
            if (this.selected) {
                e.gc.setForeground(TabbedPropertyList.this.border);
                e.gc.drawLine(4, 0, bounds.width - 1, 0);
                e.gc.drawPoint(3, 1);
                e.gc.drawPoint(3, bounds.height - 1);
                e.gc.drawLine(2, 2, 2, bounds.height - 2);
            } else {
                e.gc.setForeground(TabbedPropertyList.this.border);
                if (TabbedPropertyList.this.getSelectionIndex() != -1 && TabbedPropertyList.this.getSelectionIndex() + 1 == this.index) {
                    e.gc.drawLine(4, 0, bounds.width - 1, 0);
                } else {
                    e.gc.drawLine(2, 0, bounds.width - 3, 0);
                }
                e.gc.drawLine(bounds.width - 1, 0, bounds.width - 1, bounds.height - 1);
            }
            int textIndent = 7;
            FontMetrics fm = e.gc.getFontMetrics();
            int height = fm.getHeight();
            int textMiddle = (bounds.height - height) / 2;
            if (this.selected && this.tab.getImage() != null && !this.tab.getImage().isDisposed()) {
                e.gc.drawImage(this.tab.getImage(), textIndent - 2, textMiddle);
                textIndent = textIndent + 16 + 2;
            } else if (this.tab.isIndented()) {
                e.gc.drawRectangle(20, textMiddle + 6, 1, 1);
                textIndent = textIndent + 16 + 4;
            }
            e.gc.setForeground(TabbedPropertyList.this.textColor);
            e.gc.drawText(this.tab.getText(), textIndent, textMiddle);
            if (((TabbedPropertyList)this.getParent()).focus && this.selected) {
                Point point = e.gc.textExtent(this.tab.getText());
                e.gc.drawLine(textIndent, bounds.height - 4, textIndent + point.x, bounds.height - 4);
            }
        }

        public String getText() {
            return this.tab.getText();
        }

        public String toString() {
            return this.tab.getText();
        }
    }

    public class TopNavigationElement
    extends Canvas {
        public TopNavigationElement(Composite parent) {
            super(parent, 524288);
            this.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    TopNavigationElement.this.paint(e);
                }
            });
            this.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    if (TabbedPropertyList.this.isUpScrollRequired()) {
                        TabbedPropertyList tabbedPropertyList = TabbedPropertyList.this;
                        tabbedPropertyList.bottomVisibleIndex = tabbedPropertyList.bottomVisibleIndex - 1;
                        if (TabbedPropertyList.this.topVisibleIndex != 0) {
                            TabbedPropertyList tabbedPropertyList2 = TabbedPropertyList.this;
                            tabbedPropertyList2.topVisibleIndex = tabbedPropertyList2.topVisibleIndex - 1;
                        }
                        TabbedPropertyList.this.layoutTabs();
                        TabbedPropertyList.this.topNavigationElement.redraw();
                        TabbedPropertyList.this.bottomNavigationElement.redraw();
                    }
                }
            });
        }

        private void paint(PaintEvent e) {
            e.gc.setBackground(TabbedPropertyList.this.defaultBackground);
            e.gc.setForeground(TabbedPropertyList.this.defaultForeground);
            Rectangle bounds = this.getBounds();
            if (TabbedPropertyList.this.elements.length != 0) {
                e.gc.fillRectangle(0, 0, bounds.width, bounds.height);
                e.gc.setForeground(TabbedPropertyList.this.border);
                e.gc.drawLine(bounds.width - 1, 0, bounds.width - 1, bounds.height - 1);
            } else {
                e.gc.setBackground(TabbedPropertyList.this.activeBackground);
                e.gc.fillRectangle(0, 0, bounds.width, bounds.height);
                int textIndent = 7;
                FontMetrics fm = e.gc.getFontMetrics();
                int height = fm.getHeight();
                int textMiddle = (bounds.height - height) / 2;
                e.gc.setForeground(TabbedPropertyList.this.textColor);
                String properties_not_available = Messages.getString((String)"TabbedPropertyList.properties.not.available");
                e.gc.drawText(properties_not_available, textIndent, textMiddle);
            }
            if (TabbedPropertyList.this.isUpScrollRequired()) {
                e.gc.setForeground(TabbedPropertyList.this.darkShadow);
                int middle = bounds.width / 2;
                e.gc.drawLine(middle + 1, 3, middle + 5, 7);
                e.gc.drawLine(middle, 3, middle - 4, 7);
                e.gc.drawLine(middle - 4, 8, middle + 5, 8);
                e.gc.setForeground(TabbedPropertyList.this.activeBackground);
                e.gc.drawLine(middle, 4, middle + 1, 4);
                e.gc.drawLine(middle - 1, 5, middle + 2, 5);
                e.gc.drawLine(middle - 2, 6, middle + 3, 6);
                e.gc.drawLine(middle - 3, 7, middle + 4, 7);
            }
        }
    }
}

