/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.actions;

import java.io.File;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.actions.AbstractViewAction;
import org.eclipse.birt.report.designer.internal.ui.wizards.PublishLibraryWizard;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;

public class PublishLibraryToResourceFolderAction
extends AbstractViewAction {
    public static final String ACTION_TEXT = Messages.getString((String)"PublishLibraryToResourceFolderAction.Action.Text");
    private String filePath;
    private String fileName;
    private String folderName;

    public PublishLibraryToResourceFolderAction(Object selectedObject) {
        super(selectedObject, ACTION_TEXT);
    }

    public PublishLibraryToResourceFolderAction(Object selectedObject, String text) {
        super(selectedObject, text);
    }

    public boolean isEnable() {
        Object selectObj = this.getSelection();
        return selectObj instanceof LibraryHandle;
    }

    public void run() {
        if (!this.isEnable()) {
            return;
        }
        ModuleHandle module = SessionHandleAdapter.getInstance().getReportDesignHandle();
        String filePath = module.getFileName();
        String fileName = filePath.substring(filePath.lastIndexOf(File.separator) + 1);
        PublishLibraryWizard publishLibrary = new PublishLibraryWizard((LibraryHandle)module, fileName, ReportPlugin.getDefault().getResourceFolder());
        WizardDialog dialog = new WizardDialog(UIUtil.getDefaultShell(), (IWizard)publishLibrary);
        dialog.setPageSize(500, 250);
        dialog.open();
    }
}

