/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.provider;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.AdvancedPropertyContentProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.AdvancedPropertyNameLabelProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.AdvancedPropertyValueLabelProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.IDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.memento.Memento;
import org.eclipse.birt.report.designer.internal.ui.views.memento.MementoElement;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;

public class AdvancePropertyDescriptorProvider
implements IDescriptorProvider {
    private Object input;
    private AdvancedPropertyContentProvider contentProvider = new AdvancedPropertyContentProvider();
    private AdvancedPropertyValueLabelProvider valueLabelProvider = new AdvancedPropertyValueLabelProvider();
    private AdvancedPropertyNameLabelProvider nameLabelProvider = new AdvancedPropertyNameLabelProvider();

    public String getDisplayName() {
        return Messages.getString((String)"AdvancePropertyDescriptorProvider.DisplayName");
    }

    public Object load() {
        return null;
    }

    public void save(Object value) throws SemanticException {
    }

    public void setInput(Object input) {
        this.input = input;
    }

    public boolean isEnable() {
        return this.input != null && DEUtil.getGroupElementHandle((List)DEUtil.getInputElements((Object)this.input)).isSameType();
    }

    public String getTitleDisplayName() {
        String displayName = null;
        DesignElementHandle element = (DesignElementHandle)DEUtil.getInputFirstElement((Object)this.input);
        if (element != null) {
            displayName = this.getElementType();
        }
        if (!this.isEnable() || displayName == null || "".equals(displayName)) {
            displayName = Messages.getString((String)"ReportPropertySheetPage.Root.Default.Title");
        }
        return displayName;
    }

    public AdvancedPropertyContentProvider getContentProvier() {
        return this.contentProvider;
    }

    public AdvancedPropertyValueLabelProvider getValueLabelProvier() {
        return this.valueLabelProvider;
    }

    public AdvancedPropertyNameLabelProvider getNameLabelProvier() {
        return this.nameLabelProvider;
    }

    public boolean addNode(Memento element, MementoElement[] nodePath) {
        if (nodePath != null && nodePath.length > 0) {
            MementoElement memento = element.getMementoElement();
            if (!memento.equals((Object)nodePath[0])) {
                return false;
            }
            int i = 1;
            while (i < nodePath.length) {
                MementoElement child = this.getChild(memento, nodePath[i]);
                if (child == null) {
                    memento.addChild(nodePath[i]);
                    return true;
                }
                memento = child;
                ++i;
            }
            return true;
        }
        return false;
    }

    public boolean removeNode(Memento element, MementoElement[] nodePath) {
        if (nodePath != null && nodePath.length > 0) {
            MementoElement memento = element.getMementoElement();
            if (!memento.equals((Object)nodePath[0])) {
                return false;
            }
            int i = 1;
            while (i < nodePath.length) {
                MementoElement child = this.getChild(memento, nodePath[i]);
                if (child == null) {
                    return false;
                }
                memento = child;
                ++i;
            }
            memento.getParent().removeChild(memento);
            return true;
        }
        return false;
    }

    private MementoElement getChild(MementoElement parent, MementoElement key) {
        MementoElement[] children = parent.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i].equals((Object)key)) {
                return children[i];
            }
            ++i;
        }
        return null;
    }

    public MementoElement[] getNodePath(MementoElement node) {
        LinkedList<MementoElement> pathList = new LinkedList<MementoElement>();
        MementoElement memento = node;
        pathList.add(node);
        while (memento.getChildren().length > 0) {
            pathList.add(memento.getChild(0));
            memento = memento.getChild(0);
        }
        MementoElement[] paths = new MementoElement[pathList.size()];
        pathList.toArray(paths);
        return paths;
    }

    public String getElementType() {
        String displayName = ((DesignElementHandle)DEUtil.getInputFirstElement((Object)this.input)).getDefn().getDisplayName();
        if (displayName == null || "".equals(displayName)) {
            displayName = ((DesignElementHandle)DEUtil.getInputFirstElement((Object)this.input)).getDefn().getName();
        }
        return displayName;
    }
}

