/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.section;

import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.IDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.section.Section;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.DescriptorToolkit;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.UnitPropertyDescriptor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class UnitSection
extends Section {
    protected UnitPropertyDescriptor unit;
    IDescriptorProvider provider;
    private int width = -1;
    boolean fillUnit = false;
    UnitPropertyDescriptor customUnit;

    public UnitSection(String labelText, Composite parent, boolean isFormStyle) {
        super(labelText, parent, isFormStyle);
    }

    public void createSection() {
        this.getLabelControl(this.parent);
        this.getUnitComboControl(this.parent);
        this.getGridPlaceholder(this.parent);
    }

    public UnitPropertyDescriptor getUnitComboControl() {
        return this.unit;
    }

    protected UnitPropertyDescriptor getUnitComboControl(Composite parent) {
        if (this.unit == null) {
            this.unit = this.customUnit != null ? this.customUnit : DescriptorToolkit.createUnitPropertyDescriptor(true);
            if (this.getProvider() != null) {
                this.unit.setDescriptorProvider(this.getProvider());
            }
            this.unit.createControl(parent);
            this.unit.getControl().setLayoutData((Object)new GridData());
            this.unit.getControl().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    UnitSection.this.unit = null;
                }
            });
        } else {
            this.checkParent(this.unit.getControl(), parent);
        }
        return this.unit;
    }

    public void layout() {
        GridData gd = (GridData)this.unit.getControl().getLayoutData();
        gd.horizontalSpan = this.getLayoutNum() > 0 ? this.getLayoutNum() - 1 - this.placeholder : ((GridLayout)this.parent.getLayout()).numColumns - 1 - this.placeholder;
        if (this.width > -1) {
            gd.widthHint = this.width;
            gd.grabExcessHorizontalSpace = false;
        } else {
            gd.grabExcessHorizontalSpace = this.fillUnit;
        }
    }

    public void load() {
        if (this.unit != null && !this.unit.getControl().isDisposed()) {
            this.unit.load();
        }
    }

    public IDescriptorProvider getProvider() {
        return this.provider;
    }

    public void setProvider(IDescriptorProvider provider) {
        this.provider = provider;
        if (this.unit != null) {
            this.unit.setDescriptorProvider(provider);
        }
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setInput(Object input) {
        assert (input != null);
        this.unit.setInput(input);
    }

    public boolean isFillUnit() {
        return this.fillUnit;
    }

    public void setFillUnit(boolean fillUnit) {
        this.fillUnit = fillUnit;
    }

    public void setHidden(boolean isHidden) {
        if (this.displayLabel != null) {
            WidgetUtil.setExcludeGridData((Control)this.displayLabel, isHidden);
        }
        if (this.unit != null) {
            this.unit.setHidden(isHidden);
        }
        if (this.placeholderLabel != null) {
            WidgetUtil.setExcludeGridData((Control)this.placeholderLabel, isHidden);
        }
    }

    public void setVisible(boolean isVisible) {
        if (this.displayLabel != null) {
            this.displayLabel.setVisible(isVisible);
        }
        if (this.unit != null) {
            this.unit.setVisible(isVisible);
        }
        if (this.placeholderLabel != null) {
            this.placeholderLabel.setVisible(isVisible);
        }
    }

    public void setUnit(UnitPropertyDescriptor unit) {
        this.customUnit = unit;
    }
}

