/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.widget;

import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.FormWidgetFactory;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionBuilder;
import org.eclipse.birt.report.designer.ui.dialogs.IExpressionProvider;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.accessibility.AccessibleTextAdapter;
import org.eclipse.swt.accessibility.AccessibleTextEvent;
import org.eclipse.swt.accessibility.AccessibleTextListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ExpressionComposite
extends Composite {
    protected Button button;
    protected Text text;
    private IExpressionProvider provider;

    public ExpressionComposite(Composite parent, boolean isFormStyle) {
        super(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 2;
        layout.marginWidth = 2;
        layout.verticalSpacing = 2;
        layout.horizontalSpacing = 3;
        this.setLayout((Layout)layout);
        this.text = isFormStyle ? FormWidgetFactory.getInstance().createText(this, "", 12) : new Text((Composite)this, 12);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.text.setLayoutData((Object)data);
        this.button = FormWidgetFactory.getInstance().createButton(this, 0x800000, isFormStyle);
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExpressionBuilder dialog = new ExpressionBuilder(ExpressionComposite.this.button.getShell(), ExpressionComposite.this.text.getText());
                dialog.setExpressionProvier(ExpressionComposite.this.provider);
                if (dialog.open() == 0) {
                    String newValue = dialog.getResult();
                    if (!ExpressionComposite.this.text.getText().equals(newValue)) {
                        ExpressionComposite.this.text.setText(newValue);
                        ExpressionComposite.this.notifyListeners(24, null);
                    }
                }
            }
        });
        UIUtil.setExpressionButtonImage((Button)this.button);
        this.button.setToolTipText(Messages.getString((String)"ExpressionBuilder.toolTipText.Button"));
        this.initAccessible();
    }

    void initAccessible() {
        this.button.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getHelp(AccessibleEvent e) {
                e.result = ExpressionComposite.this.button.getToolTipText();
            }
        });
        this.text.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getRole(AccessibleControlEvent e) {
                e.detail = ExpressionComposite.this.text.getEditable() ? 42 : 41;
            }
        });
        this.getAccessible().addAccessibleTextListener((AccessibleTextListener)new AccessibleTextAdapter(){

            public void getCaretOffset(AccessibleTextEvent e) {
                e.offset = ExpressionComposite.this.text.getCaretPosition();
            }

            public void getSelectionRange(AccessibleTextEvent e) {
                Point sel = ExpressionComposite.this.text.getSelection();
                e.offset = sel.x;
                e.length = sel.y - sel.x;
            }
        });
        this.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent e) {
                Point testPoint = ExpressionComposite.this.toControl(e.x, e.y);
                if (ExpressionComposite.this.getBounds().contains(testPoint)) {
                    e.childID = -1;
                }
            }

            public void getLocation(AccessibleControlEvent e) {
                Rectangle location = ExpressionComposite.this.getBounds();
                Point pt = ExpressionComposite.this.toDisplay(location.x, location.y);
                e.x = pt.x;
                e.y = pt.y;
                e.width = location.width;
                e.height = location.height;
            }

            public void getChildCount(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = 42;
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getValue(AccessibleControlEvent e) {
                e.result = ExpressionComposite.this.getText();
            }
        });
    }

    public void setText(String string) {
        this.text.setText(string);
    }

    public String getText() {
        return this.text.getText();
    }

    public void setEnabled(boolean enabled) {
        this.text.setEnabled(enabled);
        this.button.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    public void setExpressionProvider(IExpressionProvider provider) {
        this.provider = provider;
    }
}

