/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.widget;

import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.ExpressionPropertyDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.FormWidgetFactory;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.PropertyDescriptor;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionBuilder;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionProvider;
import org.eclipse.birt.report.designer.ui.dialogs.IExpressionProvider;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ExpressionPropertyDescriptor
extends PropertyDescriptor {
    protected Text text;
    protected Button button;
    private Composite containerPane;
    private String deValue;
    private String newValue;
    private String buttonText;

    public ExpressionPropertyDescriptor(boolean formStyle) {
        this.setFormStyle(formStyle);
    }

    public Text getTextControl() {
        return this.text;
    }

    public void setInput(Object handle) {
        this.input = handle;
        this.getDescriptorProvider().setInput(this.input);
    }

    public void load() {
        this.deValue = this.getDescriptorProvider().load().toString();
        if (this.getDescriptorProvider() instanceof ExpressionPropertyDescriptorProvider) {
            boolean readOnly = ((ExpressionPropertyDescriptorProvider)this.getDescriptorProvider()).isReadOnly();
            this.button.setEnabled(!readOnly);
            this.text.setEnabled(!readOnly);
            boolean enable = ((ExpressionPropertyDescriptorProvider)this.getDescriptorProvider()).isEnable();
            this.button.setEnabled(enable);
            this.text.setEnabled(enable);
        }
        UIUtil.setExpressionButtonImage((Button)this.button);
        if (this.deValue == null) {
            this.deValue = "";
        }
        if (!this.text.getText().equals(this.deValue)) {
            this.text.setText(this.deValue);
        }
    }

    public Control getControl() {
        return this.containerPane;
    }

    public Control createControl(Composite parent) {
        this.containerPane = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.containerPane.setLayout((Layout)layout);
        this.text = this.isFormStyle() ? FormWidgetFactory.getInstance().createText(this.containerPane, "", 834) : new Text(this.containerPane, 2882);
        this.text.setLayoutData((Object)new GridData(1808));
        this.text.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                ExpressionPropertyDescriptor.this.handleFocusLostEvent();
            }
        });
        this.button = this.isFormStyle() ? FormWidgetFactory.getInstance().createButton(this.containerPane, 8, true) : new Button(this.containerPane, 8);
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExpressionPropertyDescriptor.this.handleButtonSelectEvent();
            }
        });
        UIUtil.setExpressionButtonImage((Button)this.button);
        return this.containerPane;
    }

    protected void handleSelectEvent() {
        this.newValue = this.text.getText();
        this.processAction();
    }

    protected void handleFocusLostEvent() {
        this.newValue = this.text.getText();
        this.processAction();
    }

    private void processAction() {
        String value = this.newValue;
        if (value != null && value.length() == 0) {
            value = null;
        }
        if (value == null && this.deValue != null || value != null && !value.equals(this.deValue)) {
            try {
                this.text.setText(UIUtil.convertToGUIString((String)value));
                this.save(value);
            }
            catch (SemanticException e1) {
                this.text.setText(UIUtil.convertToGUIString((String)this.deValue));
                WidgetUtil.processError(this.text.getShell(), (Exception)((Object)e1));
            }
        }
    }

    public void setButtonText(String text) {
    }

    public void setText(String text) {
        this.text.setText(text);
    }

    public void save(Object obj) throws SemanticException {
        this.getDescriptorProvider().save(obj);
    }

    protected void handleButtonSelectEvent() {
        ExpressionProvider provider;
        ExpressionBuilder builder = new ExpressionBuilder(this.button.getShell(), this.deValue);
        if (this.getDescriptorProvider() instanceof ExpressionPropertyDescriptorProvider && (provider = ((ExpressionPropertyDescriptorProvider)this.getDescriptorProvider()).getExpressionProvider()) != null) {
            builder.setExpressionProvier((IExpressionProvider)provider);
        }
        if (builder.open() == 0) {
            this.newValue = builder.getResult();
            this.processAction();
        }
    }

    public void setHidden(boolean isHidden) {
        WidgetUtil.setExcludeGridData((Control)this.containerPane, isHidden);
    }

    public void setVisible(boolean isVisible) {
        this.containerPane.setVisible(isVisible);
    }
}

