/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.widget;

import java.math.BigDecimal;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.CSpinner;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.IDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.MarginsPropertyDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.FormWidgetFactory;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.PropertyDescriptor;
import org.eclipse.birt.report.designer.ui.widget.IValueChangedListener;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.DimensionValue;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class MarginsPropertyDescriptor
extends PropertyDescriptor {
    protected CSpinner spinner;
    protected CCombo combo;
    protected Composite container;
    private MarginsPropertyDescriptorProvider provider;

    public MarginsPropertyDescriptor(boolean formStyle) {
        this.setFormStyle(formStyle);
    }

    public void load() {
        String comboValue;
        boolean stateFlag;
        String value = this.provider.load().toString();
        boolean bl = stateFlag = value == null == this.spinner.getEnabled();
        if (stateFlag) {
            this.spinner.setEnabled(value != null);
            this.combo.setEnabled(value != null);
        }
        if (value == null) {
            return;
        }
        String spinnerValue = this.provider.getMeasureValue();
        BigDecimal bigValue = new BigDecimal(spinnerValue);
        this.spinner.setSelection(bigValue.doubleValue());
        if (this.combo.getItems() == null || this.combo.getItemCount() == 0) {
            this.combo.setItems(this.provider.getUnits());
        }
        if (this.provider.getUnitDisplayName(comboValue = this.provider.getDefaultUnit()) == null) {
            this.combo.deselectAll();
            return;
        }
        if (!this.provider.getUnitDisplayName(comboValue).equals(this.combo.getText())) {
            this.combo.deselectAll();
            this.combo.setText(this.provider.getUnitDisplayName(comboValue));
        }
    }

    public Control getControl() {
        return this.container;
    }

    public Control createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        FormLayout layout = new FormLayout();
        if (this.isFormStyle()) {
            layout.marginHeight = 1;
            layout.marginWidth = 2;
            layout.spacing = 4;
        } else {
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.spacing = 0;
        }
        this.container.setLayout((Layout)layout);
        Label label = FormWidgetFactory.getInstance().createLabel(this.container, this.isFormStyle());
        label.setText(this.provider.getDisplayName());
        this.spinner = this.isFormStyle() ? FormWidgetFactory.getInstance().createCSpinner(this.container) : new CSpinner(this.container, 2048);
        this.spinner.setMaximum(32767.0);
        this.spinner.setMinimum(-32767.0);
        this.spinner.setStep(0.25);
        this.spinner.setSelection(0.0);
        this.spinner.setFormatPattern("0.00");
        this.spinner.addValueChangeListener(new IValueChangedListener(){

            public void valueChanged(double newValue) {
                MarginsPropertyDescriptor.this.handleSelectedEvent();
            }
        });
        this.combo = !this.isFormStyle() ? new CCombo(this.container, 2056) : FormWidgetFactory.getInstance().createCCombo(this.container, true);
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MarginsPropertyDescriptor.this.handleSelectedEvent();
            }
        });
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.spinner, 0, 1024);
        data.left = new FormAttachment((Control)this.spinner, 0, 16384);
        data.right = new FormAttachment((Control)this.spinner, 0, 131072);
        this.combo.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)label, 0, 1024);
        data.left = new FormAttachment((Control)label, 0, 16384);
        data.right = new FormAttachment(100, -layout.spacing);
        this.spinner.setLayoutData((Object)data);
        return this.container;
    }

    protected void handleSelectedEvent() {
        try {
            this.save(new DimensionValue(this.spinner.getSelection(), this.provider.getUnit(this.combo.getText())));
        }
        catch (SemanticException e) {
            WidgetUtil.processError(this.combo.getShell(), (Exception)((Object)e));
        }
    }

    public void setDescriptorProvider(IDescriptorProvider provider) {
        super.setDescriptorProvider(provider);
        if (provider instanceof MarginsPropertyDescriptorProvider) {
            this.provider = (MarginsPropertyDescriptorProvider)provider;
        }
    }

    public void save(Object obj) throws SemanticException {
        this.provider.save(obj);
    }

    public void setHidden(boolean isHidden) {
        WidgetUtil.setExcludeGridData((Control)this.container, isHidden);
    }

    public void setVisible(boolean isVisible) {
        this.container.setVisible(isVisible);
    }

    public void setInput(Object input) {
        super.setInput(input);
        this.getDescriptorProvider().setInput(input);
    }
}

