/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.widget;

import java.util.Arrays;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.PropertyDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.SimpleComboPropertyDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.FormWidgetFactory;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.PropertyDescriptor;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class SimpleComboPropertyDescriptor
extends PropertyDescriptor {
    protected CCombo combo;
    protected String oldValue;
    private int style = 2048;

    public SimpleComboPropertyDescriptor(boolean formStyle) {
        this.setFormStyle(formStyle);
    }

    public void setInput(Object handle) {
        this.input = handle;
        this.getDescriptorProvider().setInput(this.input);
    }

    public Control getControl() {
        return this.combo;
    }

    public Control createControl(Composite parent) {
        this.combo = this.isFormStyle() ? FormWidgetFactory.getInstance().createCCombo(parent) : new CCombo(parent, this.style);
        this.combo.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
                SimpleComboPropertyDescriptor.this.combo.clearSelection();
            }

            public void controlResized(ControlEvent e) {
                SimpleComboPropertyDescriptor.this.combo.clearSelection();
            }
        });
        this.combo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SimpleComboPropertyDescriptor.this.handleComboSelectEvent();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                SimpleComboPropertyDescriptor.this.handleComboSelectEvent();
            }
        });
        return this.combo;
    }

    protected void handleComboSelectEvent() {
        String newValue = this.combo.getText();
        if (ChoiceSetFactory.CHOICE_NONE.equals(newValue)) {
            newValue = null;
        }
        try {
            this.save(newValue);
        }
        catch (SemanticException e) {
            WidgetUtil.processError(this.combo.getShell(), (Exception)((Object)e));
            this.combo.setText(this.oldValue);
            this.combo.setSelection(new Point(0, this.oldValue.length()));
        }
    }

    public int getStyle() {
        return this.style;
    }

    public void load() {
        this.oldValue = this.getDescriptorProvider().load().toString();
        this.refresh(this.oldValue);
    }

    public void addStyle(int style) {
        this.style |= style;
    }

    protected void refresh(String value) {
        if (this.getDescriptorProvider() instanceof SimpleComboPropertyDescriptorProvider) {
            boolean stateFlag;
            String[] items = ((SimpleComboPropertyDescriptorProvider)this.getDescriptorProvider()).getItems();
            this.combo.setItems(items);
            boolean bl = stateFlag = value == null == this.combo.getEnabled();
            if (stateFlag) {
                this.combo.setEnabled(value != null);
            }
            if (((PropertyDescriptorProvider)this.getDescriptorProvider()).isReadOnly()) {
                this.combo.setEnabled(false);
            }
            int sindex = Arrays.asList(items).indexOf(this.oldValue);
            if (((SimpleComboPropertyDescriptorProvider)this.getDescriptorProvider()).isSpecialProperty() && sindex < 0) {
                if (value != null && value.length() > 0) {
                    this.combo.setText(value);
                    return;
                }
                if (this.combo.getItemCount() > 0) {
                    this.combo.select(0);
                    return;
                }
            }
            this.combo.select(sindex);
        }
    }

    public void save(Object value) throws SemanticException {
        this.descriptorProvider.save(value);
    }

    public String getStringValue() {
        return this.combo.getText();
    }

    public void setStringValue(String value) {
        this.combo.setText(value);
    }

    public void setHidden(boolean isHidden) {
        WidgetUtil.setExcludeGridData((Control)this.combo, isHidden);
    }

    public void setVisible(boolean isVisible) {
        this.combo.setVisible(isVisible);
    }
}

