/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.data.providers;

import java.util.Map;
import org.eclipse.birt.report.designer.internal.ui.views.DefaultNodeProvider;
import org.eclipse.birt.report.designer.internal.ui.views.actions.InsertAction;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.CascadingParametersDialog;
import org.eclipse.birt.report.designer.ui.dialogs.ParameterDialog;
import org.eclipse.birt.report.designer.ui.dialogs.ParameterGroupDialog;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class ParametersNodeProvider
extends DefaultNodeProvider {
    public Object[] getChildren(Object model) {
        if (model instanceof ModuleHandle) {
            return new Object[]{((ModuleHandle)model).getParameters()};
        }
        return super.getChildren(model);
    }

    public void createContextMenu(TreeViewer sourceViewer, Object object, IMenuManager menu) {
        menu.add((IAction)new InsertAction(object, Messages.getString((String)"ParametersNodeProvider.menu.text.parameter"), "ScalarParameter"));
        menu.add((IAction)new InsertAction(object, Messages.getString((String)"ParametersNodeProvider.menu.text.cascadingParameter"), "CascadingParameterGroup"));
        menu.add((IAction)new InsertAction(object, Messages.getString((String)"ParametersNodeProvider.menu.text.group"), "ParameterGroup"));
        super.createContextMenu(sourceViewer, object, menu);
    }

    public String getNodeDisplayName(Object object) {
        return PARAMETERS;
    }

    protected DesignElementHandle createElement(String type) throws Exception {
        DesignElementHandle handle = super.createElement(type);
        ParameterGroupDialog dialog = null;
        if ("ParameterGroup".equals(type)) {
            dialog = new ParameterGroupDialog(Display.getCurrent().getActiveShell(), Messages.getString((String)"ParametersNodeProvider.dialogue.title.group"));
            dialog.setInput((Object)handle);
        } else if ("ScalarParameter".equals(type)) {
            dialog = new ParameterDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), Messages.getString((String)"ParametersNodeProvider.dialogue.title.parameter"));
            ((ParameterDialog)dialog).setInput((Object)handle);
        }
        if (dialog.open() == 1) {
            return null;
        }
        return (DesignElementHandle)dialog.getResult();
    }

    protected boolean performInsert(Object model, SlotHandle slotHandle, String type, String position, Map extendData) throws Exception {
        if (type == "CascadingParameterGroup") {
            DesignElementHandle handle = super.createElement(type);
            slotHandle.add(handle);
            CascadingParametersDialog dialog = new CascadingParametersDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), Messages.getString((String)"ParameterNodeProvider.dial.title.newCascading"));
            dialog.setInput((Object)handle);
            return dialog.open() == 0;
        }
        return super.performInsert(model, slotHandle, type, position, extendData);
    }

    public String getIconName(Object model) {
        return "Parameters";
    }
}

