/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem.ui.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.chart.reportitem.ui.i18n.Messages;
import org.eclipse.birt.report.designer.internal.ui.dialogs.ExpressionFilter;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionProvider;
import org.eclipse.birt.report.model.api.DesignElementHandle;

public class ChartExpressionProvider
extends ExpressionProvider {
    public static final String CHART_VARIABLES = Messages.getString("ChartExpressionProvider.Category.ChartVariables");
    private static final String DATA_POINTS = Messages.getString("ChartExpressionProvider.ChartVariables.DataPoints");
    private static final String JAVASCRIPT = Messages.getString("ChartExpressionProvider.ChartVariables.JavaScript");
    private static final String JAVASCRIPT_EVENT = Messages.getString("ChartExpressionProvider.ChartVariables.Event");
    private static final String JAVASCRIPT_EVENT_PARAMETER = "evt";
    public static final int CATEGORY_BASE = 0;
    public static final int CATEGORY_WITH_CHART_VARIABLES = 1;
    public static final int CATEGORY_WITH_BIRT_VARIABLES = 2;
    public static final int CATEGORY_WITH_COLUMN_BINDINGS = 4;
    public static final int CATEGORY_WITH_REPORT_PARAMS = 8;
    public static final int CATEGORY_WITH_JAVASCRIPT = 16;
    private final int _categoryStyle;

    public ChartExpressionProvider() {
        this(null, 0);
    }

    public ChartExpressionProvider(DesignElementHandle handle, int categoryStyle) {
        super(handle, true);
        this._categoryStyle = categoryStyle;
        this.init();
    }

    private void init() {
        final ArrayList<String> filteredList = new ArrayList<String>(3);
        filteredList.add(CURRENT_CUBE);
        if ((this._categoryStyle & 2) != 2) {
            filteredList.add(BIRT_OBJECTS);
        }
        if ((this._categoryStyle & 4) != 4) {
            filteredList.add(COLUMN_BINDINGS);
        }
        if ((this._categoryStyle & 8) != 8) {
            filteredList.add(PARAMETERS);
        }
        if (!filteredList.isEmpty()) {
            this.addFilter(new ExpressionFilter(){

                public boolean select(Object parentElement, Object element) {
                    return !filteredList.contains(element);
                }
            });
        }
    }

    protected List getCategoryList() {
        List list = super.getCategoryList();
        if ((this._categoryStyle & 1) == 1 || (this._categoryStyle & 0x10) == 16) {
            list.add(CHART_VARIABLES);
        }
        return list;
    }

    protected List getChildrenList(Object parent) {
        List list = super.getChildrenList(parent);
        if (DATA_POINTS.equals(parent)) {
            list.add("categoryData");
            list.add("valueData");
            list.add("valueSeriesName");
        } else if (CHART_VARIABLES.equals(parent)) {
            if ((this._categoryStyle & 1) == 1) {
                list.add(DATA_POINTS);
            }
            if ((this._categoryStyle & 0x10) == 16) {
                list.add(JAVASCRIPT);
            }
        } else if (JAVASCRIPT.equals(parent)) {
            list.add(JAVASCRIPT_EVENT_PARAMETER);
        }
        return list;
    }

    public String getDisplayText(Object element) {
        if (element.equals("categoryData")) {
            return Messages.getString("ChartExpressionProvider.DataPoints.BaseValue");
        }
        if (element.equals("valueData")) {
            return Messages.getString("ChartExpressionProvider.DataPoints.OrthogonalValue");
        }
        if (element.equals("valueSeriesName")) {
            return Messages.getString("ChartExpressionProvider.DataPoints.SeriesValue");
        }
        if (element.equals(JAVASCRIPT_EVENT_PARAMETER)) {
            return JAVASCRIPT_EVENT;
        }
        return super.getDisplayText(element);
    }
}

