/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem.ui.views.attributes.widget;

import java.util.Arrays;
import org.eclipse.birt.chart.reportitem.ui.views.attributes.provider.ChoicePropertyDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.IDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.FormWidgetFactory;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.PropertyDescriptor;
import org.eclipse.birt.report.designer.ui.views.attributes.AttributesUtil;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ChoicePropertyDescriptor
extends PropertyDescriptor {
    protected CCombo combo;
    private String oldValue;
    private int style = 2048;
    ChoicePropertyDescriptorProvider provider;

    public ChoicePropertyDescriptor(boolean isFormStyle) {
        super.setFormStyle(isFormStyle);
    }

    public Control getControl() {
        return this.combo;
    }

    public Control createControl(Composite parent) {
        this.combo = !this.isFormStyle() ? new CCombo(parent, this.style | 8) : FormWidgetFactory.getInstance().createCCombo(parent, true);
        this.combo.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
                ChoicePropertyDescriptor.this.combo.clearSelection();
            }

            public void controlResized(ControlEvent e) {
                ChoicePropertyDescriptor.this.combo.clearSelection();
            }
        });
        this.combo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ChoicePropertyDescriptor.this.handleSelectEvent();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ChoicePropertyDescriptor.this.handleSelectEvent();
            }
        });
        return this.combo;
    }

    protected void handleSelectEvent() {
        String newValue = this.combo.getText();
        if (ChoiceSetFactory.CHOICE_NONE.equals(newValue)) {
            newValue = null;
        }
        try {
            this.save(newValue);
        }
        catch (SemanticException e) {
            AttributesUtil.handleError((Throwable)e);
            this.combo.setText(this.oldValue);
            this.combo.setSelection(new Point(0, this.oldValue.length()));
        }
    }

    public void load() {
        int sindex;
        boolean stateFlag;
        String[] items = new String[]{};
        String[] values = null;
        this.combo.setItems(this.provider.getItems());
        values = this.provider.getValues();
        this.oldValue = this.provider.load().toString();
        boolean bl = stateFlag = this.oldValue == null == this.combo.getEnabled();
        if (stateFlag) {
            this.combo.setEnabled(this.oldValue != null);
        }
        if (this.provider.isReadOnly()) {
            this.combo.setEnabled(false);
        }
        int n = sindex = values == null ? Arrays.asList(items).indexOf(this.oldValue) : Arrays.asList(values).indexOf(this.oldValue);
        if (this.provider.assertProperty() && sindex < 0) {
            if (this.oldValue != null && this.oldValue.length() > 0) {
                this.combo.setText(this.oldValue);
                return;
            }
            if (this.combo.getItemCount() > 0) {
                this.combo.select(0);
                return;
            }
        }
        this.combo.select(sindex);
    }

    public int getStyle() {
        return this.style;
    }

    public void addStyle(int style) {
        this.style |= style;
    }

    public void save(Object obj) throws SemanticException {
        this.provider.save(obj);
    }

    public void setDescriptorProvider(IDescriptorProvider provider) {
        super.setDescriptorProvider(provider);
        if (provider instanceof ChoicePropertyDescriptorProvider) {
            this.provider = (ChoicePropertyDescriptorProvider)provider;
        }
    }

    public void setHidden(boolean isHidden) {
        WidgetUtil.setExcludeGridData((Control)this.combo, (boolean)isHidden);
    }

    public void setVisible(boolean isVisible) {
        this.combo.setVisible(isVisible);
    }

    public void setInput(Object input) {
        super.setInput(input);
        this.getDescriptorProvider().setInput(input);
    }
}

