/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem.ui.views.provider;

import java.util.List;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.BaseSampleData;
import org.eclipse.birt.chart.model.data.DataFactory;
import org.eclipse.birt.chart.model.data.OrthogonalSampleData;
import org.eclipse.birt.chart.model.data.Query;
import org.eclipse.birt.chart.model.data.SampleData;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.impl.QueryImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.impl.ChartWithAxesImpl;
import org.eclipse.birt.chart.model.type.impl.BarSeriesImpl;
import org.eclipse.birt.chart.reportitem.ChartReportItemImpl;
import org.eclipse.birt.chart.reportitem.ChartReportItemUtil;
import org.eclipse.birt.chart.reportitem.ChartXTabUtil;
import org.eclipse.birt.chart.reportitem.ui.ChartInXTabStatusManager;
import org.eclipse.birt.chart.reportitem.ui.ChartXTabUIUtil;
import org.eclipse.birt.chart.reportitem.ui.i18n.Messages;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.item.crosstab.core.de.AggregationCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.MeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.ui.extension.AggregationCellViewAdapter;
import org.eclipse.birt.report.item.crosstab.ui.extension.SwitchCellInfo;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.olap.LevelHandle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class ChartAggregationCellViewProvider
extends AggregationCellViewAdapter {
    public String getViewName() {
        return "Chart";
    }

    public String getViewDisplayName() {
        return Messages.getString("ChartAggregationCellViewProvider.Chart.DisplayName");
    }

    public boolean matchView(AggregationCellHandle cell) {
        ExtendedItemHandle handle = this.getChartHandle((CrosstabCellHandle)cell);
        if (handle != null) {
            return ChartXTabUtil.isPlotChart((DesignElementHandle)handle);
        }
        return false;
    }

    public void switchView(SwitchCellInfo info) {
        AggregationCellHandle cell = info.getAggregationCell();
        try {
            ChartWithAxes cm = this.createDefaultChart(info);
            Object content = ChartXTabUtil.getFirstContent((CrosstabCellHandle)cell);
            if (content instanceof DesignElementHandle) {
                ((DesignElementHandle)content).dropAndClear();
            }
            ExtendedItemHandle chartHandle = ChartXTabUIUtil.createChartHandle(cell.getModelHandle(), "plotChart", null);
            ChartReportItemImpl reportItem = (ChartReportItemImpl)chartHandle.getReportItem();
            reportItem.setModel((Chart)cm);
            cell.addContent((DesignElementHandle)chartHandle, 0);
            ChartXTabUIUtil.updateXTabDirection(cell.getCrosstab(), cm.isTransposed());
            ChartXTabUIUtil.addAxisChartInXTab(cell, cm, chartHandle, info.isNew());
            ChartInXTabStatusManager.updateGrandItemStatus(cell);
        }
        catch (BirtException e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public void restoreView(AggregationCellHandle cell) {
        try {
            if (((MeasureViewHandle)cell.getContainer()).getAggregationCount() > 1) {
                return;
            }
            ExtendedItemHandle chartHandle = this.getChartHandle((CrosstabCellHandle)cell);
            Chart cm = ChartReportItemUtil.getChartFromHandle((ExtendedItemHandle)chartHandle);
            if (ChartXTabUtil.isAxisChart((DesignElementHandle)chartHandle)) {
                Axis yAxis = (Axis)((Axis)((ChartWithAxes)cm).getAxes().get(0)).getAssociatedAxes().get(0);
                yAxis.getLineAttributes().setVisible(false);
                yAxis.getLabel().setVisible(false);
                yAxis.getMajorGrid().getTickAttributes().setVisible(false);
                return;
            }
            CrosstabCellHandle levelCell = ChartXTabUtil.getInnermostLevelCell((CrosstabReportItemHandle)cell.getCrosstab(), (int)0);
            if (levelCell != null) {
                cell.getCrosstab().setRowHeight(levelCell, null);
            }
            if ((levelCell = ChartXTabUtil.getInnermostLevelCell((CrosstabReportItemHandle)cell.getCrosstab(), (int)1)) != null) {
                cell.getCrosstab().setColumnWidth(levelCell, null);
            }
            ChartXTabUIUtil.removeAxisChartInXTab(cell, ChartXTabUIUtil.isTransposedChartWithAxes(cm), true);
        }
        catch (BirtException e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    private ChartWithAxes createDefaultChart(SwitchCellInfo info) {
        DataItemHandle dataItemHandle;
        Object content;
        AggregationCellHandle cell = info.getAggregationCell();
        boolean bDateTypeMeasure = false;
        if (info.getMeasureInfo() != null) {
            String dataType = info.getCrosstab().getCube().getMeasure(info.getMeasureInfo().getMeasureName()).getDataType();
            bDateTypeMeasure = "date".equals(dataType) || "date-time".equals(dataType);
        }
        ChartWithAxes cm = ChartWithAxesImpl.create();
        cm.setType("Bar Chart");
        cm.setSubType("Side-by-side");
        cm.setUnits("Points");
        cm.setUnitSpacing(50.0);
        cm.getLegend().setVisible(false);
        cm.getTitle().setVisible(false);
        String exprMeasure = ChartXTabUtil.generateComputedColumnName((AggregationCellHandle)cell);
        String exprCategory = null;
        if (this.checkTransposed(cell)) {
            cm.setTransposed(true);
            content = ChartXTabUtil.getFirstContent((CrosstabCellHandle)ChartXTabUtil.getInnermostLevelCell((CrosstabReportItemHandle)cell.getCrosstab(), (int)0));
            if (content instanceof DataItemHandle) {
                dataItemHandle = (DataItemHandle)content;
                exprCategory = dataItemHandle.getResultSetColumn();
            }
        } else {
            content = ChartXTabUtil.getFirstContent((CrosstabCellHandle)ChartXTabUtil.getInnermostLevelCell((CrosstabReportItemHandle)cell.getCrosstab(), (int)1));
            if (content instanceof DataItemHandle) {
                dataItemHandle = (DataItemHandle)content;
                exprCategory = dataItemHandle.getResultSetColumn();
            }
        }
        Axis xAxis = cm.getBaseAxes()[0];
        SeriesDefinition sdBase = SeriesDefinitionImpl.create();
        sdBase.getSeriesPalette().shift(0);
        Series series = SeriesImpl.create();
        sdBase.getSeries().add((Object)series);
        xAxis.setCategoryAxis(true);
        xAxis.getSeriesDefinitions().add((Object)sdBase);
        if (exprCategory != null) {
            Query query = QueryImpl.create((String)ExpressionUtil.createJSDataExpression((String)exprCategory));
            series.getDataDefinition().add((Object)query);
        }
        Axis yAxis = cm.getOrthogonalAxes(xAxis, true)[0];
        SeriesDefinition sdOrth = SeriesDefinitionImpl.create();
        sdOrth.getSeriesPalette().shift(0);
        series = BarSeriesImpl.create();
        sdOrth.getSeries().add((Object)series);
        yAxis.getSeriesDefinitions().add((Object)sdOrth);
        if (bDateTypeMeasure) {
            yAxis.setType(AxisType.DATE_TIME_LITERAL);
        }
        if (exprMeasure != null) {
            Query query = QueryImpl.create((String)ExpressionUtil.createJSDataExpression((String)exprMeasure));
            series.getDataDefinition().add((Object)query);
        }
        SampleData sampleData = DataFactory.eINSTANCE.createSampleData();
        sampleData.getBaseSampleData().clear();
        sampleData.getOrthogonalSampleData().clear();
        BaseSampleData sampleDataBase = DataFactory.eINSTANCE.createBaseSampleData();
        sampleDataBase.setDataSetRepresentation(ChartUtil.getNewSampleData((AxisType)xAxis.getType(), (int)0));
        sampleData.getBaseSampleData().add((Object)sampleDataBase);
        OrthogonalSampleData sampleDataOrth = DataFactory.eINSTANCE.createOrthogonalSampleData();
        sampleDataOrth.setDataSetRepresentation(ChartUtil.getNewSampleData((AxisType)yAxis.getType(), (int)0));
        sampleDataOrth.setSeriesDefinitionIndex(0);
        sampleData.getOrthogonalSampleData().add((Object)sampleDataOrth);
        cm.setSampleData(sampleData);
        return cm;
    }

    private void updateChartQueries(ChartWithAxes cm, AggregationCellHandle cell) {
        DataItemHandle dataItemHandle;
        Object content;
        String exprMeasure = ChartXTabUtil.generateComputedColumnName((AggregationCellHandle)cell);
        String exprCategory = null;
        if (cm.isTransposed()) {
            content = ChartXTabUtil.getFirstContent((CrosstabCellHandle)ChartXTabUtil.getInnermostLevelCell((CrosstabReportItemHandle)cell.getCrosstab(), (int)0));
            if (content instanceof DataItemHandle) {
                dataItemHandle = (DataItemHandle)content;
                exprCategory = dataItemHandle.getResultSetColumn();
            }
        } else {
            content = ChartXTabUtil.getFirstContent((CrosstabCellHandle)ChartXTabUtil.getInnermostLevelCell((CrosstabReportItemHandle)cell.getCrosstab(), (int)1));
            if (content instanceof DataItemHandle) {
                dataItemHandle = (DataItemHandle)content;
                exprCategory = dataItemHandle.getResultSetColumn();
            }
        }
        if (exprCategory != null) {
            SeriesDefinition sdCategory = (SeriesDefinition)cm.getBaseAxes()[0].getSeriesDefinitions().get(0);
            Query queryCategory = (Query)sdCategory.getDesignTimeSeries().getDataDefinition().get(0);
            queryCategory.setDefinition(ExpressionUtil.createJSDataExpression((String)exprCategory));
        }
        if (exprMeasure != null) {
            SeriesDefinition sdValue = (SeriesDefinition)cm.getOrthogonalAxes(cm.getBaseAxes()[0], true)[0].getSeriesDefinitions().get(0);
            Query queryValue = (Query)sdValue.getDesignTimeSeries().getDataDefinition().get(0);
            queryValue.setDefinition(ExpressionUtil.createJSDataExpression((String)exprMeasure));
        }
    }

    private ExtendedItemHandle getChartHandle(CrosstabCellHandle cell) {
        Object content = ChartXTabUtil.getFirstContent((CrosstabCellHandle)cell);
        if (ChartXTabUtil.isChartHandle((Object)content)) {
            return (ExtendedItemHandle)content;
        }
        return null;
    }

    private boolean checkTransposed(AggregationCellHandle cell) {
        if (ChartXTabUtil.isDetailCell((AggregationCellHandle)cell)) {
            if (cell.getAggregationOnColumn() == null) {
                return true;
            }
            if (cell.getAggregationOnRow() == null) {
                return false;
            }
            MeasureViewHandle mv = (MeasureViewHandle)cell.getContainer();
            int i = 0;
            while (i < mv.getAggregationCount()) {
                Object content;
                AggregationCellHandle otherCell = mv.getAggregationCell(i);
                if (cell.getDimensionView(0) == otherCell.getDimensionView(0) && cell.getLevelView(0) == otherCell.getLevelView(0) && ChartXTabUtil.isPlotChart((DesignElementHandle)((DesignElementHandle)(content = ChartXTabUtil.getFirstContent((CrosstabCellHandle)otherCell))))) {
                    return true;
                }
                ++i;
            }
            Object content = ChartXTabUtil.getFirstContent((CrosstabCellHandle)cell);
            if (ChartXTabUtil.isPlotChart((DesignElementHandle)((DesignElementHandle)content))) {
                return ((ChartWithAxes)ChartXTabUtil.getChartFromHandle((ExtendedItemHandle)((ExtendedItemHandle)content))).isTransposed();
            }
        }
        if (ChartXTabUtil.isAggregationCell((AggregationCellHandle)cell)) {
            LevelHandle levelRow = cell.getAggregationOnRow();
            LevelHandle levelColumn = cell.getAggregationOnColumn();
            if (levelRow != null && levelColumn == null) {
                return true;
            }
            if (levelRow == null && levelColumn != null) {
                return false;
            }
            if (levelRow != null && levelColumn != null) {
                return this.isInSubtotal(cell, 1);
            }
            return false;
        }
        List<ExtendedItemHandle> chartInOtherMeasure = ChartXTabUIUtil.findChartInOtherMeasures(cell, true);
        if (!chartInOtherMeasure.isEmpty()) {
            return ((ChartWithAxes)ChartXTabUtil.getChartFromHandle((ExtendedItemHandle)chartInOtherMeasure.get(0))).isTransposed();
        }
        return cell.getCrosstab().getMeasureDirection().equals("horizontal");
    }

    private boolean isInSubtotal(AggregationCellHandle cell, int axisType) {
        int levelCount = ChartXTabUtil.getLevelCount((CrosstabReportItemHandle)cell.getCrosstab(), (int)axisType);
        if (levelCount > 1) {
            LevelViewHandle currentLevel = cell.getLevelView(axisType);
            int i = 0;
            while (i < levelCount) {
                LevelViewHandle level = ChartXTabUtil.getLevel((CrosstabReportItemHandle)cell.getCrosstab(), (int)axisType, (int)i);
                if (level == currentLevel) {
                    return i < levelCount - 1;
                }
                ++i;
            }
        }
        return false;
    }

    public void updateView(AggregationCellHandle cell, int type) {
        Object contentItem = ChartXTabUtil.getFirstContent((CrosstabCellHandle)cell);
        if (contentItem instanceof ExtendedItemHandle) {
            ExtendedItemHandle handle = (ExtendedItemHandle)contentItem;
            try {
                if (ChartXTabUtil.isPlotChart((DesignElementHandle)handle)) {
                    ChartWithAxes cm;
                    ChartReportItemImpl reportItem = (ChartReportItemImpl)handle.getReportItem();
                    ChartWithAxes cmNew = cm = (ChartWithAxes)reportItem.getProperty("chart.instance");
                    if (cm == null) {
                        return;
                    }
                    cmNew = (ChartWithAxes)EcoreUtil.copy((EObject)cm);
                    if (type == 1 && cell.getAggregationOnColumn() != null && cell.getAggregationOnRow() != null && !ChartXTabUtil.isAggregationCell((AggregationCellHandle)cell)) {
                        cmNew.setTransposed(cell.getCrosstab().getMeasureDirection().equals("horizontal"));
                    }
                    this.updateChartQueries(cmNew, cell);
                    reportItem.executeSetModelCommand(handle, (Chart)cm, (Chart)cmNew);
                    if (cmNew.isTransposed()) {
                        cell.setSpanOverOnRow(cell.getAggregationOnRow());
                        cell.setSpanOverOnColumn(null);
                    } else {
                        cell.setSpanOverOnColumn(cell.getAggregationOnColumn());
                        cell.setSpanOverOnRow(null);
                    }
                    if (type == 1) {
                        ChartXTabUIUtil.updateXTabForAxis(cell, handle, cm.isTransposed(), cmNew);
                    } else {
                        ChartXTabUIUtil.updateAxisChart(cell, cmNew, handle);
                        ChartXTabUIUtil.updateXTabDirection(cell.getCrosstab(), cmNew.isTransposed());
                    }
                    ChartInXTabStatusManager.updateGrandItemStatus(cell);
                } else if (ChartXTabUtil.isAxisChart((DesignElementHandle)handle)) {
                    ExtendedItemHandle hostChartHandle = (ExtendedItemHandle)handle.getElementProperty("hostChart");
                    if (hostChartHandle == null) {
                        handle.dropAndClear();
                        return;
                    }
                    if (type != 1) {
                        ChartReportItemImpl reportItem = (ChartReportItemImpl)handle.getReportItem();
                        ChartWithAxes cm = (ChartWithAxes)reportItem.getProperty("chart.instance");
                        ChartXTabUIUtil.updateXTabDirection(cell.getCrosstab(), cm.isTransposed());
                    }
                }
            }
            catch (BirtException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
    }

    public boolean canSwitch(SwitchCellInfo info) {
        AggregationCellHandle cell = info.getAggregationCell();
        if (cell != null && cell.getAggregationOnRow() == null && cell.getAggregationOnColumn() == null) {
            return false;
        }
        CrosstabReportItemHandle xtab = info.getCrosstab();
        if (!(info.getType() != 1 && info.getType() != 2 || xtab.getDimensionCount(0) != 0 && xtab.getDimensionCount(1) != 0)) {
            return false;
        }
        if (info.getCrosstab().getCube() != null && info.getMeasureInfo() != null) {
            String dataType = info.getCrosstab().getCube().getMeasure(info.getMeasureInfo().getMeasureName()).getDataType();
            return !"string".equals(dataType);
        }
        return true;
    }
}

