/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.lib.views.outline.dnd;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.designer.internal.lib.commands.SetCurrentEditModelCommand;
import org.eclipse.birt.report.designer.internal.lib.editparts.LibraryReportDesignEditPart;
import org.eclipse.birt.report.designer.internal.ui.command.CommandUtils;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.extensions.GuiExtensionManager;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools.AbstractToolHandleExtends;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools.ReportCreationTool;
import org.eclipse.birt.report.designer.internal.ui.extension.ExtendedElementUIPoint;
import org.eclipse.birt.report.designer.internal.ui.extension.ExtensionPointManager;
import org.eclipse.birt.report.designer.internal.ui.extension.experimental.EditpartExtensionManager;
import org.eclipse.birt.report.designer.internal.ui.extension.experimental.PaletteEntryExtension;
import org.eclipse.birt.report.designer.internal.ui.palette.BasePaletteFactory;
import org.eclipse.birt.report.designer.internal.ui.palette.ReportElementFactory;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.outline.dnd.DesignerDropListener;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.jface.viewers.TreeViewer;

public class LibraryDropListener
extends DesignerDropListener {
    private static List supportList = new ArrayList();

    static {
        supportList.add("Label");
        supportList.add("Text");
        supportList.add("Data");
        supportList.add("Grid");
        supportList.add("Table");
        supportList.add("List");
        supportList.add("Image");
        supportList.add("TextData");
        List exts = ExtensionPointManager.getInstance().getExtendedElementPoints();
        if (exts != null) {
            for (ExtendedElementUIPoint point : exts) {
                if (point == null) continue;
                supportList.add(GuiExtensionManager.getExtendedPalletTemplateName((ExtendedElementUIPoint)point));
            }
        }
        PaletteEntryExtension[] paletteEntries = EditpartExtensionManager.getPaletteEntries();
        int i = 0;
        while (i < paletteEntries.length) {
            supportList.add("Extended" + paletteEntries[i].getItemName());
            ++i;
        }
    }

    public LibraryDropListener(TreeViewer viewer) {
        super(viewer);
    }

    protected boolean validateTarget(Object target, Object transfer) {
        boolean retValue = super.validateTarget(target, transfer);
        if (!retValue) {
            retValue = this.isSupportPalletType(target, transfer) && this.getCurrentLocation() == 3;
        }
        return retValue;
    }

    private boolean isSupportPalletType(Object target, Object transfer) {
        boolean bool = false;
        if (target instanceof SlotHandle) {
            bool = ((SlotHandle)target).getSlotID() == 5;
        } else if (target instanceof LibraryHandle) {
            bool = true;
        }
        return bool & supportList.indexOf(transfer) >= 0;
    }

    protected boolean moveData(Object transfer, Object target) {
        PaletteEntryExtension[] paletteEntries = EditpartExtensionManager.getPaletteEntries();
        int i = 0;
        while (i < paletteEntries.length) {
            if (("Extended" + paletteEntries[i].getItemName()).equals(transfer)) {
                CommandUtils.setVariable((String)"targetEditPart", (Object)this.getLibrartReportEditPart());
                try {
                    Object newObj = paletteEntries[i].executeCreate();
                    SetCurrentEditModelCommand command = new SetCurrentEditModelCommand(newObj, "create element");
                    command.execute();
                }
                catch (Exception e) {
                    ExceptionHandler.handle((Throwable)e);
                    return false;
                }
                return true;
            }
            ++i;
        }
        if (this.isSupportPalletType(target, transfer)) {
            AbstractToolHandleExtends pre = BasePaletteFactory.getAbstractToolHandleExtendsFromPaletteName((Object)transfer);
            ReportCreationTool tool = new ReportCreationTool((CreationFactory)new ReportElementFactory(transfer), pre);
            EditDomain domain = UIUtil.getLayoutEditPartViewer().getEditDomain();
            tool.setEditDomain(domain);
            tool.setViewer(UIUtil.getLayoutEditPartViewer());
            tool.getTargetRequest().getExtendedData().put("direct create item", new Boolean(true));
            tool.performCreation(this.getLibrartReportEditPart());
            SetCurrentEditModelCommand command = new SetCurrentEditModelCommand(tool.getNewObjectFromRequest(), "create element");
            command.execute();
            return true;
        }
        return super.moveData(transfer, target);
    }

    private EditPart getLibrartReportEditPart() {
        EditPart retValue = UIUtil.getCurrentEditPart();
        while (retValue != null && !(retValue instanceof LibraryReportDesignEditPart)) {
            retValue = retValue.getParent();
        }
        return retValue;
    }
}

