/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.data.dte;

import java.util.logging.Level;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBasePreparedQuery;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IBaseQueryResults;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.olap.api.ICubeQueryResults;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.data.adapter.api.DataSessionContext;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.data.IDataEngine;
import org.eclipse.birt.report.engine.data.dte.AbstractDataEngine;
import org.eclipse.birt.report.engine.data.dte.CubeResultSet;
import org.eclipse.birt.report.engine.data.dte.QueryResultSet;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.extension.IBaseResultSet;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.mozilla.javascript.Scriptable;

public class DteDataEngine
extends AbstractDataEngine {
    public DteDataEngine(ExecutionContext context) {
        super(context);
        try {
            DataSessionContext dteSessionContext = new DataSessionContext(3, (ModuleHandle)context.getDesign(), context.getScriptContext(), context.getApplicationClassLoader());
            DataEngineContext dteEngineContext = dteSessionContext.getDataEngineContext();
            dteEngineContext.setLocale(context.getLocale());
            String tempDir = this.getTempDir(context);
            if (tempDir != null) {
                dteEngineContext.setTmpdir(tempDir);
            }
            this.dteSession = DataRequestSession.newSession((DataSessionContext)dteSessionContext);
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "can't create the DTE data engine", ex);
        }
    }

    protected DteDataEngine(ExecutionContext context, Object obj) {
        super(context);
    }

    protected IBaseResultSet doExecuteQuery(IBaseResultSet parentResultSet, IQueryDefinition query, boolean useCache) throws BirtException {
        IPreparedQuery pQuery = (IPreparedQuery)this.queryMap.get(query);
        if (pQuery == null) {
            return null;
        }
        Scriptable scope = this.context.getSharedScope();
        IBaseQueryResults dteResults = null;
        if (useCache) {
            dteResults = this.getCachedQueryResult((IBaseQueryDefinition)query, parentResultSet);
        }
        if (dteResults == null) {
            dteResults = parentResultSet == null ? this.dteSession.execute((IBasePreparedQuery)pQuery, null, scope) : this.dteSession.execute((IBasePreparedQuery)pQuery, parentResultSet.getQueryResults(), scope);
            this.putCachedQueryResult((IBaseQueryDefinition)query, dteResults.getID());
        }
        if (parentResultSet == null) {
            return new QueryResultSet(this, this.context, query, (IQueryResults)dteResults);
        }
        return new QueryResultSet(this, this.context, parentResultSet, query, (IQueryResults)dteResults);
    }

    protected IBaseResultSet doExecuteCube(IBaseResultSet parentResultSet, ICubeQueryDefinition query, boolean useCache) throws BirtException {
        CubeResultSet resultSet;
        ICubeQueryResults dteResults;
        if (useCache) {
            String rsetId = String.valueOf(this.cachedQueryToResults.get(query));
            query.setQueryResultsID(rsetId);
        } else {
            query.setQueryResultsID(null);
        }
        IBasePreparedQuery pQuery = (IBasePreparedQuery)this.queryMap.get(query);
        if (pQuery == null) {
            throw new EngineException("Error.PreparedQueryNotFoundError", query);
        }
        Scriptable scope = this.context.getSharedScope();
        if (parentResultSet == null) {
            dteResults = (ICubeQueryResults)this.dteSession.execute(pQuery, null, scope);
            resultSet = new CubeResultSet(this, this.context, query, dteResults);
        } else {
            dteResults = (ICubeQueryResults)this.dteSession.execute(pQuery, parentResultSet.getQueryResults(), scope);
            resultSet = new CubeResultSet((IDataEngine)this, this.context, parentResultSet, query, dteResults);
        }
        if (query.cacheQueryResults()) {
            this.cachedQueryToResults.put(query, dteResults.getID());
        }
        return resultSet;
    }
}

