/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.data.dte.DocumentDataSource;
import org.eclipse.birt.report.engine.executor.ExecutorManager;
import org.eclipse.birt.report.engine.executor.ReportItemExecutor;
import org.eclipse.birt.report.engine.executor.ReportletQuery;
import org.eclipse.birt.report.engine.extension.IBaseResultSet;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;

public class ReportletItemExecutor
extends ReportItemExecutor {
    boolean hasNext = true;
    ReportletQuery reportletQuery;

    protected ReportletItemExecutor(ExecutorManager manager) {
        super(manager, 18);
        DocumentDataSource ds = this.context.getDataSource();
        InstanceID instanceID2 = null;
        if (ds != null) {
            instanceID2 = ds.getInstanceID();
        }
        this.reportletQuery = new ReportletQuery(this.context, instanceID2);
    }

    public void close() {
        try {
            this.reportletQuery.closeReportletQueries();
        }
        catch (EngineException ex) {
            this.context.addException(ex);
        }
        super.close();
    }

    public IBaseResultSet[] getQueryResults() {
        return this.reportletQuery.getQueryResults();
    }

    public IContent execute() {
        try {
            this.reportletQuery.openReportletQueries();
        }
        catch (BirtException ex) {
            this.context.addException(ex);
        }
        return null;
    }

    public boolean hasNextChild() {
        return this.hasNext;
    }

    public IReportItemExecutor getNextChild() {
        if (this.hasNext) {
            this.hasNext = false;
            DocumentDataSource ds = this.context.getDataSource();
            long designId = ds.getElementID();
            Report report = this.context.getReport();
            ReportItemDesign design = (ReportItemDesign)report.getReportItemByID(designId);
            return this.manager.createExecutor(this, design);
        }
        return null;
    }
}

