/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.executor.dom;

import java.util.Iterator;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.extension.ReportItemExecutorBase;
import org.eclipse.birt.report.engine.internal.executor.dom.DOMReportItemExecutorManager;

public class DOMReportItemExecutor
extends ReportItemExecutorBase {
    IContent content;
    DOMReportItemExecutorManager manager;
    boolean cloneContent;
    Iterator childIterator;

    DOMReportItemExecutor(DOMReportItemExecutorManager manager) {
        this.manager = manager;
        this.cloneContent = manager.cloneContent;
    }

    public DOMReportItemExecutor(IContent content, boolean cloneContent) {
        this.content = content;
        this.cloneContent = cloneContent;
        this.manager = new DOMReportItemExecutorManager(cloneContent);
    }

    public DOMReportItemExecutor(IContent content) {
        this(content, false);
    }

    void setContent(IContent content) {
        this.content = content;
    }

    public void close() {
        this.manager.releaseExecutor(this);
    }

    public IContent execute() {
        if (this.content == null) {
            return null;
        }
        this.childIterator = this.content.getChildren().iterator();
        if (this.cloneContent) {
            this.content = this.content.cloneContent(false);
            IReportItemExecutor parent = this.getParent();
            if (parent != null) {
                this.content.setParent(parent.getContent());
            }
        }
        return this.content;
    }

    public IReportItemExecutor getNextChild() {
        if (this.childIterator != null && this.childIterator.hasNext()) {
            IContent child = (IContent)this.childIterator.next();
            return this.manager.createExecutor(this, child);
        }
        return null;
    }

    public boolean hasNextChild() {
        if (this.childIterator == null) {
            return false;
        }
        return this.childIterator.hasNext();
    }
}

