/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.ir;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.birt.core.template.TemplateParser;
import org.eclipse.birt.core.template.TextTemplate;
import org.eclipse.birt.report.engine.ir.IReportItemVisitor;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;

public class TextItemDesign
extends ReportItemDesign {
    public static final String AUTO_TEXT = "auto";
    public static final String PLAIN_TEXT = "plain";
    public static final String HTML_TEXT = "html";
    public static final String RTF_TEXT = "rtf";
    protected String textType;
    protected String textKey;
    protected String text;
    protected HashMap exprs = null;

    public HashMap getExpressions() {
        if (this.text == null) {
            return null;
        }
        if (this.exprs != null) {
            return this.exprs;
        }
        if (HTML_TEXT.equals(this.textType) || AUTO_TEXT.equals(this.textType) && this.startsWithIgnoreCase(this.text, "<html>")) {
            this.exprs = new HashMap();
            TextTemplate template = new TemplateParser().parse(this.text);
            if (template != null && template.getNodes() != null) {
                Iterator itor = template.getNodes().iterator();
                String expression = null;
                while (itor.hasNext()) {
                    Object obj = itor.next();
                    if (obj instanceof TextTemplate.ValueNode) {
                        expression = ((TextTemplate.ValueNode)obj).getValue();
                    } else if (obj instanceof TextTemplate.ImageNode) {
                        expression = ((TextTemplate.ImageNode)obj).getExpr();
                    }
                    if (expression == null || expression.trim().equals("")) continue;
                    this.exprs.put(expression, expression);
                    expression = null;
                }
            }
        }
        return this.exprs;
    }

    public boolean startsWithIgnoreCase(String original, String pattern) {
        int length = pattern.length();
        if (original == null || original.length() < length) {
            return false;
        }
        return original.substring(0, length).equalsIgnoreCase(pattern);
    }

    public void setText(String textKey, String text) {
        this.textKey = textKey;
        this.text = text;
    }

    public String getTextKey() {
        return this.textKey;
    }

    public String getText() {
        return this.text;
    }

    public Object accept(IReportItemVisitor visitor, Object value) {
        return visitor.visitTextItem(this, value);
    }

    public String getTextType() {
        return this.textType;
    }

    public void setTextType(String textType) {
        this.textType = textType;
    }
}

