/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.area.impl;

import com.ibm.icu.text.Bidi;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.layout.area.IAreaVisitor;
import org.eclipse.birt.report.engine.layout.area.ITextArea;
import org.eclipse.birt.report.engine.layout.area.impl.AbstractArea;
import org.eclipse.birt.report.engine.layout.emitter.EmitterUtil;
import org.eclipse.birt.report.engine.layout.pdf.font.FontInfo;

public class TextArea
extends AbstractArea
implements ITextArea {
    protected String text;
    protected FontInfo fi;
    private int offset;
    private ITextContent textContent;
    private int runLevel;
    private boolean lineBreak;
    private boolean blankLine = false;
    private int textLength;
    private int maxWidth;

    public TextArea(ITextContent textContent, String text, FontInfo fi) {
        super(textContent);
        this.textContent = textContent;
        this.text = text;
        this.offset = 0;
        this.textLength = text.length();
        this.fi = fi;
        this.height = (int)(fi.getWordHeight() * 1000.0f);
        this.baseLine = this.fi.getBaseline();
        this.removePadding();
        this.removeBorder();
        this.removeMargin();
        this.hasBoxProperty = false;
    }

    public TextArea(ITextContent textContent, FontInfo fi, boolean blankLine) {
        super(textContent);
        this.textContent = textContent;
        this.fi = fi;
        this.height = (int)(fi.getWordHeight() * 1000.0f);
        this.baseLine = this.fi.getBaseline();
        if (blankLine) {
            this.lineBreak = true;
            this.blankLine = true;
        } else {
            this.offset = 0;
            this.textLength = textContent.getText().length();
        }
        this.removePadding();
        this.removeBorder();
        this.removeMargin();
        this.hasBoxProperty = false;
    }

    public TextArea(ITextContent textContent, IStyle areaStyle, int offset, int baseLevel, int runLevel, FontInfo fontInfo) {
        super(textContent, areaStyle);
        this.textContent = textContent;
        this.fi = fontInfo;
        this.height = (int)(this.fi.getWordHeight() * 1000.0f);
        this.baseLine = this.fi.getBaseline();
        this.offset = offset;
        this.runLevel = runLevel;
        this.lineBreak = false;
    }

    public TextArea(ITextContent textContent, int offset, int baseLevel, int runLevel, FontInfo fontInfo) {
        super(textContent);
        this.textContent = textContent;
        this.fi = fontInfo;
        this.height = (int)(this.fi.getWordHeight() * 1000.0f);
        this.baseLine = this.fi.getBaseline();
        this.offset = offset;
        this.runLevel = runLevel;
        this.lineBreak = false;
        this.removePadding();
        this.removeBorder();
        this.removeMargin();
    }

    public boolean lineBreak() {
        return this.lineBreak;
    }

    public boolean isEmpty() {
        return this.textLength == 0;
    }

    public void addWord(int textLength, float wordWidth) {
        this.textLength += textLength;
        this.width = (int)((float)this.width + wordWidth);
    }

    public void addWordSpacing(int wordSpacing) {
        this.width += wordSpacing;
    }

    public boolean hasSpace(int width) {
        return this.maxWidth - this.width > width;
    }

    public void setStyle(IStyle style) {
        this.style = style;
    }

    private void calculateText() {
        this.text = this.blankLine ? "" : this.textContent.getText().substring(this.offset, this.offset + this.textLength);
    }

    public String getLogicalOrderText() {
        this.calculateText();
        return this.text;
    }

    public String getText() {
        this.calculateText();
        if ((this.runLevel & 1) == 0) {
            return this.text;
        }
        return this.flip(this.text);
    }

    private String flip(String text) {
        return Bidi.writeReverse((String)text, (int)18);
    }

    public int getRunLevel() {
        return this.runLevel;
    }

    public FontInfo getFontInfo() {
        return this.fi;
    }

    public void accept(IAreaVisitor visitor) {
        visitor.visitText(this);
    }

    public int getTextLength() {
        return this.textLength;
    }

    public void setTextLength(int textLength) {
        this.textLength = textLength;
    }

    public boolean isLineBreak() {
        return this.lineBreak;
    }

    public void setLineBreak(boolean lineBreak) {
        this.lineBreak = lineBreak;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public void setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
    }

    public int getWidth() {
        int fontStyle = this.fi.getFontStyle();
        if (this.fi.getSimulation() && (2 == fontStyle || 3 == fontStyle)) {
            this.width = (int)((float)this.width + (float)this.height * EmitterUtil.getItalicHorizontalCoefficient());
        }
        return this.width;
    }
}

