/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.emitter;

import java.util.HashMap;
import java.util.Stack;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IContainerContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IElement;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.IListBandContent;
import org.eclipse.birt.report.engine.content.IListGroupContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.ITableBandContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.ITableGroupContent;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.emitter.IEmitterServices;
import org.eclipse.birt.report.engine.executor.IReportExecutor;
import org.eclipse.birt.report.engine.layout.pdf.emitter.LayoutEmitterAdapter;
import org.eclipse.birt.report.engine.layout.pdf.emitter.LayoutEngineContext;
import org.eclipse.birt.report.engine.layout.pdf.emitter.PDFLayoutEmitter;

public class WrappedPDFLayoutEmitter
extends LayoutEmitterAdapter
implements IContentEmitter {
    private PDFLayoutEmitter layoutEmitter;
    private int repeatedHeaderLevel = 0;
    private Stack parentContents = new Stack();
    private HashMap cachedGroupHeaders = new HashMap();
    private HashMap cachedTableHeaders = new HashMap();

    public WrappedPDFLayoutEmitter(IReportExecutor executor, IContentEmitter emitter, LayoutEngineContext context) {
        this.layoutEmitter = new PDFLayoutEmitter(executor, emitter, context);
        this.layoutEmitter.context.setCachedHeaderMap(this.cachedTableHeaders, this.cachedGroupHeaders);
    }

    public void initialize(IEmitterServices service) {
        this.layoutEmitter.initialize(service);
    }

    public String getOutputFormat() {
        return this.layoutEmitter.getOutputFormat();
    }

    public void start(IReportContent report) {
        this.layoutEmitter.start(report);
    }

    public void end(IReportContent report) {
        this.layoutEmitter.end(report);
    }

    protected void resolveTotalPage(IContentEmitter emitter) {
        this.layoutEmitter.resolveTotalPage(emitter);
    }

    public void startContainer(IContainerContent container) {
        this.layoutEmitter.startContainer(container);
        if (this.isInHeader()) {
            this.constructClonedContent(container);
        }
    }

    public void endContainer(IContainerContent container) {
        this.layoutEmitter.endContainer(container);
        if (this.isInHeader()) {
            this.destructClonedContent();
        }
    }

    public void startContent(IContent content) {
        this.layoutEmitter.startContent(content);
        if (this.isInHeader()) {
            if (content instanceof IContainerContent) {
                this.constructClonedContent((IContainerContent)content);
            } else {
                IContainerContent pContent = (IContainerContent)this.parentContents.peek();
                pContent.getChildren().add(content);
            }
        }
    }

    public void endContent(IContent content) {
        this.layoutEmitter.endContent(content);
        if (this.isInHeader() && content instanceof IContainerContent) {
            this.destructClonedContent();
        }
    }

    public void startTable(ITableContent table) {
        this.layoutEmitter.startTable(table);
        if (this.isInHeader()) {
            this.constructClonedContent(table);
        }
    }

    public void endTable(ITableContent table) {
        this.layoutEmitter.endTable(table);
        InstanceID tableID = table.getInstanceID();
        this.removeCachedTableHeader(tableID);
        if (this.isInHeader()) {
            this.destructClonedContent();
        }
    }

    public void startListBand(IListBandContent listBand) {
        this.layoutEmitter.startListBand(listBand);
        if (this.isInHeader()) {
            this.constructClonedContent(listBand);
        }
    }

    public void endListBand(IListBandContent listBand) {
        this.layoutEmitter.endListBand(listBand);
        if (this.isInHeader()) {
            this.destructClonedContent();
        }
    }

    public void startListGroup(IListGroupContent listGroup) {
        this.layoutEmitter.startListGroup(listGroup);
        if (this.isInHeader()) {
            this.constructClonedContent(listGroup);
        }
    }

    public void endListGroup(IListBandContent listGroup) {
        this.layoutEmitter.endListBand(listGroup);
        if (this.isInHeader()) {
            this.destructClonedContent();
        }
    }

    public void startPage(IPageContent page) {
        this.layoutEmitter.startPage(page);
    }

    public void outputPage(IPageContent page) {
        this.layoutEmitter.outputPage(page);
    }

    public void endPage(IPageContent page) {
        this.layoutEmitter.endPage(page);
    }

    public void startRow(IRowContent row) {
        this.layoutEmitter.startRow(row);
        if (this.isInHeader()) {
            this.constructClonedContent(row);
        }
    }

    public void endRow(IRowContent row) {
        this.layoutEmitter.endRow(row);
        if (this.isInHeader()) {
            this.destructClonedContent();
        }
    }

    public void startTableBand(ITableBandContent band) {
        this.layoutEmitter.startTableBand(band);
        if (band.getBandType() == 3) {
            IElement group = band.getParent();
            if (group instanceof ITableGroupContent && ((ITableGroupContent)group).isHeaderRepeat()) {
                InstanceID id = ((ITableGroupContent)group).getInstanceID();
                ++this.repeatedHeaderLevel;
                ITableBandContent clonedBand = (ITableBandContent)this.constructClonedContent(band);
                this.createCachedGroupHeader(id, clonedBand);
            }
        } else if (band.getBandType() == 1) {
            IElement table = band.getParent();
            if (table instanceof ITableContent && ((ITableContent)table).isHeaderRepeat()) {
                InstanceID tableID = ((ITableContent)table).getInstanceID();
                ++this.repeatedHeaderLevel;
                ITableBandContent clonedBand = (ITableBandContent)this.constructClonedContent(band);
                this.createCachedTableHeader(tableID, clonedBand);
            }
        } else if (this.isInHeader()) {
            this.constructClonedContent(band);
        }
    }

    public void endTableBand(ITableBandContent band) {
        this.layoutEmitter.endTableBand(band);
        if (this.isInHeader()) {
            this.destructClonedContent();
            if (band.getBandType() == 3) {
                --this.repeatedHeaderLevel;
            }
            if (band.getBandType() == 1) {
                --this.repeatedHeaderLevel;
            }
        }
    }

    public void startTableGroup(ITableGroupContent group) {
        this.layoutEmitter.startTableGroup(group);
        if (this.isInHeader()) {
            this.constructClonedContent(group);
        }
    }

    public void endTableGroup(ITableGroupContent group) {
        this.layoutEmitter.endTableGroup(group);
        this.removeCachedGroupHeader(group.getInstanceID());
        if (this.isInHeader()) {
            this.destructClonedContent();
        }
    }

    public void startCell(ICellContent cell) {
        this.layoutEmitter.startCell(cell);
        if (this.isInHeader()) {
            this.constructClonedContent(cell);
        }
    }

    public void endCell(ICellContent cell) {
        this.layoutEmitter.endCell(cell);
        if (this.isInHeader()) {
            this.destructClonedContent();
        }
    }

    public void startForeign(IForeignContent foreign) {
        this.layoutEmitter.startForeign(foreign);
        if (this.isInHeader()) {
            IContainerContent pContent = (IContainerContent)this.parentContents.peek();
            pContent.getChildren().add(foreign);
        }
    }

    private boolean isInHeader() {
        return this.repeatedHeaderLevel > 0;
    }

    private void createCachedGroupHeader(InstanceID id, ITableBandContent header) {
        this.cachedGroupHeaders.put(id, header);
    }

    private void removeCachedGroupHeader(InstanceID id) {
        this.cachedGroupHeaders.remove(id);
    }

    private void createCachedTableHeader(InstanceID id, ITableBandContent header) {
        this.cachedTableHeaders.put(id, header);
    }

    private void removeCachedTableHeader(InstanceID id) {
        this.cachedTableHeaders.remove(id);
    }

    private IContainerContent constructClonedContent(IContainerContent container) {
        if (this.parentContents.isEmpty()) {
            IContainerContent clonedContainer = (IContainerContent)container.cloneContent(false);
            clonedContainer.setParent(container.getParent());
            this.parentContents.push(clonedContainer);
            return clonedContainer;
        }
        IContainerContent pContent = (IContainerContent)this.parentContents.peek();
        IContainerContent clonedContainer = (IContainerContent)container.cloneContent(false);
        clonedContainer.setParent(container.getParent());
        pContent.getChildren().add(clonedContainer);
        this.parentContents.push(clonedContainer);
        return clonedContainer;
    }

    private void destructClonedContent() {
        if (!this.parentContents.isEmpty()) {
            this.parentContents.pop();
        }
    }
}

