/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.font;

import com.lowagie.text.pdf.BaseFont;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.layout.pdf.font.CompositeFont;
import org.eclipse.birt.report.engine.layout.pdf.font.FontInfo;
import org.eclipse.birt.report.engine.layout.pdf.font.FontMappingManager;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;
import org.w3c.dom.css.CSSValueList;

public class FontHandler {
    private String[] fontFamilies = null;
    private int fontStyle = 0;
    private float fontSize = 0.0f;
    private BaseFont bf = null;
    private boolean isFontChanged = false;
    private boolean simulation = false;
    private FontMappingManager fontManager = null;
    private Map fonts = new HashMap();

    public FontHandler(FontMappingManager fontManager, ITextContent textContent, boolean fontSubstitution) {
        this.fontManager = fontManager;
        IStyle style = textContent.getComputedStyle();
        CSSValueList families = (CSSValueList)style.getProperty(52);
        this.fontFamilies = new String[families.getLength()];
        int i = 0;
        while (i < this.fontFamilies.length) {
            this.fontFamilies[i] = families.item(i).getCssText();
            ++i;
        }
        if ("oblique".equals(style.getFontStyle()) || "italic".equals(style.getFontStyle())) {
            this.fontStyle |= 2;
        }
        if (PropertyUtil.isBoldFont(style.getProperty(46))) {
            this.fontStyle |= 1;
        }
        this.fontSize = (float)PropertyUtil.getDimensionValue(style.getProperty(3)) / 1000.0f;
        if (!fontSubstitution) {
            i = 0;
            while (i < this.fontFamilies.length) {
                String fontName = fontManager.getAliasedFont(this.fontFamilies[i]);
                this.bf = fontManager.createFont(fontName, this.fontStyle);
                if (this.bf != null) {
                    return;
                }
                ++i;
            }
            this.bf = fontManager.createFont("Times-Roman", this.fontStyle);
        }
    }

    public FontHandler(FontMappingManager fontManager, String[] fontFamilies, int fontStyle, boolean fontSubstitution) {
        this.fontManager = fontManager;
        this.fontFamilies = fontFamilies;
        this.fontStyle = fontStyle;
        this.fontSize /= 1000.0f;
        if (!fontSubstitution) {
            int i = 0;
            while (i < fontFamilies.length) {
                String fontName = fontManager.getAliasedFont(fontFamilies[i]);
                this.bf = fontManager.createFont(fontName, fontStyle);
                if (this.bf != null) {
                    return;
                }
                ++i;
            }
            this.bf = fontManager.createFont("Times-Roman", fontStyle);
        }
    }

    public FontInfo getFontInfo() {
        return new FontInfo(this.bf, this.fontSize, this.fontStyle, this.simulation);
    }

    public boolean isFontChanged() {
        return this.isFontChanged;
    }

    public boolean selectFont(char character) {
        assert (this.fontManager != null);
        BaseFont candidateFont = this.getMappedFont(character);
        assert (candidateFont != null);
        if (this.bf == candidateFont) {
            this.isFontChanged = false;
        } else {
            this.isFontChanged = true;
            this.bf = candidateFont;
            this.simulation = this.needSimulate(this.bf);
        }
        return candidateFont.charExists(character);
    }

    public BaseFont getMappedFont(char c) {
        BaseFont bf;
        String usedFont;
        int i = 0;
        while (i < this.fontFamilies.length) {
            String fontFamily = this.fontManager.getAliasedFont(this.fontFamilies[i]);
            CompositeFont cf = this.fontManager.getCompositeFont(fontFamily);
            if (cf != null) {
                BaseFont bf2;
                String usedFont2 = cf.getUsedFont(c);
                if (usedFont2 != null && (bf2 = this.createBaseFont(usedFont2)) != null) {
                    return bf2;
                }
            } else {
                BaseFont bf3 = this.createBaseFont(fontFamily);
                if (bf3 != null && bf3.charExists(c)) {
                    return bf3;
                }
            }
            ++i;
        }
        CompositeFont df = this.fontManager.getCompositeFont("all-fonts");
        if (df != null && (usedFont = df.getUsedFont(c)) != null && (bf = this.createBaseFont(usedFont)) != null) {
            return bf;
        }
        BaseFont bf4 = this.createBaseFont("Times-Roman");
        if (bf4 == null) {
            throw new NullPointerException("Failed to create Times-Roman which is not allow");
        }
        return bf4;
    }

    private BaseFont createBaseFont(String physicalFont) {
        BaseFont font = (BaseFont)this.fonts.get(physicalFont);
        if (font == null && (font = this.fontManager.createFont(physicalFont, this.fontStyle)) != null) {
            this.fonts.put(physicalFont, font);
        }
        return font;
    }

    private boolean needSimulate(BaseFont font) {
        if (this.fontStyle != 0) {
            String[][] familyNames = this.bf.getFamilyFontName();
            String[][] fullNames = this.bf.getFullFontName();
            String familyName = this.getEnglishName(familyNames);
            String fullName = this.getEnglishName(fullNames);
            return familyName.equals(fullName);
        }
        return false;
    }

    private String getEnglishName(String[][] names) {
        String tmp = null;
        int i = 0;
        while (i < names.length) {
            if ("0".equals(names[i][2])) {
                return names[i][3];
            }
            if ("1033".equals(names[i][2])) {
                tmp = names[i][3];
            }
            if ("".equals(names[i][2])) {
                tmp = names[i][3];
            }
            ++i;
        }
        return tmp;
    }
}

