/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.util;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.css.engine.value.FloatValue;
import org.eclipse.birt.report.engine.css.engine.value.ListValue;
import org.eclipse.birt.report.engine.css.engine.value.Value;

public abstract class StyleProcessor {
    private static Map tag2Style = new HashMap();

    static {
        tag2Style.put("code", new StyleProcessor(){

            public void process(IStyle style) {
                this.setFontFamily(style, IStyle.MONOSPACE_VALUE);
            }
        });
        tag2Style.put("em", new StyleProcessor(){

            public void process(IStyle style) {
                this.setFontStyle(style, IStyle.ITALIC_VALUE);
            }
        });
        tag2Style.put("h1", new StyleProcessor(){

            public void process(IStyle style) {
                this.setHStyle(style, 2.0f, 0.67f);
            }
        });
        tag2Style.put("h2", new StyleProcessor(){

            public void process(IStyle style) {
                this.setHStyle(style, 1.5f, 0.75f);
            }
        });
        tag2Style.put("h3", new StyleProcessor(){

            public void process(IStyle style) {
                this.setHStyle(style, 1.17f, 0.83f);
            }
        });
        tag2Style.put("h4", new StyleProcessor(){

            public void process(IStyle style) {
                this.setHStyle(style, 1.12f, 1.12f);
            }
        });
        tag2Style.put("h5", new StyleProcessor(){

            public void process(IStyle style) {
                this.setHStyle(style, 0.83f, 1.5f);
            }
        });
        tag2Style.put("h6", new StyleProcessor(){

            public void process(IStyle style) {
                this.setHStyle(style, 0.75f, 1.67f);
            }
        });
        tag2Style.put("pre", new StyleProcessor(){

            public void process(IStyle style) {
                this.setFontFamily(style, IStyle.MONOSPACE_VALUE);
                style.setProperty(53, IStyle.NOWRAP_VALUE);
            }
        });
        tag2Style.put("strong", new StyleProcessor(){

            public void process(IStyle style) {
                this.setFontWeight(style, IStyle.BOLD_VALUE);
            }
        });
        tag2Style.put("sub", new StyleProcessor(){

            public void process(IStyle style) {
                style.setProperty(31, IStyle.BOTTOM_VALUE);
                style.setProperty(3, 11.createPercentageValue(75.0f));
            }
        });
        tag2Style.put("sup", new StyleProcessor(){

            public void process(IStyle style) {
                style.setProperty(31, IStyle.TOP_VALUE);
                style.setProperty(3, 12.createPercentageValue(75.0f));
            }
        });
        tag2Style.put("big", new StyleProcessor(){

            public void process(IStyle style) {
                style.setProperty(3, 13.createPercentageValue(200.0f));
            }
        });
        tag2Style.put("small", new StyleProcessor(){

            public void process(IStyle style) {
                style.setProperty(3, 14.createPercentageValue(50.0f));
            }
        });
        tag2Style.put("tt", new StyleProcessor(){

            public void process(IStyle style) {
                this.setFontFamily(style, IStyle.MONOSPACE_VALUE);
            }
        });
        tag2Style.put("center", new StyleProcessor(){

            public void process(IStyle style) {
                style.setProperty(23, IStyle.CENTER_VALUE);
            }
        });
        tag2Style.put("i", new StyleProcessor(){

            public void process(IStyle style) {
                this.setFontStyle(style, IStyle.ITALIC_VALUE);
            }
        });
        tag2Style.put("address", new StyleProcessor(){

            public void process(IStyle style) {
                this.setFontStyle(style, IStyle.ITALIC_VALUE);
            }
        });
        tag2Style.put("ins", new StyleProcessor(){

            public void process(IStyle style) {
                style.setProperty(39, IStyle.UNDERLINE_VALUE);
            }
        });
        tag2Style.put("strike", new StyleProcessor(){

            public void process(IStyle style) {
                style.setProperty(42, IStyle.LINE_THROUGH_VALUE);
            }
        });
        tag2Style.put("s", new StyleProcessor(){

            public void process(IStyle style) {
                style.setProperty(42, IStyle.LINE_THROUGH_VALUE);
            }
        });
        tag2Style.put("b", new StyleProcessor(){

            public void process(IStyle style) {
                this.setFontWeight(style, IStyle.BOLD_VALUE);
            }
        });
        tag2Style.put("p", new StyleProcessor(){

            public void process(IStyle style) {
                this.setMarginTopAndBottom(style, 1.33f);
            }
        });
        tag2Style.put("dl", new StyleProcessor(){

            public void process(IStyle style) {
                this.setMarginTopAndBottom(style, 1.0f);
            }
        });
        tag2Style.put("u", new StyleProcessor(){

            public void process(IStyle style) {
                style.setProperty(39, IStyle.UNDERLINE_VALUE);
            }
        });
        tag2Style.put("del", new StyleProcessor(){

            public void process(IStyle style) {
                style.setProperty(42, IStyle.LINE_THROUGH_VALUE);
            }
        });
    }

    abstract void process(IStyle var1);

    protected void setHStyle(IStyle style, float fontSize, float margin) {
        this.setMarginTopAndBottom(style, margin);
        style.setProperty(3, StyleProcessor.createEmValue(fontSize));
        style.setProperty(46, IStyle.BOLD_VALUE);
        style.setProperty(56, IStyle.AVOID_VALUE);
    }

    protected void setMarginTopAndBottom(IStyle style, float margin) {
        style.setProperty(28, StyleProcessor.createEmValue(margin));
        style.setProperty(18, StyleProcessor.createEmValue(margin));
    }

    protected void setFontFamily(IStyle style, Value font) {
        ListValue fonts = new ListValue();
        fonts.append(font);
        style.setProperty(52, fonts);
    }

    protected void setFontStyle(IStyle style, Value fontStyle) {
        style.setProperty(4, fontStyle);
    }

    protected void setFontWeight(IStyle style, Value fontWeight) {
        style.setProperty(46, fontWeight);
    }

    public static StyleProcessor getStyleProcess(String tagName) {
        return (StyleProcessor)tag2Style.get(tagName);
    }

    public static FloatValue createEmValue(float value) {
        return StyleProcessor.createFloatValue((short)3, value);
    }

    public static FloatValue createPercentageValue(float value) {
        return StyleProcessor.createFloatValue((short)2, value);
    }

    private static FloatValue createFloatValue(short unitType, float value) {
        return new FloatValue(unitType, value);
    }
}

