/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.presentation;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.birt.report.engine.presentation.IPageHint;
import org.eclipse.birt.report.engine.presentation.PageSection;
import org.eclipse.birt.report.engine.presentation.TableColumnHint;
import org.eclipse.birt.report.engine.presentation.UnresolvedRowHint;

public class PageHint
implements IPageHint {
    ArrayList sections = new ArrayList();
    protected long pageNumber;
    protected long offset;
    ArrayList hints = new ArrayList();
    protected String masterPage;
    ArrayList columnInfo = new ArrayList();

    public PageHint() {
        this.pageNumber = 0L;
        this.offset = -1L;
    }

    public PageHint(long pageNumber, long pageOffset) {
        this.pageNumber = pageNumber;
        this.offset = pageOffset;
    }

    public PageHint(long pageNumber, long pageOffset, long pageStart, long pageEnd) {
        this.pageNumber = pageNumber;
        this.offset = pageOffset;
        this.addSection(pageStart, pageEnd);
    }

    public PageHint(long pageNumber, String masterPage) {
        this.pageNumber = pageNumber;
        this.masterPage = masterPage;
    }

    public PageHint(long pageNumber, String maserPage, long pageStart, long pageEnd) {
        this.pageNumber = pageNumber;
        this.masterPage = this.masterPage;
        this.addSection(pageStart, pageEnd);
    }

    public long getPageNumber() {
        return this.pageNumber;
    }

    public int getSectionCount() {
        return this.sections.size();
    }

    public long getOffset() {
        return this.offset;
    }

    public long getSectionStart(int i) {
        PageSection section = (PageSection)this.sections.get(i);
        return section.startOffset;
    }

    public long getSectionEnd(int i) {
        PageSection section = (PageSection)this.sections.get(i);
        return section.endOffset;
    }

    public void addSection(long start, long end) {
        PageSection section = new PageSection();
        section.startOffset = start;
        section.endOffset = end;
        this.sections.add(section);
    }

    public PageSection getSection(int i) {
        return (PageSection)this.sections.get(i);
    }

    public void addSection(PageSection section) {
        this.sections.add(section);
    }

    public void addUnresolvedRowHints(Collection hints) {
        this.hints.addAll(hints);
    }

    public int getUnresolvedRowCount() {
        return this.hints.size();
    }

    public UnresolvedRowHint getUnresolvedRowHint(int index) {
        assert (index >= 0 && index < this.hints.size());
        return (UnresolvedRowHint)this.hints.get(index);
    }

    public void addUnresolvedRowHint(UnresolvedRowHint hint) {
        this.hints.add(hint);
    }

    public void setMasterPage(String masterPage) {
        this.masterPage = masterPage;
    }

    public String getMasterPage() {
        return this.masterPage;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public void addTableColumnHint(TableColumnHint hint) {
        this.columnInfo.add(hint);
    }

    public TableColumnHint getTableColumnHint(int index) {
        return (TableColumnHint)this.columnInfo.get(index);
    }

    public int getTableColumnHintCount() {
        return this.columnInfo.size();
    }

    public void addTableColumnHints(Collection hints) {
        this.columnInfo.addAll(hints);
    }
}

