/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.script.internal;

import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.script.eventhandler.ITableEventHandler;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.script.internal.ScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.element.Table;
import org.eclipse.birt.report.engine.script.internal.instance.TableInstance;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.TableHandle;

public class TableScriptExecutor
extends ScriptExecutor {
    public static void handleOnPrepare(TableHandle tableHandle, ExecutionContext context) {
        try {
            Table table = new Table(tableHandle);
            ITableEventHandler eh = TableScriptExecutor.getEventHandler(tableHandle, context);
            if (eh != null) {
                eh.onPrepare(table, context.getReportContext());
            }
        }
        catch (Exception e) {
            TableScriptExecutor.addException(context, e);
        }
    }

    public static void handleOnCreate(ITableContent content, ExecutionContext context) {
        ReportItemDesign tableDesign = (ReportItemDesign)content.getGenerateBy();
        if (!TableScriptExecutor.needOnCreate(tableDesign)) {
            return;
        }
        try {
            TableInstance table = new TableInstance(content, context);
            if (TableScriptExecutor.handleJS(table, tableDesign.getOnCreate(), context).didRun()) {
                return;
            }
            ITableEventHandler eh = TableScriptExecutor.getEventHandler(tableDesign, context);
            if (eh != null) {
                eh.onCreate(table, context.getReportContext());
            }
        }
        catch (Exception e) {
            TableScriptExecutor.addException(context, e, tableDesign.getHandle());
        }
    }

    public static void handleOnRender(ITableContent content, ExecutionContext context) {
        ReportItemDesign tableDesign = (ReportItemDesign)content.getGenerateBy();
        if (!TableScriptExecutor.needOnRender(tableDesign)) {
            return;
        }
        try {
            TableInstance table = new TableInstance(content, context);
            if (TableScriptExecutor.handleJS(table, tableDesign.getOnRender(), context).didRun()) {
                return;
            }
            ITableEventHandler eh = TableScriptExecutor.getEventHandler(tableDesign, context);
            if (eh != null) {
                eh.onRender(table, context.getReportContext());
            }
        }
        catch (Exception e) {
            TableScriptExecutor.addException(context, e, tableDesign.getHandle());
        }
    }

    public static void handleOnPageBreak(ITableContent content, ExecutionContext context) {
        ReportItemDesign tableDesign = (ReportItemDesign)content.getGenerateBy();
        if (!TableScriptExecutor.needOnPageBreak(tableDesign)) {
            return;
        }
        try {
            TableInstance table = new TableInstance(content, context);
            if (TableScriptExecutor.handleJS(table, tableDesign.getOnPageBreak(), context).didRun()) {
                return;
            }
            ITableEventHandler eh = TableScriptExecutor.getEventHandler(tableDesign, context);
            if (eh != null) {
                eh.onPageBreak(table, context.getReportContext());
            }
        }
        catch (Exception e) {
            TableScriptExecutor.addException(context, e, tableDesign.getHandle());
        }
    }

    private static ITableEventHandler getEventHandler(ReportItemDesign design, ExecutionContext context) {
        try {
            return (ITableEventHandler)TableScriptExecutor.getInstance(design, context);
        }
        catch (ClassCastException e) {
            TableScriptExecutor.addClassCastException(context, e, design.getHandle(), ITableEventHandler.class);
        }
        catch (EngineException e) {
            TableScriptExecutor.addException(context, (Exception)((Object)e), design.getHandle());
        }
        return null;
    }

    private static ITableEventHandler getEventHandler(TableHandle handle, ExecutionContext context) {
        try {
            return (ITableEventHandler)TableScriptExecutor.getInstance((DesignElementHandle)handle, context);
        }
        catch (ClassCastException e) {
            TableScriptExecutor.addClassCastException(context, e, (DesignElementHandle)handle, ITableEventHandler.class);
        }
        catch (EngineException e) {
            TableScriptExecutor.addException(context, (Exception)((Object)e), (DesignElementHandle)handle);
        }
        return null;
    }
}

