/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.doc.legacy;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.eclipse.birt.doc.legacy.SpecChoice;
import org.eclipse.birt.doc.legacy.SpecElement;
import org.eclipse.birt.doc.legacy.SpecInheritedProperty;
import org.eclipse.birt.doc.legacy.SpecMethod;
import org.eclipse.birt.doc.legacy.SpecProperty;
import org.eclipse.birt.doc.legacy.SpecSlot;

public class DocWriter {
    SpecElement element;
    PrintStream writer;
    PrintStream index;

    public void startIndex() throws IOException {
        String fileName = "docs/index.html";
        this.index = new PrintStream(new FileOutputStream(fileName));
        this.write(this.index, "<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.0 transitional//EN\">\n");
        this.write(this.index, "<html>\n<head>\n<title>Element Index</title>\n");
        this.write(this.index, "<link rel=\"stylesheet\" href=\"../style/style.css\" type=\"text/css\"/>\n");
        this.write(this.index, "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\">\n");
        this.write(this.index, "</head>\n<body>\n");
    }

    public void startElementIndex() {
        this.write(this.index, "<h1>Elements</h1>\n<ul>\n");
    }

    public void startStructIndex() {
        this.write(this.index, "</ul>\n\n<h1>Structures</h1>\n<ul>\n");
    }

    public void endIndex() throws IOException {
        this.write(this.index, "</ul>\n</body>\n</html>\n");
        this.index.close();
    }

    public String getDir() {
        if (this.element.type == 0) {
            return "elements";
        }
        return "structs";
    }

    public void write(SpecElement el) throws DocException, IOException {
        this.element = el;
        if (this.element.name == null || this.element.name.length() == 0) {
            throw new DocException("Missing file name");
        }
        String fileName = "docs/" + this.getDir() + "/" + this.element.name + ".html";
        this.writer = new PrintStream(new FileOutputStream(fileName));
        this.writeHeader();
        this.writeElement();
        this.writeProperties();
        this.writeMethods();
        this.writeSlots();
        this.writeFooter();
        this.writer.close();
    }

    private void write(String s) throws IOException {
        this.write(this.writer, s);
    }

    private void write(PrintStream out, String s) {
        if (this.isBlank(s)) {
            return;
        }
        if (s.indexOf(10) == 0) {
            out.print(s);
            return;
        }
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == '\n') {
                out.println("");
            } else {
                out.print(c);
            }
            ++i;
        }
    }

    private void writeln(String s) throws IOException {
        if (this.isBlank(s)) {
            return;
        }
        this.write(s);
        this.writer.println("");
    }

    private boolean isBlank(String s) {
        return s == null || s.trim().length() == 0;
    }

    private void writePara(String s) throws IOException {
        if (this.isBlank(s)) {
            return;
        }
        this.write("<p>");
        this.write(s);
        this.writeln("</p>\n");
    }

    private void writeHeader() throws IOException {
        this.writeln("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.0 transitional//EN\">");
        this.write("<html>\n<head>\n<title>");
        String title = this.element.displayName;
        if (this.isBlank(this.element.displayName)) {
            title = this.element.name;
        }
        this.write(title);
        this.writeln("</title>");
        this.writeln("<link rel=\"stylesheet\" href=\"../style/style.css\" type=\"text/css\"/>");
        this.writeln("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\">");
        this.writeln("</head>\n<body>");
        this.write(this.index, "<li><a href=\"" + this.getDir() + "/");
        this.write(this.index, this.element.name);
        this.write(this.index, ".html\">");
        this.write(this.index, title);
        this.write(this.index, "</a></li>\n");
    }

    private void writeElement() throws IOException {
        this.write("<h1>");
        this.write(this.element.name);
        this.writeln("</h1>\n");
        this.writePara(this.element.summary);
        this.writeln("<h3>Description</h3>\n");
        this.writePara(this.element.description);
        if (this.element.type == 0) {
            this.write("<h3>XML Summary</h3>\n");
            this.writePara(this.element.xmlSummary);
            this.writeInheritedProperties();
        }
        this.writeIssues(this.element.issues);
        this.writeln("<h3>See Also</h3>\n");
        this.writePara(this.element.seeAlso);
    }

    public void writeIssues(String issues) throws IOException {
        if (issues == null) {
            return;
        }
        this.write("<h3>Issues</h3>\n");
        this.write(issues);
    }

    private void writeInheritedProperties() throws IOException {
        if (this.element.inheritedProperties.isEmpty()) {
            return;
        }
        this.writeln("\n<h3>Inherited Properties</h3>\n\n<dl>");
        int i = 0;
        while (i < this.element.inheritedProperties.size()) {
            this.writeInheritedProperty((SpecInheritedProperty)this.element.inheritedProperties.get(i));
            ++i;
        }
        this.write("</dl>\n\n");
    }

    private void writeInheritedProperty(SpecInheritedProperty prop) throws IOException {
        this.write("<dt class=\"inherited-property\">");
        this.write(prop.name);
        this.write("</dt>\n<dd>");
        this.write(prop.description);
        this.writeln("</dd>");
    }

    private void writeProperties() throws IOException {
        int i = 0;
        while (i < this.element.properties.size()) {
            this.writeProperty((SpecProperty)this.element.properties.get(i));
            ++i;
        }
    }

    private void writeProperty(SpecProperty prop) throws IOException {
        this.write("<h2 class=\"property\">");
        this.write(prop.name);
        this.writeln("</h2>\n");
        this.writePara(prop.summary);
        this.writeln("<h3>Summary</h3>");
        this.writePara(prop.shortDescrip);
        this.writeChoices(prop);
        this.writeln("<h3>Description</h3>");
        this.writePara(prop.description);
        this.writeIssues(prop.issues);
        this.write("<h3>See Also</h3>\n");
        this.writePara(prop.seeAlso);
    }

    private void writeChoices(SpecProperty prop) throws IOException {
        if (prop.choices.isEmpty()) {
            return;
        }
        this.writeln("<h3>Choices</h3>\n<ul>");
        for (SpecChoice choice : prop.choices) {
            this.write("<li>");
            this.write(choice.name);
            this.write(": ");
            this.write(choice.description);
            this.writeln("</li>\n");
        }
        this.writeln("</ul>");
    }

    private void writeMethods() throws IOException {
        int i = 0;
        while (i < this.element.methods.size()) {
            this.writeMethod((SpecMethod)this.element.methods.get(i));
            ++i;
        }
    }

    private void writeMethod(SpecMethod method) throws IOException {
        this.write("<h2 class=\"method\">");
        this.write(method.name);
        this.writeln("</h2>\n");
        this.writePara(method.summary);
        this.writeln("<h3>Summary</h3>");
        this.writePara(method.shortDescrip);
        this.writeln("<h3>Description</h3>");
        this.writePara(method.description);
        this.writeIssues(method.issues);
        this.write("<h3>See Also</h3>\n");
        this.writePara(method.seeAlso);
    }

    private void writeSlots() throws IOException {
        int i = 0;
        while (i < this.element.slots.size()) {
            this.writeSlot((SpecSlot)this.element.slots.get(i));
            ++i;
        }
    }

    private void writeSlot(SpecSlot slot) throws IOException {
        this.write("<h2 class=\"slot\">");
        this.write(slot.name);
        this.writeln("</h2>\n");
        this.writePara(slot.summary);
        this.writeln("<h3>Summary</h3>");
        this.writePara(slot.shortDescrip);
        this.writeln("<h3>Description</h3>");
        this.writePara(slot.description);
        this.writeln("<h3>Contents</h3>");
        this.writePara(slot.contents);
        this.writeIssues(slot.issues);
        this.write("<h3>See Also</h3>\n");
        this.writeln(slot.seeAlso);
    }

    private void writeFooter() throws IOException {
        this.writeln("</body>\n</html>");
    }

    class DocException
    extends Exception {
        private static final long serialVersionUID = -1769976375996415539L;

        DocException(String msg) {
            super(msg);
        }
    }
}

