/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.activity;

import java.util.ArrayList;
import java.util.Stack;
import org.eclipse.birt.report.model.activity.ActivityRecord;
import org.eclipse.birt.report.model.activity.CompoundRecord;
import org.eclipse.birt.report.model.activity.ExtensionActivityRecord;
import org.eclipse.birt.report.model.activity.LayoutCompoundRecord;
import org.eclipse.birt.report.model.activity.TransactionAdapter;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.activity.ActivityStackEvent;
import org.eclipse.birt.report.model.api.activity.ActivityStackListener;
import org.eclipse.birt.report.model.api.activity.IActivityRecord;
import org.eclipse.birt.report.model.api.activity.TransactionOption;
import org.eclipse.birt.report.model.api.extension.IElementCommand;

public class ActivityStack
implements CommandStack {
    public static final int DEFAULT_STACK_LIMIT = 500;
    protected Stack undoStack = new Stack();
    protected Stack redoStack = new Stack();
    protected Stack transStack = new Stack();
    protected TransactionAdapter adapter = new TransactionAdapter(this);
    private int stackLimit = 500;
    private int transCount = 0;
    protected ArrayList listeners = null;

    public void execute(IElementCommand command) {
        ExtensionActivityRecord record = new ExtensionActivityRecord(command);
        this.execute(record);
    }

    public void execute(IActivityRecord executeRecord) {
        ActivityRecord record = (ActivityRecord)executeRecord;
        assert (record != null);
        assert (record.getState() == 0);
        record.execute();
        record.setState(1);
        assert (!(record instanceof CompoundRecord));
        record.performPostTasks(this.transStack);
        if (this.transStack.isEmpty()) {
            this.destroyRecords(this.redoStack);
            record.setTransNo(++this.transCount);
            this.undoStack.push(record);
            this.trimUndoStack();
            this.sendNotifcations(new ActivityStackEvent(this, 1));
        } else {
            CompoundRecord trans = (CompoundRecord)this.transStack.lastElement();
            trans.append(record);
        }
    }

    public void undo() {
        assert (this.canUndo());
        ActivityRecord record = (ActivityRecord)this.undoStack.pop();
        assert (record.getState() == 1 || record.getState() == 3);
        record.undo();
        record.setState(2);
        this.redoStack.push(record);
        record.performPostTasks(this.transStack);
        this.sendNotifcations(new ActivityStackEvent(this, 3));
    }

    public void redo() {
        assert (this.canRedo());
        ActivityRecord record = (ActivityRecord)this.redoStack.pop();
        assert (record.getState() == 2);
        record.redo();
        record.setState(3);
        this.undoStack.push(record);
        record.performPostTasks(this.transStack);
        this.sendNotifcations(new ActivityStackEvent(this, 2));
    }

    public boolean canUndo() {
        if (!this.transStack.isEmpty()) {
            return false;
        }
        if (this.undoStack.size() == 0) {
            return false;
        }
        ActivityRecord record = (ActivityRecord)this.undoStack.lastElement();
        return record.canUndo();
    }

    public boolean canRedo() {
        if (!this.transStack.isEmpty()) {
            return false;
        }
        if (this.redoStack.size() == 0) {
            return false;
        }
        ActivityRecord record = (ActivityRecord)this.redoStack.lastElement();
        return record.canUndo();
    }

    protected void trimUndoStack() {
        while (this.undoStack.size() > this.stackLimit) {
            ActivityRecord cmd = (ActivityRecord)this.undoStack.remove(0);
            assert (cmd.getState() != 4);
            cmd.destroy();
            cmd.setState(4);
        }
    }

    public void flush() {
        this.destroyRecords(this.redoStack);
        this.destroyRecords(this.undoStack);
    }

    private void destroyRecords(Stack stack) {
        for (ActivityRecord cmd : stack) {
            assert (cmd.getState() != 4);
            cmd.destroy();
            cmd.setState(4);
        }
        stack.removeAllElements();
    }

    public void setStackLimit(int limit) {
        assert (limit >= 0);
        this.stackLimit = limit;
        this.trimUndoStack();
    }

    public Object[] getRecords() {
        ArrayList records = new ArrayList(this.undoStack);
        int i = this.redoStack.size() - 1;
        while (i >= 0) {
            records.add(this.redoStack.get(i));
            --i;
        }
        return records.toArray();
    }

    public IActivityRecord getRedoRecord() {
        return this.redoStack.isEmpty() ? null : (ActivityRecord)this.redoStack.peek();
    }

    public IActivityRecord getUndoRecord() {
        return this.undoStack.isEmpty() ? null : (ActivityRecord)this.undoStack.peek();
    }

    public String getUndoLabel() {
        IActivityRecord cmd = this.getUndoRecord();
        if (cmd == null) {
            return null;
        }
        String label = cmd.getLabel();
        assert (label != null);
        return label;
    }

    public String getRedoLabel() {
        IActivityRecord cmd = this.getRedoRecord();
        if (cmd == null) {
            return null;
        }
        String label = cmd.getLabel();
        assert (label != null);
        return label;
    }

    public void startTrans(String label) {
        this.transStack.push(this.adapter.createNewRecord(0, label));
    }

    public void startTrans(String label, TransactionOption options) {
        this.startTrans(label);
        CompoundRecord tmpRecord = (CompoundRecord)this.transStack.peek();
        tmpRecord.setOptions(options);
    }

    public void commit() {
        assert (!this.transStack.empty());
        CompoundRecord transaction = (CompoundRecord)this.transStack.pop();
        if (transaction.isEmpty()) {
            transaction.destroy();
            return;
        }
        transaction.setState(1);
        CompoundRecord record = transaction;
        ((ActivityRecord)record).performPostTasks(this.transStack);
        if (this.transStack.empty()) {
            this.destroyRecords(this.redoStack);
            record.setTransNo(++this.transCount);
            this.adapter.handleCommit(record);
            this.sendNotifcations(new ActivityStackEvent(this, 1));
        } else {
            CompoundRecord outer = (CompoundRecord)this.transStack.lastElement();
            outer.append(record);
        }
    }

    public void rollback() {
        assert (this.transStack.size() > 0);
        CompoundRecord trans = (CompoundRecord)this.transStack.pop();
        trans.rollback();
        trans.destroy();
        this.adapter.handleRollback(trans);
        if (this.transStack.empty()) {
            this.sendNotifcations(new ActivityStackEvent(this, 4));
        }
    }

    public void rollbackAll() {
        while (!this.transStack.isEmpty()) {
            this.rollback();
        }
    }

    public int getCurrentTransNo() {
        if (this.undoStack.isEmpty()) {
            return 0;
        }
        return ((ActivityRecord)this.undoStack.lastElement()).getTransNo();
    }

    public void addListener(ActivityStackListener obj) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        if (obj != null && !this.listeners.contains(obj)) {
            this.listeners.add(obj);
        }
    }

    public void removeListener(ActivityStackListener obj) {
        if (this.listeners == null) {
            return;
        }
        int posn = this.listeners.indexOf(obj);
        if (posn != -1) {
            this.listeners.remove(posn);
        }
    }

    public void sendNotifcations(ActivityStackEvent event) {
        if (this.listeners != null) {
            for (ActivityStackListener listener : this.listeners) {
                listener.stackChanged(event);
            }
        }
    }

    public void startPersistentTrans(String label) {
        this.transStack.push(this.adapter.createNewRecord(3, label));
    }

    public void startPersistentTrans() {
        this.startPersistentTrans(null);
    }

    public void startSilentTrans(String label) {
        this.startSilentTrans(label, false);
    }

    public void startSilentTrans(boolean filterAll) {
        this.startSilentTrans(null, filterAll);
    }

    protected void startSilentTrans(String label, boolean filterAll) {
        LayoutCompoundRecord cmpRecord = (LayoutCompoundRecord)this.adapter.createNewRecord(2, label);
        cmpRecord.setFilterAll(filterAll);
        this.transStack.push(cmpRecord);
    }

    public void startFilterEventTrans(String label) {
        this.transStack.push(this.adapter.createNewRecord(1, label));
    }

    public void startNonUndoableTrans(String label) {
        this.transStack.push(this.adapter.createNewRecord(4, label));
    }

    public void clearListeners() {
        if (this.listeners != null) {
            this.listeners.clear();
        }
        this.listeners = null;
    }

    protected int increaseTransCount() {
        return ++this.transCount;
    }
}

