/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.excel;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.engine.api.IAction;
import org.eclipse.birt.report.engine.api.IHTMLActionHandler;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.impl.Action;
import org.eclipse.birt.report.engine.api.script.IReportContext;
import org.eclipse.birt.report.engine.content.IAutoTextContent;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IContainerContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IDataContent;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.IHyperlinkAction;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.ILabelContent;
import org.eclipse.birt.report.engine.content.IListBandContent;
import org.eclipse.birt.report.engine.content.IListContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.emitter.ContentEmitterAdapter;
import org.eclipse.birt.report.engine.emitter.EmitterUtil;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.emitter.IEmitterServices;
import org.eclipse.birt.report.engine.emitter.excel.BookmarkDef;
import org.eclipse.birt.report.engine.emitter.excel.Data;
import org.eclipse.birt.report.engine.emitter.excel.ExcelUtil;
import org.eclipse.birt.report.engine.emitter.excel.ExcelWriter;
import org.eclipse.birt.report.engine.emitter.excel.HyperlinkDef;
import org.eclipse.birt.report.engine.emitter.excel.layout.ContainerSizeInfo;
import org.eclipse.birt.report.engine.emitter.excel.layout.ExcelContext;
import org.eclipse.birt.report.engine.emitter.excel.layout.ExcelLayoutEngine;
import org.eclipse.birt.report.engine.emitter.excel.layout.LayoutUtil;
import org.eclipse.birt.report.engine.emitter.excel.layout.PageDef;
import org.eclipse.birt.report.engine.emitter.excel.layout.TableInfo;
import org.eclipse.birt.report.engine.ir.SimpleMasterPageDesign;
import org.eclipse.birt.report.engine.ir.StyledElementDesign;
import org.eclipse.birt.report.engine.layout.pdf.util.HTML2Content;
import org.eclipse.birt.report.engine.presentation.ContentEmitterVisitor;

public class ExcelEmitter
extends ContentEmitterAdapter {
    private String tempfilePath;
    protected static Logger logger = Logger.getLogger(ExcelEmitter.class.getName());
    private static int sheetIndex = 1;
    private IEmitterServices service = null;
    private OutputStream out = null;
    private ExcelLayoutEngine engine;
    ContentEmitterVisitor contentVisitor = new ContentEmitterVisitor((IContentEmitter)this);
    private ExcelWriter tempWriter;
    public ExcelContext context = new ExcelContext();
    private String orientation = null;
    private String pageHeader;
    private String pageFooter;
    private boolean outputInMasterPage = false;

    public String getOutputFormat() {
        return "xls";
    }

    public void initialize(IEmitterServices service) {
        this.service = service;
        if (service != null) {
            this.out = EmitterUtil.getOuputStream((IEmitterServices)service, (String)"report.xls");
        }
    }

    public void start(IReportContent report) {
        this.setupRenderOptions();
        IStyle style = report.getRoot().getComputedStyle();
        SimpleMasterPageDesign master = (SimpleMasterPageDesign)report.getDesign().getPageSetup().getMasterPage(0);
        this.engine = new ExcelLayoutEngine(new PageDef(master, style), this.context, this);
        this.tempfilePath = String.valueOf(System.getProperty("java.io.tmpdir")) + File.separator + "_BIRTEMITTER_EXCEL_TEMP_FILE" + Thread.currentThread().getId();
    }

    private void setupRenderOptions() {
        IRenderOption renderOptions = this.service.getRenderOption();
        Object textWrapping = renderOptions.getOption("excelRenderOption.wrappingText");
        if (textWrapping != null && textWrapping instanceof Boolean) {
            this.context.setWrappingText((Boolean)textWrapping);
        } else {
            this.context.setWrappingText(true);
        }
        Object officeVersion = renderOptions.getOption("excelRenderOption.officeVersion");
        if (officeVersion != null && officeVersion instanceof String) {
            if (officeVersion.equals("office2007")) {
                this.context.setOfficeVersion("office2007");
            }
        } else {
            this.context.setOfficeVersion("office2003");
        }
    }

    public void startPage(IPageContent page) {
        if (this.orientation == null) {
            this.orientation = this.capitalize(page.getOrientation());
        }
        if (this.needOutputInMasterPage(page.getPageHeader()) && this.needOutputInMasterPage(page.getPageFooter())) {
            this.outputInMasterPage = true;
            this.pageHeader = this.formatHeaderFooter(page.getPageHeader(), true);
            this.pageFooter = this.formatHeaderFooter(page.getPageFooter(), false);
        }
        if (!this.outputInMasterPage && page.getPageHeader() != null) {
            this.contentVisitor.visitChildren(page.getPageHeader(), null);
        }
    }

    public void endPage(IPageContent page) {
        if (!this.outputInMasterPage && page.getPageFooter() != null) {
            this.contentVisitor.visitChildren(page.getPageFooter(), null);
        }
    }

    public void startTable(ITableContent table) {
        ContainerSizeInfo sizeInfo = this.engine.getCurrentContainer().getSizeInfo();
        int width = sizeInfo.getWidth();
        TableInfo info = LayoutUtil.createTable(table, width);
        if (info == null) {
            return;
        }
        String caption = table.getCaption();
        if (caption != null) {
            this.engine.addCaption(caption);
        }
        this.engine.addTable(info, table.getComputedStyle());
    }

    public void startRow(IRowContent row) {
        this.engine.addRow(row.getComputedStyle());
    }

    public void endRow(IRowContent row) {
        this.engine.endRow();
    }

    public void startCell(ICellContent cell) {
        IStyle style = cell.getComputedStyle();
        this.engine.addCell(cell.getColumn(), cell.getColSpan(), cell.getRowSpan(), style);
    }

    public void endCell(ICellContent cell) {
        this.engine.endCell();
    }

    public void endTable(ITableContent table) {
        this.engine.endTable();
    }

    public void startList(IListContent list) {
        ContainerSizeInfo rule = this.engine.getCurrentContainer().getSizeInfo();
        TableInfo table = LayoutUtil.createTable(list, rule.getWidth());
        this.engine.addTable(table, list.getComputedStyle());
        if (list.getChildren() == null) {
            HyperlinkDef link = this.parseHyperLink((IContent)list);
            BookmarkDef bookmark = this.getBookmark((IContent)list);
            this.engine.addData("", list.getComputedStyle(), link, bookmark);
        }
    }

    public void startListBand(IListBandContent listBand) {
        this.engine.addCell(0, 1, 0, listBand.getComputedStyle());
    }

    public void endListBand(IListBandContent listBand) {
        this.engine.endCell();
    }

    public void endList(IListContent list) {
        this.engine.endTable();
    }

    public void startForeign(IForeignContent foreign) {
        if ("text/html".equalsIgnoreCase(foreign.getRawType())) {
            HTML2Content.html2Content((IForeignContent)foreign);
            HyperlinkDef link = this.parseHyperLink((IContent)foreign);
            this.engine.addContainer(foreign.getComputedStyle(), link);
            this.contentVisitor.visitChildren((IContent)foreign, null);
            this.engine.endContainer();
        }
    }

    public void startText(ITextContent text) {
        HyperlinkDef url = this.parseHyperLink((IContent)text);
        BookmarkDef bookmark = this.getBookmark((IContent)text);
        this.engine.addData(text.getText(), text.getComputedStyle(), url, bookmark);
    }

    public void startData(IDataContent data) {
        HyperlinkDef url = this.parseHyperLink((IContent)data);
        BookmarkDef bookmark = this.getBookmark((IContent)data);
        if (((StyledElementDesign)data.getGenerateBy()).getMap() != null && ((StyledElementDesign)data.getGenerateBy()).getMap().getRuleCount() > 0 && data.getLabelText() != null) {
            this.engine.addData(data.getLabelText().trim(), data.getComputedStyle(), url, bookmark);
        } else if (ExcelUtil.getType(data.getValue()).equals("STRING")) {
            this.engine.addData(data.getText(), data.getComputedStyle(), url, bookmark);
        } else if (!ExcelUtil.getType(data.getValue()).equals("NUMBER")) {
            this.engine.addDateTime(data, data.getComputedStyle(), url, bookmark);
        } else {
            this.engine.addData(data.getValue(), data.getComputedStyle(), url, bookmark);
        }
    }

    public void startImage(IImageContent image) {
    }

    public void startLabel(ILabelContent label) {
        Object design = label.getGenerateBy();
        ILabelContent container = label;
        while (design == null) {
            container = (IContent)container.getParent();
            design = container.getGenerateBy();
        }
        HyperlinkDef url = this.parseHyperLink((IContent)label);
        BookmarkDef bookmark = this.getBookmark((IContent)label);
        if (!"\n".equalsIgnoreCase(label.getText()) || !(container instanceof IForeignContent)) {
            this.engine.addData(label.getText(), label.getComputedStyle(), url, bookmark);
        }
    }

    public void startAutoText(IAutoTextContent autoText) {
        HyperlinkDef link = this.parseHyperLink((IContent)autoText);
        BookmarkDef bookmark = this.getBookmark((IContent)autoText);
        this.engine.addData(autoText.getText(), autoText.getComputedStyle(), link, bookmark);
    }

    public void outputSheet() {
        this.engine.complete();
        try {
            if (this.tempWriter == null) {
                FileOutputStream tempOut = new FileOutputStream(this.tempfilePath);
                this.tempWriter = new ExcelWriter((OutputStream)tempOut, this.context);
            }
            this.outputSheetData(this.tempWriter);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    private void outputSheetData(ExcelWriter writer) {
        this.startSheet(writer);
        int count = 0;
        while (count < this.engine.getRowCount()) {
            this.outputData(this.engine.getRow(count), writer);
            ++count;
        }
        this.endSheet(writer);
    }

    public void end(IReportContent report) {
        this.engine.complete();
        boolean isRTLSheet = false;
        String reportOrientation = report.getDesign().getReportDesign().getBidiOrientation();
        if ("rtl".equalsIgnoreCase(reportOrientation)) {
            isRTLSheet = true;
        }
        ExcelWriter writer = new ExcelWriter(this.out, this.context, isRTLSheet);
        writer.writeDeclarations();
        writer.writeDocumentProperties(report);
        writer.declareStyles(this.engine.getStyleMap());
        writer.defineNames(this.engine.getNamesRefer());
        if (this.tempWriter != null) {
            this.tempWriter.close(false);
            File file = new File(this.tempfilePath);
            writer.insertSheet(file);
            file.delete();
            if (this.engine.getRowCount() != 0) {
                this.outputCacheData(writer);
            }
        } else {
            this.outputCacheData(writer);
        }
        writer.close(true);
        sheetIndex = 1;
    }

    private void outputCacheData(ExcelWriter writer) {
        this.startSheet(writer);
        int count = 0;
        while (count < this.engine.getRowCount()) {
            this.outputData(this.engine.getRow(count), writer);
            ++count;
        }
        this.endSheet(writer);
    }

    private void startSheet(ExcelWriter writer) {
        writer.startSheet(sheetIndex);
        writer.startTable(this.engine.getCoordinates());
        ++sheetIndex;
    }

    private void endSheet(ExcelWriter writer) {
        writer.endTable();
        writer.declareWorkSheetOptions(this.orientation, this.pageHeader, this.pageFooter);
        writer.closeSheet();
    }

    private void outputData(Data[] row, ExcelWriter writer) {
        writer.startRow();
        int i = 0;
        while (i < row.length) {
            writer.writeTxtData(row[i]);
            ++i;
        }
        writer.endRow();
    }

    private HyperlinkDef parseHyperLink(IContent content) {
        IHyperlinkAction linkaction = content.getHyperlinkAction();
        if (linkaction != null) {
            String toolTip = linkaction.getTooltip();
            if (linkaction.getType() == 2) {
                String bookmark = linkaction.getBookmark();
                if (ExcelUtil.isValidBookmarkName(bookmark)) {
                    return new HyperlinkDef(linkaction.getBookmark(), 2, null, toolTip);
                }
                return null;
            }
            if (linkaction.getType() == 1) {
                return new HyperlinkDef(linkaction.getHyperlink(), 1, null, toolTip);
            }
            if (linkaction.getType() == 3) {
                Action act = new Action(linkaction);
                IHTMLActionHandler actionHandler = null;
                Object ac = this.service.getOption("actionHandler");
                if (ac != null && ac instanceof IHTMLActionHandler) {
                    actionHandler = (IHTMLActionHandler)ac;
                    String url = actionHandler.getURL((IAction)act, this.service.getReportContext());
                    if (url != null && url.length() > 0) {
                        return new HyperlinkDef(url, 3, null, toolTip);
                    }
                    return null;
                }
            }
        }
        return null;
    }

    private BookmarkDef getBookmark(IContent content) {
        String bookmark = content.getBookmark();
        if (bookmark == null) {
            return null;
        }
        if (!ExcelUtil.isValidBookmarkName(bookmark)) {
            logger.log(Level.WARNING, "Invalid bookmark name for Excel!");
            return null;
        }
        return new BookmarkDef(content.getBookmark());
    }

    public String capitalize(String orientation) {
        if (orientation.equalsIgnoreCase("landscape")) {
            return "Landscape";
        }
        if (orientation.equalsIgnoreCase("portrait")) {
            return "Portrait";
        }
        return null;
    }

    public String formatHeaderFooter(IContent headerFooter, boolean isHeader) {
        StringBuffer headfoot = new StringBuffer();
        if (headerFooter != null) {
            Collection list = headerFooter.getChildren();
            for (Object child : list) {
                if (child instanceof ITableContent) {
                    headfoot.append(this.getTableValue((ITableContent)child));
                    continue;
                }
                this.processText(headfoot, child);
            }
            return headfoot.toString();
        }
        return null;
    }

    private void processText(StringBuffer buffer, Object child) {
        if (child instanceof IAutoTextContent) {
            buffer.append(this.getAutoText((IAutoTextContent)child));
        } else if (child instanceof ITextContent) {
            buffer.append(((ITextContent)child).getText());
        } else if (child instanceof IForeignContent) {
            buffer.append(((IForeignContent)child).getRawValue());
        }
    }

    public boolean needOutputInMasterPage(IContent headerFooter) {
        if (headerFooter != null) {
            Collection list = headerFooter.getChildren();
            for (Object child : list) {
                if (!(child instanceof ITableContent)) continue;
                int columncount = ((ITableContent)child).getColumnCount();
                int rowcount = ((ITableContent)child).getChildren().size();
                if (columncount > 3 || rowcount > 1) {
                    logger.log(Level.WARNING, "Excel page header or footer only accept a table no more than 1 row and 3 columns.");
                    return false;
                }
                if (!this.isEmbededTable((ITableContent)child)) continue;
                logger.log(Level.WARNING, "Excel page header and footer don't support embeded grid.");
                return false;
            }
        }
        return true;
    }

    public String getTableValue(ITableContent table) {
        StringBuffer tableValue = new StringBuffer();
        Collection list = table.getChildren();
        for (Object child : list) {
            tableValue.append(this.getRowValue((IRowContent)child));
        }
        return tableValue.toString();
    }

    public String getRowValue(IRowContent row) {
        StringBuffer rowValue = new StringBuffer();
        Collection list = row.getChildren();
        Iterator iter = list.iterator();
        list.size();
        int currentCellCount = 0;
        while (iter.hasNext()) {
            Object child = iter.next();
            switch (++currentCellCount) {
                case 1: {
                    rowValue.append("&L");
                    break;
                }
                case 2: {
                    rowValue.append("&C");
                    break;
                }
                case 3: {
                    rowValue.append("&R");
                    break;
                }
            }
            rowValue.append(this.getCellValue((ICellContent)child));
        }
        return rowValue.toString();
    }

    public String getCellValue(ICellContent cell) {
        StringBuffer cellValue = new StringBuffer();
        Collection list = cell.getChildren();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            this.processText(cellValue, iter.next());
        }
        return cellValue.toString();
    }

    private String getAutoText(IAutoTextContent autoText) {
        String result = null;
        int type = autoText.getType();
        if (type == 1) {
            result = "&P";
        } else if (type == 0) {
            result = "&N";
        }
        return result;
    }

    private boolean isEmbededTable(ITableContent table) {
        boolean isEmbeded = false;
        Collection list = table.getChildren();
        for (Object child : list) {
            Collection listCell = ((IRowContent)child).getChildren();
            for (Object cellChild : listCell) {
                Collection listCellChild = ((ICellContent)cellChild).getChildren();
                for (Object cellchild : listCellChild) {
                    if (!(cellchild instanceof ITableContent)) continue;
                    isEmbeded = true;
                }
            }
        }
        return isEmbeded;
    }

    public Locale getLocale() {
        IReportContext reportContext;
        if (this.service != null && (reportContext = this.service.getReportContext()) != null) {
            return reportContext.getLocale();
        }
        return Locale.getDefault();
    }

    public void endContainer(IContainerContent container) {
        this.engine.removeContainerStyle();
    }

    public void startContainer(IContainerContent container) {
        this.engine.addContainerStyle(container.getComputedStyle());
    }
}

