/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.excel.layout;

import java.sql.Date;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import org.eclipse.birt.report.engine.content.IDataContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.emitter.excel.BlankData;
import org.eclipse.birt.report.engine.emitter.excel.BookmarkDef;
import org.eclipse.birt.report.engine.emitter.excel.Data;
import org.eclipse.birt.report.engine.emitter.excel.DataCache;
import org.eclipse.birt.report.engine.emitter.excel.DateTimeUtil;
import org.eclipse.birt.report.engine.emitter.excel.ExcelEmitter;
import org.eclipse.birt.report.engine.emitter.excel.ExcelUtil;
import org.eclipse.birt.report.engine.emitter.excel.HyperlinkDef;
import org.eclipse.birt.report.engine.emitter.excel.Span;
import org.eclipse.birt.report.engine.emitter.excel.StyleBuilder;
import org.eclipse.birt.report.engine.emitter.excel.StyleEngine;
import org.eclipse.birt.report.engine.emitter.excel.StyleEntry;
import org.eclipse.birt.report.engine.emitter.excel.layout.AxisProcessor;
import org.eclipse.birt.report.engine.emitter.excel.layout.ContainerSizeInfo;
import org.eclipse.birt.report.engine.emitter.excel.layout.ExcelContext;
import org.eclipse.birt.report.engine.emitter.excel.layout.PageDef;
import org.eclipse.birt.report.engine.emitter.excel.layout.TableInfo;
import org.eclipse.birt.report.engine.emitter.excel.layout.XlsCell;
import org.eclipse.birt.report.engine.emitter.excel.layout.XlsContainer;
import org.eclipse.birt.report.engine.emitter.excel.layout.XlsTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExcelLayoutEngine {
    public static final String EMPTY = "";
    public static final int MAX_ROW = 65535;
    public static int MAX_COLUMN = 255;
    private DataCache cache;
    private AxisProcessor axis;
    private StyleEngine engine;
    private ExcelEmitter emitter;
    private Stack<XlsContainer> containers = new Stack();
    private Stack<XlsTable> tables = new Stack();
    private Hashtable<String, String> links = new Hashtable();
    ExcelContext context = null;

    public ExcelLayoutEngine(PageDef page, ExcelContext context, ExcelEmitter emitter) {
        this.context = context;
        this.emitter = emitter;
        this.initalize(page);
    }

    private void initalize(PageDef page) {
        this.axis = new AxisProcessor();
        this.axis.addCoordinate(page.contentwidth);
        this.setCacheSize();
        ContainerSizeInfo rule = new ContainerSizeInfo(0, page.contentwidth);
        this.cache = new DataCache(MAX_COLUMN, 65535, this.emitter);
        this.engine = new StyleEngine(this);
        this.containers.push(this.createContainer(rule, page.style, null));
    }

    private void setCacheSize() {
        if (this.context.getOfficeVersion().equals("office2007")) {
            MAX_COLUMN = 10000;
        }
    }

    public XlsContainer getCurrentContainer() {
        return this.containers.peek();
    }

    public Stack<XlsContainer> getContainers() {
        return this.containers;
    }

    public void addTable(TableInfo table, IStyle style) {
        XlsContainer currentContainer = this.getCurrentContainer();
        ContainerSizeInfo parentSizeInfo = currentContainer.getSizeInfo();
        int startCoordinate = parentSizeInfo.getStartCoordinate();
        int endCoordinate = parentSizeInfo.getEndCoordinate();
        int[] columnStartCoordinates = this.calculateColumnCoordinates(table, startCoordinate, endCoordinate);
        this.splitColumns(startCoordinate, endCoordinate, columnStartCoordinates);
        this.createTable(table, style, currentContainer, columnStartCoordinates);
    }

    private void createTable(TableInfo table, IStyle style, XlsContainer currentContainer, int[] columnStartCoordinates) {
        int leftCordinate = columnStartCoordinates[0];
        int width = columnStartCoordinates[columnStartCoordinates.length - 1] - leftCordinate;
        ContainerSizeInfo sizeInfo = new ContainerSizeInfo(leftCordinate, width);
        XlsContainer container = this.createContainer(sizeInfo, style, currentContainer);
        XlsTable tcontainer = new XlsTable(table, container);
        this.addContainer(tcontainer);
        this.tables.push(tcontainer);
    }

    private void splitColumns(int startCoordinate, int endCoordinate, int[] columnStartCoordinates) {
        int[] scale = this.axis.getColumnCoordinatesInRange(startCoordinate, endCoordinate);
        int i = 0;
        while (i < scale.length - 1) {
            int startPosition = scale[i];
            int endPostion = scale[i + 1];
            int[] range = this.inRange(startPosition, endPostion, columnStartCoordinates);
            if (range.length > 0) {
                int pos = this.axis.getColumnIndexByCoordinate(startPosition);
                this.cache.insertColumns(pos, range.length);
                int j = 0;
                while (j < range.length) {
                    this.axis.addCoordinate(range[j]);
                    ++j;
                }
            }
            ++i;
        }
    }

    private int[] calculateColumnCoordinates(TableInfo table, int startCoordinate, int endCoordinate) {
        XlsContainer currentContainer = this.getCurrentContainer();
        int columnCount = table.getColumnCount();
        int[] columnStartCoordinates = new int[columnCount + 1];
        if (this.isRightAligned(currentContainer)) {
            columnStartCoordinates[columnCount] = endCoordinate;
            int i = columnCount - 1;
            while (i >= 0) {
                columnStartCoordinates[i] = columnStartCoordinates[i + 1] - table.getColumnWidth(i);
                --i;
            }
        } else {
            columnStartCoordinates[0] = startCoordinate;
            int i = 1;
            while (i <= columnCount) {
                columnStartCoordinates[i] = columnStartCoordinates[i - 1] + table.getColumnWidth(i - 1);
                ++i;
            }
        }
        return columnStartCoordinates;
    }

    private boolean isRightAligned(XlsContainer currentContainer) {
        boolean isRightAligned = false;
        String align = currentContainer.getStyle().getProperty(8);
        isRightAligned = "Right".equalsIgnoreCase(align);
        return isRightAligned;
    }

    private int[] inRange(int start, int end, int[] data) {
        int[] range = new int[data.length];
        int count = 0;
        int i = 0;
        while (i < data.length) {
            if (data[i] > start && data[i] < end) {
                range[++count] = data[i];
            }
            ++i;
        }
        int[] result = new int[count];
        int j = 0;
        int i2 = 0;
        while (i2 < range.length) {
            if (range[i2] != 0) {
                result[j] = range[i2];
                ++j;
            }
            ++i2;
        }
        return result;
    }

    public void addCell(int col, int colSpan, int rowSpan, IStyle style) {
        XlsTable table = this.tables.peek();
        ContainerSizeInfo cellSizeInfo = table.getColumnSizeInfo(col, colSpan);
        this.addContainer(this.createCellContainer(cellSizeInfo, style, this.getCurrentContainer(), rowSpan));
    }

    public void endCell() {
        this.endContainer();
    }

    public void addRow(IStyle style) {
        XlsTable table = (XlsTable)this.containers.peek();
        XlsContainer container = this.createContainer(table.getSizeInfo(), style, table);
        container.setEmpty(false);
        this.addContainer(container);
    }

    public void endRow() {
        this.synchronize();
        this.endContainer();
    }

    private void synchronize() {
        XlsContainer rowContainer = this.getCurrentContainer();
        ContainerSizeInfo rowSizeInfo = rowContainer.getSizeInfo();
        int startCoordinate = rowSizeInfo.getStartCoordinate();
        int endCoordinate = rowSizeInfo.getEndCoordinate();
        int startColumnIndex = this.axis.getColumnIndexByCoordinate(startCoordinate);
        int endColumnIndex = this.axis.getColumnIndexByCoordinate(endCoordinate);
        int max = 0;
        int[] len = new int[endColumnIndex - startColumnIndex];
        int i = startColumnIndex;
        while (i < endColumnIndex) {
            int columnsize;
            len[i - startColumnIndex] = columnsize = this.cache.getStartRowId(i);
            max = max > columnsize ? max : columnsize;
            ++i;
        }
        i = startColumnIndex;
        while (i < endColumnIndex) {
            int rowspan = max - len[i - startColumnIndex];
            int last = len[i - startColumnIndex] - 1;
            if (rowspan > 0) {
                BlankData data = null;
                Data upstair = this.cache.getData(i, last);
                if (upstair != null && this.canSpan(upstair, rowContainer)) {
                    Data predata = upstair;
                    int rs = predata.getRowSpan() + rowspan;
                    predata.setRowSpan(rs);
                    BlankData blankData = new BlankData(this.getRealData(predata));
                    if (!this.isInContainer(predata, rowContainer)) {
                        blankData.decreasRowSpanInDesign();
                    }
                    data = blankData;
                } else {
                    data = new BlankData(null);
                }
                int p = 0;
                while (p < rowspan) {
                    this.cache.addData(i, data);
                    ++p;
                }
            }
            ++i;
        }
    }

    private boolean canSpan(Data data, XlsContainer rowContainer) {
        Data realData = this.getRealData(data);
        if (realData == null) {
            return false;
        }
        if (this.isInContainer(realData, rowContainer)) {
            return true;
        }
        return realData.getRowSpanInDesign() > 0;
    }

    private Data getRealData(Data data) {
        if (data.isBlank()) {
            return ((BlankData)data).getData();
        }
        return data;
    }

    private boolean isInContainer(Data data, XlsContainer rowContainer) {
        XlsContainer container = data.getContainer();
        while (container != null) {
            if (container == rowContainer) {
                return true;
            }
            container = container.getParent();
        }
        return false;
    }

    public void endTable() {
        if (!this.tables.isEmpty()) {
            this.tables.pop();
            this.endContainer();
        }
    }

    public void addContainer(IStyle style, HyperlinkDef link) {
        XlsContainer parent = this.getCurrentContainer();
        ContainerSizeInfo sizeInfo = parent.getSizeInfo();
        StyleEntry entry = this.engine.createEntry(sizeInfo, style);
        this.addContainer(new XlsContainer(entry, sizeInfo, parent));
    }

    public void addContainer(XlsContainer container) {
        this.getCurrentContainer().setEmpty(false);
        int startColumnIndex = this.axis.getColumnIndexByCoordinate(container.getSizeInfo().getStartCoordinate());
        int startRowId = this.cache.getStartRowId(startColumnIndex);
        container.setStartRowId(startRowId);
        this.containers.push(container);
    }

    public void endContainer() {
        XlsContainer container = this.getCurrentContainer();
        if (container.isEmpty()) {
            Data data = new Data(EMPTY, container.getStyle(), "STRING", container);
            data.setSizeInfo(container.getSizeInfo());
            this.addData(data);
        }
        this.engine.removeContainerStyle();
        this.containers.pop();
    }

    public void addData(Object txt, IStyle style, HyperlinkDef link, BookmarkDef bookmark) {
        ContainerSizeInfo rule = this.getCurrentContainer().getSizeInfo();
        StyleEntry entry = this.engine.getStyle(style, rule);
        Data data = this.createData(txt, entry);
        data.setHyperlinkDef(link);
        data.setBookmark(bookmark);
        data.setSizeInfo(rule);
        this.addData(data);
    }

    public void addDateTime(Object txt, IStyle style, HyperlinkDef link, BookmarkDef bookmark) {
        ContainerSizeInfo rule = this.getCurrentContainer().getSizeInfo();
        StyleEntry entry = this.engine.getStyle(style, rule);
        Data data = null;
        IDataContent dataContent = (IDataContent)txt;
        Object value = dataContent.getValue();
        java.util.Date date = ExcelUtil.getDate(value);
        if (date != null && (date instanceof Time || date.getYear() >= 0)) {
            data = this.createDateData(value, entry, style.getDateTimeFormat());
            data.setHyperlinkDef(link);
            data.setBookmark(bookmark);
            data.setSizeInfo(rule);
            this.addData(data);
        } else {
            this.addData(dataContent.getText(), style, link, bookmark);
        }
    }

    public void addCaption(String text) {
        ContainerSizeInfo rule = this.getCurrentContainer().getSizeInfo();
        StyleEntry entry = StyleBuilder.createEmptyStyleEntry();
        entry.setProperty(8, "Center");
        Data data = this.createData(text, entry);
        data.setSizeInfo(rule);
        this.addData(data);
    }

    public Data createData(Object txt, StyleEntry entry) {
        String type = "STRING";
        Locale locale = this.emitter.getLocale();
        if ("NUMBER".equals(ExcelUtil.getType(txt))) {
            String format = ExcelUtil.getPattern(txt, entry.getProperty(23));
            format = ExcelUtil.formatNumberPattern(format, locale);
            entry.setProperty(23, format);
            type = "NUMBER";
        } else if ("DATE".equals(ExcelUtil.getType(txt))) {
            String format = ExcelUtil.getPattern(txt, entry.getProperty(22));
            entry.setProperty(22, format);
            type = "DATE";
        }
        entry.setProperty(25, type);
        return new Data(txt, entry, type, this.getCurrentContainer());
    }

    private Data createDateData(Object txt, StyleEntry entry, String timeFormat) {
        Locale locale = this.emitter.getLocale();
        timeFormat = (timeFormat = ExcelUtil.parse(timeFormat, locale)).equals(EMPTY) ? (txt instanceof Date ? DateTimeUtil.formatDateTime("MMM d, yyyy", locale) : (txt instanceof Time ? DateTimeUtil.formatDateTime("H:mm:ss AM/PM", locale) : DateTimeUtil.formatDateTime("MMM d, yyyy H:mm AM/PM", locale))) : DateTimeUtil.formatDateTime(timeFormat, locale);
        entry.setProperty(22, timeFormat);
        entry.setProperty(25, "DATE");
        return new Data(txt, entry, "DATE", this.getCurrentContainer());
    }

    private void addData(Data data) {
        XlsContainer container = this.getCurrentContainer();
        container.setEmpty(false);
        int col = this.axis.getColumnIndexByCoordinate(data.getRule().getStartCoordinate());
        int span = this.axis.getColumnIndexByCoordinate(data.getRule().getEndCoordinate()) - col;
        this.addDatatoCache(col, data);
        int i = col + 1;
        while (i < col + span) {
            this.addDatatoCache(i, BlankData.BLANK);
            ++i;
        }
        if (container instanceof XlsCell) {
            XlsCell cell = (XlsCell)container;
            data.setRowSpanInDesign(cell.getRowSpan() - 1);
        }
    }

    public XlsContainer createContainer(ContainerSizeInfo sizeInfo, IStyle style, XlsContainer parent) {
        return new XlsContainer(this.engine.createEntry(sizeInfo, style), sizeInfo, parent);
    }

    public XlsContainer createCellContainer(ContainerSizeInfo sizeInfo, IStyle style, XlsContainer parent, int rowSpan) {
        return new XlsCell(this.engine.createEntry(sizeInfo, style), sizeInfo, parent, rowSpan);
    }

    public Map<StyleEntry, Integer> getStyleMap() {
        return this.engine.getStyleIDMap();
    }

    public List<BookmarkDef> getNamesRefer() {
        return this.cache.getBookmarks();
    }

    public int[] getCoordinates() {
        int[] coord = this.axis.getColumnWidths();
        if (coord.length <= MAX_COLUMN) {
            return coord;
        }
        int[] ncoord = new int[MAX_COLUMN];
        System.arraycopy(coord, 0, ncoord, 0, MAX_COLUMN);
        return ncoord;
    }

    public int getRowCount() {
        int realcount = this.cache.getMaxRow();
        return realcount;
    }

    public AxisProcessor getAxis() {
        return this.axis;
    }

    public int getColumnSize(int column) {
        return this.cache.getStartRowId(column);
    }

    public Data getData(int col, int row) {
        Data object = this.cache.getData(col, row);
        Data data = object;
        if (data == null || data.isBlank()) {
            return null;
        }
        return data;
    }

    public Data[] getRow(int rownum) {
        Data[] row = this.cache.getRowData(rownum);
        ArrayList<Data> data = new ArrayList<Data>();
        int width = Math.min(row.length, MAX_COLUMN - 1);
        int i = 0;
        while (i < width) {
            Data d = row[i];
            if (!d.isBlank() && !d.isProcessed()) {
                d.setProcessed(true);
                data.add(row[i]);
            }
            ++i;
        }
        Data[] rowdata = new Data[data.size()];
        data.toArray(rowdata);
        return rowdata;
    }

    private void addDatatoCache(int col, Data value) {
        this.cache.addData(col, value);
    }

    public void complete() {
        int rowcount = this.cache.getMaxRow();
        int i = 0;
        while (i < rowcount) {
            Data[] row = this.cache.getRowData(i);
            int j = 0;
            while (j < row.length) {
                Data d = row[j];
                if (!d.isBlank()) {
                    int styleid = this.engine.getStyleID(d.getStyleEntry());
                    d.setStyleId(styleid);
                    ContainerSizeInfo rule = d.getRule();
                    int start = this.axis.getColumnIndexByCoordinate(rule.getStartCoordinate()) + 1;
                    int end = this.axis.getColumnIndexByCoordinate(rule.getEndCoordinate()) + 1;
                    end = Math.min(end, MAX_COLUMN);
                    int scount = Math.max(0, end - start - 1);
                    Span span = new Span(start, scount);
                    HyperlinkDef link = d.getHyperlinkDef();
                    if (link != null && link.getBookmark() != null) {
                        this.links.put(link.getBookmark(), this.getCellName(i + 1, start + 1));
                    }
                    d.setSpan(span);
                }
                ++j;
            }
            ++i;
        }
    }

    private String getCellName(int row, int col) {
        char base = (char)(col + 64);
        Character chr = new Character(base);
        return String.valueOf(chr.toString()) + row;
    }

    public void addContainerStyle(IStyle computedStyle) {
        this.engine.addContainderStyle(computedStyle);
    }

    public void removeContainerStyle() {
        this.engine.removeForeignContainerStyle();
    }
}

